/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * vim:expandtab:autoindent:tabstop=4:shiftwidth=4:filetype=c:cindent:textwidth=0:
 *
 * Copyright (C) 2005 Dell Inc.
 *  by Michael Brown <Michael_E_Brown@dell.com>
 * Licensed under the Open Software License version 2.1
 *
 * Alternatively, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */

// compat header should always be first header if including system headers
#include "smbios/compat.h"

#include <iostream>
#include <iomanip>

#include "RbuImpl.h"

// always include last if included.
#include "smbios/message.h"  // not needed outside of this lib. (mainly for gettext i18n)

using namespace std;

namespace rbu
{
    // bits 8:10 are hw rev id, extract them and paste the rest together
    static u16 extractSystemId(u16 val)
    {
        return (val & 0xFF) | ((val & 0xF800) >> 3);
    }

    static struct rbu_hdr_file_header getHdr(string fileName)
    {
        struct rbu_hdr_file_header hdr;
        memset(&hdr, 0, sizeof(hdr));

        FILE *hdr_fh = fopen(fileName.c_str(), "rb");
        if(!hdr_fh)
            throw exception();

        fread(&hdr, 1, sizeof(hdr), hdr_fh);
        fclose(hdr_fh);

        return hdr;
    }

    bool checkSystemId(string fileName, u16 sysId )
    {
        struct rbu_hdr_file_header hdr = getHdr(fileName);
        for (int i=0; i<hdr.numSystems; i++)
            if( extractSystemId(hdr.systemIdList[i]) == sysId )
                return true;

        return false;
    }

     std::string getHdrBiosVer(std::string fileName)
     {
        struct rbu_hdr_file_header hdr = getHdr(fileName);
        return hdr.biosVersion;
     }

    
    void dumpHdrInfo(string fileName)
    {
        cout << "file: " << fileName << endl;

        struct rbu_hdr_file_header hdr = getHdr(fileName);

        cout << "HeaderId: " 
            << hdr.headerId[0]
            << hdr.headerId[1]
            << hdr.headerId[2]
            << hdr.headerId[3] << endl;

        cout << "Header Length: " << static_cast<int>(hdr.headerLength) << endl;
        cout << "Header Major Ver: " << static_cast<int>(hdr.headerMajorVer) << endl;
        cout << "Header Minor Ver: " << static_cast<int>(hdr.headerMinorVer) << endl;
        cout << "Num Systems: " << static_cast<int>(hdr.numSystems) << endl;

        cout << "Version: " << hdr.biosVersion << endl;

        char quickCheck[41] = {0};
        strncpy(quickCheck, hdr.quickCheck, 40);
        cout << "Quick Check: " << quickCheck << endl;

        cout << "System ID List:" << hex;
        for (int i=0; i<hdr.numSystems; i++)
            cout << " 0x" << setfill ('0') << setw (4) << static_cast<int>(extractSystemId(hdr.systemIdList[i])); 
        cout << endl;
    }
}

