////////////////////////////////////////////////////////////
//
// SFML - Simple and Fast Multimedia Library
// Copyright (C) 2007 Laurent Gomila (laurent.gom@gmail.com)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
////////////////////////////////////////////////////////////

#ifndef SFML_GRAPHICSDEVICE_HPP
#define SFML_GRAPHICSDEVICE_HPP

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/System/NonCopyable.hpp>
#include <set>


namespace sf
{
class VideoResource;

namespace priv
{
class WindowImpl;

////////////////////////////////////////////////////////////
/// GraphicsDevice manages graphics stuff using OpenGL
////////////////////////////////////////////////////////////
class GraphicsDevice : NonCopyable
{
public :

    ////////////////////////////////////////////////////////////
    /// Get the unique instance of the class
    ///
    /// \return Reference to the GraphicsDevice instance
    ///
    ////////////////////////////////////////////////////////////
    static GraphicsDevice& GetInstance();

    ////////////////////////////////////////////////////////////
    /// Add a video resource
    ///
    /// \param Resource : Resource to add
    ///
    ////////////////////////////////////////////////////////////
    void AddVideoResource(VideoResource* Resource);

    ////////////////////////////////////////////////////////////
    /// Remove a video resource
    ///
    /// \param Resource : Resource to remove
    ///
    ////////////////////////////////////////////////////////////
    void RemoveVideoResource(VideoResource* Resource);

private :

    ////////////////////////////////////////////////////////////
    /// Default constructor
    ///
    ////////////////////////////////////////////////////////////
    GraphicsDevice();

    ////////////////////////////////////////////////////////////
    /// Destructor
    ///
    ////////////////////////////////////////////////////////////
    ~GraphicsDevice();

    ////////////////////////////////////////////////////////////
    // Member data
    ////////////////////////////////////////////////////////////
    std::set<VideoResource*> myResources;  ///< List of active video resources
};

} // namespace priv

} // namespace sf


#endif // SFML_GRAPHICSDEVICE_HPP
