////////////////////////////////////////////////////////////
//
// SFML - Simple and Fast Multimedia Library
// Copyright (C) 2007 Laurent Gomila (laurent.gom@gmail.com)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
////////////////////////////////////////////////////////////

#ifndef SFML_VIEW_HPP
#define SFML_VIEW_HPP

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/Config.hpp>
#include <SFML/Graphics/Rect.hpp>


namespace sf
{
////////////////////////////////////////////////////////////
/// This class defines a view (position, size and zoom) ;
/// you can consider it as a camera
////////////////////////////////////////////////////////////
class SFML_API View
{
public :

    ////////////////////////////////////////////////////////////
    /// Construct the view with position and size
    ///
    /// \param ViewRect : Rectangle defining the position and size of the view
    /// \param ViewZoom : Zoom factor (1 by default)
    ///
    ////////////////////////////////////////////////////////////
    View(const FloatRect& ViewRect = FloatRect(0, 0, 1000, 1000), float ViewZoom = 1.f);

    ////////////////////////////////////////////////////////////
    // Member data
    ////////////////////////////////////////////////////////////
    FloatRect Rect; ///< Rectangle defining the view's position and size
    float     Zoom; ///< Zoom (less than 1 is unzoom, greater than 1 is zoom)
};

} // namespace sf


#endif // SFML_VIEW_HPP
