
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libsexymm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "icon-entry.h"
#include "spell-entry.h"
#include "tooltip.h"
#include "tree-view.h"
#include "url-label.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType sexy_icon_entry_get_type(void);
GType sexy_spell_entry_get_type(void);
GType sexy_tooltip_get_type(void);
GType sexy_tree_view_get_type(void);
GType sexy_url_label_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Sexy {  class IconEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Sexy {  class SpellEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Sexy {  class Tooltip_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Sexy {  class TreeView_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Sexy {  class UrlLabel_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Sexy { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(sexy_icon_entry_get_type(), &Sexy::IconEntry_Class::wrap_new);
  Glib::wrap_register(sexy_spell_entry_get_type(), &Sexy::SpellEntry_Class::wrap_new);
  Glib::wrap_register(sexy_tooltip_get_type(), &Sexy::Tooltip_Class::wrap_new);
  Glib::wrap_register(sexy_tree_view_get_type(), &Sexy::TreeView_Class::wrap_new);
  Glib::wrap_register(sexy_url_label_get_type(), &Sexy::UrlLabel_Class::wrap_new);

  // Register the gtkmm gtypes:
  Sexy::IconEntry::get_type();
  Sexy::SpellEntry::get_type();
  Sexy::Tooltip::get_type();
  Sexy::TreeView::get_type();
  Sexy::UrlLabel::get_type();

} // wrap_init()

} //Sexy


