/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Abstract Syntax Trees for mathematical expressions.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * <a target='_blank'
 * href='http://en.wikipedia.org/wiki/Abstract_syntax_tree'>Abstract Syntax
 * Trees</a> (ASTs) are a simple kind of data structure used in libSBML for
 * storing mathematical expressions.  LibSBML ASTs provide a canonical,
 * in-memory representation for all mathematical formulas regardless of their
 * original format (which might be MathML or might be text strings).
 <p>
 * <p>
 * An AST <em>node</em> in libSBML is a recursive tree structure; each node has a
 * type, a pointer to a value, and a list of children nodes.  Each {@link ASTNode}
 * node may have none, one, two, or more children depending on its type.
 * There are node types to represent numbers (with subtypes to distinguish
 * integer, real, and rational numbers), names (e.g., constants or
 * variables), simple mathematical operators, logical or relational operators
 * and functions.  The following diagram illustrates an example of how the
 * mathematical expression <code>'1 + 2'</code> is represented as an AST with
 * one <em>plus</em> node having two <em>integer</em> children nodes for the numbers
 * <code>1</code> and <code>2</code>.  The figure also shows the
 * corresponding MathML representation:
 <p>
 * <table border="0" class="centered text-table width80 normal-font" style="padding-bottom: 0.5em">
<caption class="top-caption">Example AST representation of a mathematical expression.</caption>
<tr>
<th width="50px">Infix</th>
<th>AST</th>
<th>MathML</th>
</tr>
<tr>
<td valign="middle" align="center">
<code>1 + 2</code>
</td>
<td valign="middle">
  <object type="image/svg+xml" data="simple-ast.svg" class="centered" width="140px"></object>
</td>
<td valign="middle">
<code>&lt;math xmlns="http://www.w3.org/1998/Math/MathML"&gt;</code><br>
<code>&nbsp;&nbsp;&lt;apply&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;plus/&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;cn type="integer"&gt; 1 &lt;/cn&gt;</code><br>
<code>&nbsp;&nbsp;&nbsp;&nbsp;&lt;cn type="integer"&gt; 2 &lt;/cn&gt;</code><br>
<code>&nbsp;&nbsp;&lt;/apply&gt;</code><br>
<code>&lt;/math&gt;</code>
</td>
</tr>
</table>

 <p>
 * The following are other noteworthy points about the AST representation
 * in libSBML:
<p>
 * <ul>
 * <li> A numerical value represented in MathML as a real number with an
 * exponent is preserved as such in the AST node representation, even if the
 * number could be stored in a <code>double</code> data type.  This is done so that
 * when an SBML model is read in and then written out again, the amount of
 * change introduced by libSBML to the SBML during the round-trip activity is
 * minimized.
 <p>
 * <li> Rational numbers are represented in an AST node using separate
 * numerator and denominator values.  These can be retrieved using the
 * methods {@link ASTNode#getNumerator()} and {@link ASTNode#getDenominator()}.
 <p>
 * <li> The children of an {@link ASTNode} are other {@link ASTNode} objects.  The list of
 * children is empty for nodes that are leaf elements, such as numbers.
 * For nodes that are actually roots of expression subtrees, the list of
 * children points to the parsed objects that make up the rest of the
 * expression.
 *
 * </ul> <p>
 * For many applications, the details of ASTs are irrelevant because libSBML
 * provides text-string based translation functions such as
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a> and
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>.  If you find the complexity
 * of using the AST representation of expressions too high for your purposes,
 * perhaps the string-based functions will be more suitable.
 <p>
 * <h3><a class='anchor'
 * name='ASTNodeType_t'>The set of possible ASTNode types</a></h3> 
 <p>
 * <p>
 * Every {@link ASTNode} has an associated type code to indicate whether, for
 * example, it holds a number or stands for an arithmetic operator.
 <p>
 * The type is recorded as a value drawn from a
 * set of static integer constants defined in the class {@link 
 * libsbmlConstants}. Their names begin with the characters <code>AST_.</code>
 <p>
 * The list of possible types is quite long, because it covers all the
 * mathematical functions that are permitted in SBML. The values are shown
 * in the following table:
 <p>
 * <table border="0" class="centered text-table align-bottom borderless code">
<tr><td>AST_CONSTANT_E</td><td>         AST_FUNCTION_CSC</td><td>                       AST_LOGICAL_AND</td></tr>
<tr><td>AST_CONSTANT_FALSE</td><td>     AST_FUNCTION_CSCH</td><td>                      AST_LOGICAL_IMPLIES<sup>2</sup></td></tr>
<tr><td>AST_CONSTANT_PI</td><td>        AST_FUNCTION_DELAY</td><td>                     AST_LOGICAL_NOT</td></tr>
<tr><td>AST_CONSTANT_TRUE</td><td>      AST_FUNCTION_EXP</td><td>                       AST_LOGICAL_OR</td></tr>
<tr><td>AST_DIVIDE</td><td>             AST_FUNCTION_FACTORIAL</td><td>                 AST_LOGICAL_XOR</td></tr>
<tr><td>AST_FUNCTION</td><td>           AST_FUNCTION_FLOOR</td><td>                     AST_MINUS</td></tr>
<tr><td>AST_FUNCTION_ABS</td><td>       AST_FUNCTION_LN</td><td>                        AST_NAME</td></tr>
<tr><td>AST_FUNCTION_ARCCOS</td><td>    AST_FUNCTION_LOG</td><td>                       AST_NAME_AVOGADRO<sup>1</sup></td></tr>
<tr><td>AST_FUNCTION_ARCCOSH</td><td>   AST_FUNCTION_MAX<sup>2</sup></td><td>           AST_NAME_TIME</td></tr>
<tr><td>AST_FUNCTION_ARCCOT</td><td>    AST_FUNCTION_MIN<sup>2</sup></td><td>           AST_ORIGINATES_IN_PACKAGE<sup>2</sup></tr>
<tr><td>AST_FUNCTION_ARCCOTH</td><td>   AST_FUNCTION_PIECEWISE</td><td>                 AST_PLUS</td></tr>
<tr><td>AST_FUNCTION_ARCCSC</td><td>    AST_FUNCTION_POWER</td><td>                     AST_POWER</td></tr>
<tr><td>AST_FUNCTION_ARCCSCH</td><td>   AST_FUNCTION_QUOTIENT<sup>2</sup></td><td>      AST_RATIONAL</td></tr>
<tr><td>AST_FUNCTION_ARCSEC</td><td>    AST_FUNCTION_RATE_OF<sup>2</sup></td><td>       AST_REAL</td></tr>
<tr><td>AST_FUNCTION_ARCSECH</td><td>   AST_FUNCTION_REM<sup>2</sup></td><td>           AST_REAL_E</td></tr>
<tr><td>AST_FUNCTION_ARCSIN</td><td>    AST_FUNCTION_ROOT</td><td>                      AST_RELATIONAL_EQ</td></tr>
<tr><td>AST_FUNCTION_ARCSINH</td><td>   AST_FUNCTION_SEC</td><td>                       AST_RELATIONAL_GEQ</td></tr>
<tr><td>AST_FUNCTION_ARCTAN</td><td>    AST_FUNCTION_SECH</td><td>                      AST_RELATIONAL_GT</td></tr>
<tr><td>AST_FUNCTION_ARCTANH</td><td>   AST_FUNCTION_SIN</td><td>                       AST_RELATIONAL_LEQ</td></tr>
<tr><td>AST_FUNCTION_CEILING</td><td>   AST_FUNCTION_SINH</td><td>                      AST_RELATIONAL_LT</td></tr>
<tr><td>AST_FUNCTION_COS</td><td>       AST_FUNCTION_TAN</td><td>                       AST_RELATIONAL_NEQ</td></tr>
<tr><td>AST_FUNCTION_COSH</td><td>      AST_FUNCTION_TANH</td><td>                      AST_TIMES</td></tr>
<tr><td>AST_FUNCTION_COT</td><td>       AST_INTEGER</td><td>                            AST_UNKNOWN</td></tr>
<tr><td>AST_FUNCTION_COTH</td><td>      AST_LAMBDA</td></tr>
<tr><td><sup>1</sup> <span class='warning'><em>(Level&nbsp;3 only)</em></span><br/></td></tr>
<tr><td><sup>2</sup> <span class='warning'><em>(Level&nbsp;3 Version&nbsp;2+ only)</em></span></td></tr>
</table>



 <p>
 * The types have the following meanings:
 <p>
 * <ul>
 * <li> If the node is basic mathematical operator (e.g., <code>'+'</code>), then the
 * node's type will be {@link libsbmlConstants#AST_PLUS AST_PLUS},
 * {@link libsbmlConstants#AST_MINUS AST_MINUS},
 * {@link libsbmlConstants#AST_TIMES AST_TIMES},
 * {@link libsbmlConstants#AST_DIVIDE AST_DIVIDE}, or
 * {@link libsbmlConstants#AST_POWER AST_POWER}, as appropriate.
 <p>
 * <li> If the node is a predefined function or operator from SBML
 * Level&nbsp;1 (in the string-based formula syntax used in Level&nbsp;1) or
 * SBML Level&nbsp;2 and&nbsp;3 (in the subset of MathML used in SBML
 * Levels&nbsp;2 and&nbsp;3), then the node's type
 * will be either <code style='margin-right: 0'>AST_FUNCTION_</code><span
 * class='placeholder-nospace'>X</span>, <code style='margin-right: 0'>AST_LOGICAL_</code><span
 * class='placeholder-nospace'>X</span>, or <code style='margin-right: 0'>AST_RELATIONAL_</code><span
 * class='placeholder-nospace'>X</span>, as appropriate.  (Examples:
 * {@link libsbmlConstants#AST_FUNCTION_LOG AST_FUNCTION_LOG},
 * {@link libsbmlConstants#AST_RELATIONAL_LEQ AST_RELATIONAL_LEQ}.)
 <p>
 * <li> If the node refers to a user-defined function, the node's type will
 * be {@link libsbmlConstants#AST_FUNCTION AST_FUNCTION} (because it holds the
 * name of the function).
 <p>
 * <li> If the node is a lambda expression, its type will be
 * {@link libsbmlConstants#AST_LAMBDA AST_LAMBDA}.
 <p>
 * <li> If the node is a predefined constant (<code>'ExponentialE'</code>, <code>'Pi'</code>, 
 * <code>'True'</code> or <code>'False'</code>), then the node's type will be
 * {@link libsbmlConstants#AST_CONSTANT_E AST_CONSTANT_E},
 * {@link libsbmlConstants#AST_CONSTANT_PI AST_CONSTANT_PI},
 * {@link libsbmlConstants#AST_CONSTANT_TRUE AST_CONSTANT_TRUE}, or
 * {@link libsbmlConstants#AST_CONSTANT_FALSE AST_CONSTANT_FALSE}.
 <p>
 * <li> (Levels&nbsp;2 and&nbsp;3 only) If the node is the special MathML
 * csymbol <code>time</code>, the value of the node will be
 * {@link libsbmlConstants#AST_NAME_TIME AST_NAME_TIME}.  (Note, however, that the
 * MathML csymbol <code>delay</code> is translated into a node of type
 * {@link libsbmlConstants#AST_FUNCTION_DELAY AST_FUNCTION_DELAY}.  The difference is due to
 * the fact that <code>time</code> is a single variable, whereas <code>delay</code> is actually a
 * function taking arguments.)
 <p>
 * <li> (Level&nbsp;3 only) If the node is the special MathML csymbol 
 * <code>avogadro</code>, the value of the node will be
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO}.
 <p>
 * <li> (Level&nbsp;3 Version&nbsp;2+ only) If the node is the special MathML csymbol 
 * <code>rateOf</code>, the value of the node will be
 * {@link libsbmlConstants#AST_FUNCTION_RATE_OF AST_FUNCTION_RATE_OF}.
 <p>
 * <li> (Level&nbsp;3 Version&nbsp;2+ only) If the node is a MathML 
 * operator that originates in a package, and is not defined in SBML 
 * Leve&nbsp;3 core, the value of the node will be
 * {@link libsbmlConstants#AST_ORIGINATES_IN_PACKAGE AST_ORIGINATES_IN_PACKAGE}.
 <p>
 * <li> If the node contains a numerical value, its type will be
 * {@link libsbmlConstants#AST_INTEGER AST_INTEGER},
 * {@link libsbmlConstants#AST_REAL AST_REAL},
 * {@link libsbmlConstants#AST_REAL_E AST_REAL_E}, or
 * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, as appropriate.
 *
 * </ul>
 <p>
 * <h3><a class='anchor' name='math-convert'>Converting between ASTs and text
 * strings</a></h3>
 <p>
 * The text-string form of mathematical formulas produced by
 * <a href='libsbml.html#formulaToString(java.lang.String)'><code>libsbml.formulaToString(String)</code></a> and
 * <a href='libsbml.html#formulaToL3String(java.lang.String)'><code>libsbml.formulaToL3String(String)</code></a>, and read by
 * <a href='libsbml.html#parseFormula(org.sbml.libsbml.ASTNode)'><code>libsbml.parseFormula(ASTNode)</code></a> and
 * <a href='libsbml.html#parseL3Formula(org.sbml.libsbml.ASTNode)'><code>libsbml.parseL3Formula(ASTNode)</code></a>, are in a simple C-inspired
 * infix notation.  A formula in one of these two text-string formats can be
 * handed to a program that understands SBML mathematical expressions, or
 * used as part of a translation system.  The libSBML distribution comes with
 * example programs in the <code>'examples'</code> subdirectory that demonstrate such
 * things as translating infix formulas into MathML and vice-versa.
 <p>
 * Please see the documentation for the functions <a href='libsbml.html#parseFormula(org.sbml.libsbml.ASTNode)'><code>libsbml.parseFormula(ASTNode)</code></a> and <a href='libsbml.html#parseL3Formula(org.sbml.libsbml.ASTNode)'><code>libsbml.parseL3Formula(ASTNode)</code></a> for detailed
 * explanations of the infix syntax they accept.
 <p>
 * <h3><a class='anchor' name='math-interpretation'>Interpretation</a></h3>
 <p>
 * Proper mathematical interpretation of an {@link ASTNode} requires an 
 * understanding of all the allowed MathML operators, the SBML-specific 
 * csymbols, and of the named variables in the SBML model.  It is 
 * important to note that an invalid {@link ASTNode} might not have a proper 
 * mathematical interpretation--a 'minus' node with three children is 
 * simply illegal, and cannot be interpreted.  Similarly, a named variable 
 * that does not exist in the {@link Model} also cannot be interpreted.  In SBML 
 * Level&nbsp;3 Version&nbsp;2, the ability was added to reference named 
 * variables in MathML that might exist in SBML Level&nbsp;3 packages.  
 * This means that if the software reading the SBML file (or this version 
 * of libsbml) does not understand that package, MathML using named variables 
 * from those packages will be legal, but will not be interpretable.  It 
 * is valid to issue a warning in this case, and may be otherwise handled 
 * as if an invalid variable name was used.  In all cases, the 'required' 
 * attribute for the package in question must be set to 'true'.
 <p>
 * <h3><a class='anchor' name='math-history'>Historical notes</a></h3>
 <p>
 * Readers may wonder why this part of libSBML uses a seemingly less
 * object-oriented design than other parts.  Originally, much of libSBML was
 * written in&nbsp;C.  All subsequent development was done in C++, but the
 * complexity of some of the functionality for converting between infix, AST
 * and MathML, coupled with the desire to maintain stability and backward
 * compatibility, means that some of the underlying code is still written
 * in&nbsp;C.  This has lead to the exposed API being more C-like.
<p>
 * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a>
 * @see <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * @see <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a>
 * @see <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>
 * @see <a href='libsbml.html#getDefaultL3ParserSettings()'><code>libsbml.getDefaultL3ParserSettings()</code></a>
 */

public class ASTNode extends ASTBase {
   private long swigCPtr;

   protected ASTNode(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.ASTNode_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(ASTNode obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ASTNode obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ASTNode(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
   * Equality comparison method for ASTNode.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ASTNode)(sb));
  }

  /**
   * Returns a hashcode for this ASTNode object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/** * @internal */ public
 ASTNode(int type) {
    this(libsbmlJNI.new_ASTNode__SWIG_0(type), true);
  }

  
/** * @internal */ public
 ASTNode() {
    this(libsbmlJNI.new_ASTNode__SWIG_1(), true);
  }

  
/** * @internal */ public
 ASTNode(SBMLNamespaces sbmlns, int type) {
    this(libsbmlJNI.new_ASTNode__SWIG_2(SBMLNamespaces.getCPtr(sbmlns), sbmlns, type), true);
  }

  
/** * @internal */ public
 ASTNode(SBMLNamespaces sbmlns) {
    this(libsbmlJNI.new_ASTNode__SWIG_3(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a deep copy of the given {@link ASTNode}.
   <p>
   * @param orig the {@link ASTNode} to be copied.
   */ public
 ASTNode(ASTNode orig) {
    this(libsbmlJNI.new_ASTNode__SWIG_4(ASTNode.getCPtr(orig), orig), true);
  }

  
/**
   * Frees the name of this {@link ASTNode} and sets it to <code>null.</code>
   <p>
   * This operation is only applicable to {@link ASTNode} objects corresponding to
   * operators, numbers, or {@link libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}.  This
   * method has no effect on other types of nodes.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * </ul>
   */ public
 int freeName() {
    return libsbmlJNI.ASTNode_freeName(swigCPtr, this);
  }

  
/**
   * Converts this {@link ASTNode} to a canonical form.
   <p>
   * The rules determining the canonical form conversion are as follows:
   <p>
   * <ul>
   * <li> If the node type is {@link libsbmlConstants#AST_NAME AST_NAME}
   * and the node name matches <code>'ExponentialE'</code>, <code>'Pi'</code>, <code>'True'</code> or 
   * <code>'False'</code> the node type is converted to the corresponding
   * <code>AST_CONSTANT_</code><em><span class='placeholder'>X</span></em> type.
   * <li> If the node type is an {@link libsbmlConstants#AST_FUNCTION AST_FUNCTION} and
   * the node name matches an SBML (MathML) function name, logical operator name,
   * or relational operator name, the node is converted to the corresponding
   * <code>AST_FUNCTION_</code><em><span class='placeholder'>X</span></em> or
   * <code>AST_LOGICAL_</code><em><span class='placeholder'>X</span></em> type.
   *
   * </ul> <p>
   * SBML Level&nbsp;1 function names are searched first; thus, for example,
   * canonicalizing <code>log</code> will result in a node type of
   * {@link libsbmlConstants#AST_FUNCTION_LN AST_FUNCTION_LN}.  (See the SBML
   * Level&nbsp;1 Version&nbsp;2 Specification, Appendix C.)
   <p>
   * Sometimes, canonicalization of a node results in a structural conversion
   * of the node as a result of adding a child.  For example, a node with the
   * SBML Level&nbsp;1 function name <code>sqr</code> and a single child node (the
   * argument) will be transformed to a node of type
   * {@link libsbmlConstants#AST_FUNCTION_POWER AST_FUNCTION_POWER} with two children.  The
   * first child will remain unchanged, but the second child will be an
   * {@link ASTNode} of type {@link libsbmlConstants#AST_INTEGER AST_INTEGER} and a value of
   * 2.  The function names that result in structural changes are: <code>log10</code>,
   * <code>sqr</code>, and <code>sqrt.</code>
   <p>
   * @return <code>true</code> if this node was successfully converted to
   * canonical form, <code>false</code> otherwise.
   */ public
 boolean canonicalize() {
    return libsbmlJNI.ASTNode_canonicalize(swigCPtr, this);
  }

  
/**
   * Adds the given node as a child of this {@link ASTNode}.
   <p>
   * Child nodes are added in-order, from left to right.
   <p>
   * @param disownedChild the {@link ASTNode} instance to add.  
   * Will become a child of the parent node.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #prependChild(ASTNode disownedChild)
   * @see #replaceChild(long n, ASTNode disownedChild, boolean delreplaced)
   * @see #insertChild(long n, ASTNode disownedChild)
   * @see #removeChild(long n)
   * @see #isWellFormedASTNode()
   */ public
 int addChild(ASTNode disownedChild) {
    return libsbmlJNI.ASTNode_addChild(swigCPtr, this, ASTNode.getCPtrAndDisown(disownedChild), disownedChild);
  }

  
/**
   * Adds the given node as a child of this {@link ASTNode}.
   <p>
   * This method adds child nodes from right to left.
   <p>
   * @param disownedChild the {@link ASTNode} instance to add.
   * Will become a child of the parent node.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #addChild(ASTNode disownedChild)
   * @see #replaceChild(long n, ASTNode disownedChild, boolean delreplaced)
   * @see #insertChild(long n, ASTNode disownedChild)
   * @see #removeChild(long n)
   */ public
 int prependChild(ASTNode disownedChild) {
    return libsbmlJNI.ASTNode_prependChild(swigCPtr, this, ASTNode.getCPtrAndDisown(disownedChild), disownedChild);
  }

  
/**
   * Removes the nth child of this {@link ASTNode} object.
   <p>
   * @param n long the index of the child to remove.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #addChild(ASTNode disownedChild)
   * @see #prependChild(ASTNode disownedChild)
   * @see #replaceChild(long n, ASTNode disownedChild, boolean delreplaced)
   * @see #insertChild(long n, ASTNode disownedChild)
   */ public
 int removeChild(long n) {
    return libsbmlJNI.ASTNode_removeChild(swigCPtr, this, n);
  }

  
/**
   * Replaces the nth child of this {@link ASTNode} with the given {@link ASTNode}.
   <p>
   * @param n long the index of the child to replace.
   * @param disownedChild {@link ASTNode} to replace the nth child.
   * Will become a child of the parent node.
   * @param delreplaced boolean indicating whether to delete the replaced child.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #addChild(ASTNode disownedChild)
   * @see #prependChild(ASTNode disownedChild)
   * @see #insertChild(long n, ASTNode disownedChild)
   * @see #removeChild(long n)
   */ public
 int replaceChild(long n, ASTNode disownedChild, boolean delreplaced) {
    return libsbmlJNI.ASTNode_replaceChild__SWIG_0(swigCPtr, this, n, ASTNode.getCPtrAndDisown(disownedChild), disownedChild, delreplaced);
  }

  
/**
   * Replaces the nth child of this {@link ASTNode} with the given {@link ASTNode}.
   <p>
   * @param n long the index of the child to replace.
   * @param disownedChild {@link ASTNode} to replace the nth child.
   * Will become a child of the parent node.
   * @param delreplaced boolean indicating whether to delete the replaced child.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #addChild(ASTNode disownedChild)
   * @see #prependChild(ASTNode disownedChild)
   * @see #insertChild(long n, ASTNode disownedChild)
   * @see #removeChild(long n)
   */ public
 int replaceChild(long n, ASTNode disownedChild) {
    return libsbmlJNI.ASTNode_replaceChild__SWIG_1(swigCPtr, this, n, ASTNode.getCPtrAndDisown(disownedChild), disownedChild);
  }

  
/**
   * Inserts the given {@link ASTNode} node at a given point in the current {@link ASTNode}'s
   * list of children.
   <p>
   * @param n long the index of the {@link ASTNode} being added.
   * @param disownedChild {@link ASTNode} to insert as the nth child.
   * Will become a child of the parent node.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * <p>
 * @warning Explicitly adding, removing or replacing children of an
 * {@link ASTNode} object may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * {@link ASTNode#isWellFormedASTNode()}
 * may also be useful for checking the results of node modifications.
   <p>
   * @see #addChild(ASTNode disownedChild)
   * @see #prependChild(ASTNode disownedChild)
   * @see #replaceChild(long n, ASTNode disownedChild, boolean delreplaced)
   * @see #removeChild(long n)
   */ public
 int insertChild(long n, ASTNode disownedChild) {
    return libsbmlJNI.ASTNode_insertChild(swigCPtr, this, n, ASTNode.getCPtrAndDisown(disownedChild), disownedChild);
  }

  
/**
   * Creates a recursive copy of this node and all its children.
   <p>
   * @return a copy of this {@link ASTNode} and all its children.  The caller owns
   * the returned {@link ASTNode} and is responsible for deleting it.
   */ public
 ASTBase deepCopy() {
    long cPtr = libsbmlJNI.ASTNode_deepCopy(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
   * Returns the child at index n of this node.
   <p>
   * @param n the index of the child to get.
   <p>
   * @return the nth child of this {@link ASTNode} or <code>null</code> if this node has no nth
   * child (<code>n &gt; </code>
   * {@link ASTNode#getNumChildren()}
   * <code>- 1</code>).
   <p>
   * @see #getNumChildren()
   * @see #getLeftChild()
   * @see #getRightChild()
   */ public
 ASTNode getChild(long n) {
    long cPtr = libsbmlJNI.ASTNode_getChild(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Returns the left child of this node.
   <p>
   * @return the left child of this {@link ASTNode}.  This is equivalent to calling
   * {@link ASTNode#getChild(long)}
   * with an argument of <code>0.</code>
   <p>
   * @see #getNumChildren()
   * @see #getChild(long)
   * @see #getRightChild()
   */ public
 ASTNode getLeftChild() {
    long cPtr = libsbmlJNI.ASTNode_getLeftChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Returns the right child of this node.
   <p>
   * @return the right child of this {@link ASTNode}, or <code>null</code> if this node has no
   * right child.  If
   * {@link ASTNode#getNumChildren()}
   * <code>&gt; 1</code>, then this is equivalent to:
   * <pre class='fragment'>
getChild( getNumChildren() - 1 );
</pre>
   <p>
   * @see #getNumChildren()
   * @see #getLeftChild()
   * @see #getChild(long)
   */ public
 ASTNode getRightChild() {
    long cPtr = libsbmlJNI.ASTNode_getRightChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Returns the number of children of this node.
   <p>
   * @return the number of children of this {@link ASTNode}, or 0 is this node has
   * no children.
   */ public
 long getNumChildren() {
    return libsbmlJNI.ASTNode_getNumChildren(swigCPtr, this);
  }

  
/**
   * Adds the given {@link XMLNode} as a MathML <code>&lt;semantics&gt;</code>
   * element to this {@link ASTNode}.
   <p>
   * <p>
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
   <p>
   * @param disownedAnnotation the annotation to add.
   * Will become a child of the parent node.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   <p>
   * @see #getNumSemanticsAnnotations()
   * @see #getSemanticsAnnotation(long)
   */ public
 int addSemanticsAnnotation(XMLNode disownedAnnotation) {
    return libsbmlJNI.ASTNode_addSemanticsAnnotation(swigCPtr, this, XMLNode.getCPtrAndDisown(disownedAnnotation), disownedAnnotation);
  }

  
/**
   * Returns the number of MathML <code>&lt;semantics&gt;</code> element
   * elements on this node.
   <p>
   * <p>
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
   <p>
   * @return the number of annotations of this {@link ASTNode}.
   <p>
   * <p>
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   <p>
   * @see #addSemanticsAnnotation(XMLNode)
   * @see #getSemanticsAnnotation(long)
   */ public
 long getNumSemanticsAnnotations() {
    return libsbmlJNI.ASTNode_getNumSemanticsAnnotations(swigCPtr, this);
  }

  
/**
   * Returns the nth MathML <code>&lt;semantics&gt;</code> element on this
   * {@link ASTNode}.
   <p>
   * <p>
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
   <p>
   * @param n the index of the annotation to return.  Callers should
   * use {@link ASTNode#getNumSemanticsAnnotations()} to first find out how
   * many annotations there are.
   <p>
   * @return the nth annotation inside this {@link ASTNode}, or <code>null</code> if this node has
   * no nth annotation (<code>n &gt;</code>
   * {@link ASTNode#getNumSemanticsAnnotations()}
   * <code>- 1</code>).
   <p>
   * <p>
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   <p>
   * @see #addSemanticsAnnotation(XMLNode)
   * @see #getNumSemanticsAnnotations()
   */ public
 XMLNode getSemanticsAnnotation(long n) {
    long cPtr = libsbmlJNI.ASTNode_getSemanticsAnnotation(swigCPtr, this, n);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
/**
   * Returns the value of this node as a single character.
   <p>
   * This function should be called only when {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_MINUS AST_MINUS}, {@link libsbmlConstants#AST_TIMES AST_TIMES}, {@link libsbmlConstants#AST_DIVIDE AST_DIVIDE} or
   * {@link libsbmlConstants#AST_POWER AST_POWER}.
   <p>
   * @return the value of this {@link ASTNode} as a single character.
   */ public
 char getCharacter() {
    return libsbmlJNI.ASTNode_getCharacter(swigCPtr, this);
  }

  
/**
   * Returns the MathML <code>id</code> attribute value of this {@link ASTNode}.
   <p>
   * @return the MathML id of this {@link ASTNode}.
   <p>
   * @see #isSetId()
   * @see #setId(String id)
   * @see #unsetId()
   */ public
 String getId() {
    return libsbmlJNI.ASTNode_getId(swigCPtr, this);
  }

  
/**
   * Returns the MathML <code>class</code> attribute value of this {@link ASTNode}.
   <p>
   * @return the MathML class of this {@link ASTNode}, if any exists.
   <p>
   * @see #isSetClass()
   * @see #setClassName(String id)
   * @see #unsetClass()
   */ public
 String getClassName() {
    return libsbmlJNI.ASTNode_getClassName(swigCPtr, this);
  }

  
/**
   * Returns the MathML <code>style</code> attribute value of this {@link ASTNode}.
   <p>
   * @return the MathML style of this {@link ASTNode}, if any exists.
   <p>
   * @see #isSetStyle()
   * @see #setStyle(String id)
   * @see #unsetStyle()
   */ public
 String getStyle() {
    return libsbmlJNI.ASTNode_getStyle(swigCPtr, this);
  }

  
/**
   * Returns the value of this node as an integer.
   <p>
   * If this node type is {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, this
   * method returns the value of the numerator.
   <p>
   * @return the value of this {@link ASTNode} as a (<code>long</code>) integer if type {@link libsbmlConstants#AST_INTEGER AST_INTEGER}; the numerator if type {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, and <code>0</code> otherwise.
   <p>
   * @note This function should be called only when
   * {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_INTEGER AST_INTEGER} or
   * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   * It will return <code>0</code> if the node type is <em>not</em> one of these, but since
   * <code>0</code> may be a valid value for integer, it is important to be sure that
   * the node type is one of the expected types in order to understand if 
   * <code>0</code> is the actual value.
   <p>
   * @see #getNumerator()
   */ public
 int getInteger() {
    return libsbmlJNI.ASTNode_getInteger(swigCPtr, this);
  }

  
/**
   * Returns the value of this node as a string.
   <p>
   * This function may be called on nodes that (1) are not operators, i.e.,
   * nodes for which {@link ASTNode#isOperator()}
   * returns <code>false</code>, and (2) are not numbers, i.e.,
   * {@link ASTNode#isNumber()} returns <code>false.</code>
   <p>
   * @return the value of this {@link ASTNode} as a string, or <code>null</code> if it is
   * a node that does not have a name equivalent (e.g., if it is a number).
   */ public
 String getName() {
    return libsbmlJNI.ASTNode_getName(swigCPtr, this);
  }

  
/**
   * Returns the value of this operator node as a string.
   <p>
   * This function may be called on nodes that are operators, i.e., nodes for
   * which {@link ASTNode#isOperator()} returns
   * <code>true.</code>
   <p>
   * @return the name of this operator {@link ASTNode} as a string (or <code>null</code> if not
   * an operator).
   */ public
 String getOperatorName() {
    return libsbmlJNI.ASTNode_getOperatorName(swigCPtr, this);
  }

  
/**
   * Returns the value of the numerator of this node if of type {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, or the numerical value of the node if of type {@link libsbmlConstants#AST_INTEGER AST_INTEGER}; <code>0</code> otherwise.
   <p>
   * This function should be called only when
   * {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL} or
   * {@link libsbmlConstants#AST_INTEGER AST_INTEGER}.
   * It will return <code>0</code> if the node type is another type, but since <code>0</code> may
   * be a valid value for the denominator of a rational number or of an integer, it is
   * important to be sure that the node type is the correct type in order to
   * correctly interpret the returned value.
   <p>
   * @return the value of the numerator of this {@link ASTNode} if {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, the value if {@link libsbmlConstants#AST_INTEGER AST_INTEGER}, or <code>0</code> otherwise.
   <p>
   * @see #getDenominator()
   * @see #getInteger()
   */ public
 int getNumerator() {
    return libsbmlJNI.ASTNode_getNumerator(swigCPtr, this);
  }

  
/**
   * Returns the value of the denominator of this node.
   <p>
   * @return the value of the denominator of this {@link ASTNode}, or <code>1</code> if
   * this node is not of type {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   <p>
   * @note This function should be called only when
   * {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   * It will return <code>1</code> if the node type is another type, but since <code>1</code> may
   * be a valid value for the denominator of a rational number, it is
   * important to be sure that the node type is the correct type in order to
   * correctly interpret the returned value.
   <p>
   * @see #getNumerator()
   */ public
 int getDenominator() {
    return libsbmlJNI.ASTNode_getDenominator(swigCPtr, this);
  }

  
/**
   * Returns the real-numbered value of this node.
   <p>
   * This function performs the necessary arithmetic if the node type is
   * {@link libsbmlConstants#AST_REAL_E AST_REAL_E} (<em>mantissa *
   * 10<sup>exponent</sup></em>) or
   * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}
   * (<em>numerator / denominator</em>).
   <p>
   * @return the value of this {@link ASTNode} as a real (double), or <code>0</code>
   * if this is not a node that holds a number.
   <p>
   * @note This function should be called only when this {@link ASTNode} has a
   * numerical value type.  It will return <code>0</code> if the node type is another
   * type, but since <code>0</code> may be a valid value, it is important to be sure
   * that the node type is the correct type in order to correctly interpret
   * the returned value.
   */ public
 double getReal() {
    return libsbmlJNI.ASTNode_getReal(swigCPtr, this);
  }

  
/**
   * Returns the mantissa value of this node.
   <p>
   * If {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_REAL AST_REAL}, this method is
   * identical to {@link ASTNode#getReal()}.
   <p>
   * @return the value of the mantissa of this {@link ASTNode}, or <code>0</code> if this
   * node is not a type that has a real-numbered value.
   <p>
   * @note This function should be called only when
   * {@link ASTNode#getType()} returns
   * {@link libsbmlConstants#AST_REAL_E AST_REAL_E},
   * {@link libsbmlConstants#AST_REAL AST_REAL} or
   * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO}.  It
   * will return <code>0</code> if the node type is another type, but since <code>0</code> may be
   * a valid value, it is important to be sure that the node type is the
   * correct type in order to correctly interpret the returned value.
   <p>
   * @see #getExponent()
   */ public
 double getMantissa() {
    return libsbmlJNI.ASTNode_getMantissa(swigCPtr, this);
  }

  
/**
   * Returns the exponent value of this {@link ASTNode}.
   <p>
   * @return the value of the exponent of this {@link ASTNode}, or <code>0</code> if this
   * is not a type of node that has an exponent.
   <p>
   * @note This function should be called only when
   * {@link ASTNode#getType()}
   * returns {@link libsbmlConstants#AST_REAL_E AST_REAL_E}.
   * It will return <code>0</code> if the node type is another type, but since <code>0</code> may
   * be a valid value, it is important to be sure that the node type is the
   * correct type in order to correctly interpret the returned value.
   <p>
   * @see #getMantissa()
   */ public
 int getExponent() {
    return libsbmlJNI.ASTNode_getExponent(swigCPtr, this);
  }

  
/**
   * Returns the numerical value of this {@link ASTNode}.
   <p>
   * @return the numerical value of this {@link ASTNode}, or <code>NaN</code> if this
   * is not a type of node that has a numerical value.
   <p>
   * @note This function will return a numerical value (as a double) for 
   * any ASTNode_t that represents a number, a constant such as 
   * {@link libsbmlConstants#AST_CONSTANT_PI AST_CONSTANT_PI}, 
   * {@link libsbmlConstants#AST_CONSTANT_E AST_CONSTANT_E}, or 
   * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO}, or 
   * <code>1</code> for nodes of type 
   * {@link libsbmlConstants#AST_CONSTANT_TRUE AST_CONSTANT_TRUE} and <code>0</code> for nodes of type
   * {@link libsbmlConstants#AST_CONSTANT_FALSE AST_CONSTANT_FALSE}. It does not evaluate
   * the node in any way so, for example, it will not return the value of 
   * a named ASTNode_t or attempt to evaluate a function. 
   * This includes a node representing <code>time</code> i.e. nodes
   * of type {@link libsbmlConstants#AST_NAME_TIME AST_NAME_TIME}.
   */ public
 double getValue() {
    return libsbmlJNI.ASTNode_getValue(swigCPtr, this);
  }

  
/**
   * Returns the precedence of this node in the infix math syntax of SBML
   * Level&nbsp;1.
   <p>
   * For more information about the infix syntax, see the discussion about <a
   * href='#math-convert'>text string formulas</a> at the top of the
   * documentation for {@link ASTNode}.
   <p>
   * @return an integer indicating the precedence of this {@link ASTNode}.
   */ public
 int getPrecedence() {
    return libsbmlJNI.ASTNode_getPrecedence(swigCPtr, this);
  }

  
/**
   * Returns the type of this {@link ASTNode}.
   <p>
   * The value returned is one of the Core AST type codes such as
   * {@link libsbmlConstants#AST_LAMBDA AST_LAMBDA},
   * {@link libsbmlConstants#AST_PLUS AST_PLUS}, etc.
   <p>
   * @return the type of this {@link ASTNode}.
   <p>
   * @note The introduction of extensibility in SBML Level&nbsp;3 brings with
   * it a need to allow for the possibility of node types that are defined by
   * plug-ins implementing SBML Level&nbsp;3 packages.  If a given {@link ASTNode} is
   * a construct created by a package rather than libSBML Core, then
   * {@link ASTNode#getType()} will return
   * {@link libsbmlConstants#AST_ORIGINATES_IN_PACKAGE AST_ORIGINATES_IN_PACKAGE}.
   * Callers can then obtain the package-specific type by
   * calling getExtendedType().
   <p>
   * @see #getExtendedType()
   */ public
 int getType() {
    return libsbmlJNI.ASTNode_getType(swigCPtr, this);
  }

  
/**
   * Returns the extended type of this {@link ASTNode}.
   <p>
   * The type may be either a core
   * integer type code
   * or a value of a type code defined by an SBML Level&nbsp;3 package.
   <p>
   * @return the type of this {@link ASTNode}.
   <p>
   * @note When the {@link ASTNode} is of a type from a package, the value returned
   * by {@link ASTNode#getType()} will be
   * {@link libsbmlConstants#AST_ORIGINATES_IN_PACKAGE AST_ORIGINATES_IN_PACKAGE}
   * and getExtendedType() will return a package-specific type
   * code.  To find out the possible package-specific types (if any), please
   * consult the documentation for the particular package.
   <p>
   * @see #getType()
   */ public
 int getExtendedType() {
    return libsbmlJNI.ASTNode_getExtendedType(swigCPtr, this);
  }

  
/**
   * Returns the units of this {@link ASTNode}.
   <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing Model.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class="fragment">&lt;math xmlns="http://www.w3.org/1998/Math/MathML"
      xmlns:sbml="http://www.sbml.org/sbml/level3/version1/core"&gt;
        &lt;cn type="integer" sbml:units="second"&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   <p>
   * @return the units of this {@link ASTNode}.
   <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   <p>
   * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
   */ public
 String getUnits() {
    return libsbmlJNI.ASTNode_getUnits(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents the predefined
   * value for Avogadro's constant.
   <p>
   * SBML Level&nbsp;3 introduced a predefined MathML <code>&lt;csymbol&gt;</code>
   * for the value of Avogadro's constant.  LibSBML stores this internally as
   * a node of type {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO}.
   * This method returns <code>true</code> if this node has that type.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is the special symbol avogadro,
   * <code>false</code> otherwise.
   <p>
   * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
   */ public
 boolean isAvogadro() {
    return libsbmlJNI.ASTNode_isAvogadro(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has a Boolean type.
   <p>
   * The {@link ASTNode} objects that have Boolean types are the logical operators,
   * relational operators, and the constants <code>true</code> or <code>false.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} has a Boolean type, <code>false</code> otherwise.
   */ public
 boolean isBoolean() {
    return libsbmlJNI.ASTNode_isBoolean(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node returns a Boolean value.
   <p>
   * This function looks at the whole {@link ASTNode} rather than just the top level
   * of the {@link ASTNode}. Thus, it will consider return values from piecewise
   * statements.  In addition, if this {@link ASTNode} uses a function call to a
   * user-defined function, the return value of the corresponding
   * {@link FunctionDefinition} object will be determined.  Note that this is only
   * possible where the {@link ASTNode} can trace its parent {@link Model}; that is, the
   * {@link ASTNode} must represent the <code>&lt;math&gt;</code> element of some
   * SBML object that has already been added to an instance of an
   * {@link SBMLDocument}.
   <p>
   * @param model the {@link Model} to use as context.
   <p>
   * 
   * @return <code>true</code> if this {@link ASTNode} returns a boolean, <code>false</code> otherwise.
   <p>
   * @see #isBoolean()
   */ public
 boolean returnsBoolean(Model model) {
    return libsbmlJNI.ASTNode_returnsBoolean__SWIG_0(swigCPtr, this, Model.getCPtr(model), model);
  }

  
/**
   * Returns <code>true</code> if this node returns a Boolean value.
   <p>
   * This function looks at the whole {@link ASTNode} rather than just the top level
   * of the {@link ASTNode}. Thus, it will consider return values from piecewise
   * statements.  In addition, if this {@link ASTNode} uses a function call to a
   * user-defined function, the return value of the corresponding
   * {@link FunctionDefinition} object will be determined.  Note that this is only
   * possible where the {@link ASTNode} can trace its parent {@link Model}; that is, the
   * {@link ASTNode} must represent the <code>&lt;math&gt;</code> element of some
   * SBML object that has already been added to an instance of an
   * {@link SBMLDocument}.
   <p>
   * @param model the {@link Model} to use as context.
   <p>
   * 
   * @return <code>true</code> if this {@link ASTNode} returns a boolean, <code>false</code> otherwise.
   <p>
   * @see #isBoolean()
   */ public
 boolean returnsBoolean() {
    return libsbmlJNI.ASTNode_returnsBoolean__SWIG_1(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents a MathML
   * constant.
   <p>
   * Examples of MathML constants include such things as pi.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML constant, <code>false</code>
   * otherwise.
   <p>
   * @note This function will also return <code>true</code> for nodes of type
   * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} in SBML Level&nbsp;3.
   */ public
 boolean isConstant() {
    return libsbmlJNI.ASTNode_isConstant(swigCPtr, this);
  }

  
/**
  * Returns <code>true</code> if this node represents a MathML
  * constant numeric.
  <p>
  * Examples of MathML constants include such things as pi.
  <p>
  * @return <code>true</code> if this {@link ASTNode} is a MathML constant, <code>false</code>
  * otherwise.
  <p>
  * @note This function will also return <code>true</code> for nodes of type
  * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} in SBML Level&nbsp;3.
  */ public
 boolean isConstantNumber() {
    return libsbmlJNI.ASTNode_isConstantNumber(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents a function.
   <p>
   * The three types of functions in SBML are MathML functions (e.g.,
   * <code>abs()</code>), SBML Level&nbsp;1 functions (in the SBML
   * Level&nbsp;1 math syntax), and user-defined functions (using
   * {@link FunctionDefinition} in SBML Level&nbsp;2 and&nbsp;3).
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a function, <code>false</code> otherwise.
   */ public
 boolean isFunction() {
    return libsbmlJNI.ASTNode_isFunction(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents the special IEEE 754
   * value for infinity.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 value infinity,
   * <code>false</code> otherwise.
   */ public
 boolean isInfinity() {
    return libsbmlJNI.ASTNode_isInfinity(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node of type {@link libsbmlConstants#AST_INTEGER AST_INTEGER}.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link libsbmlConstants#AST_INTEGER AST_INTEGER}, <code>false</code> otherwise.
   */ public
 boolean isInteger() {
    return libsbmlJNI.ASTNode_isInteger(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a MathML
   * <code>&lt;lambda&gt;</code>.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link libsbmlConstants#AST_LAMBDA AST_LAMBDA}, <code>false</code> otherwise.
   */ public
 boolean isLambda() {
    return libsbmlJNI.ASTNode_isLambda(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents a <code>log10</code> function.
   <p>
   * More precisely, this predicate returns <code>true</code> if the node type is
   * {@link libsbmlConstants#AST_FUNCTION_LOG AST_FUNCTION_LOG} with two children, the
   * first of which is an {@link libsbmlConstants#AST_INTEGER AST_INTEGER} equal to
   * 10.
   <p>
   * @return <code>true</code> if the given {@link ASTNode} represents a <code>log10</code>() function, 
   * <code>false</code> otherwise.
   <p>
   * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
   */ public
 boolean isLog10() {
    return libsbmlJNI.ASTNode_isLog10(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a MathML logical operator.
   <p>
   * The possible MathML logical operators in SBML core are <code>and</code>, <code>or</code>, <code>not</code>, 
   * <code>xor</code>, and (as of SBML Level&nbsp;3 Version&nbsp;2) <code>implies.</code>  If
   * the node represents a logical operator defined in a Level&nbsp;3 package,
   * it will also return <code>true.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML logical operator, <code>false</code>
   * otherwise.
   */ public
 boolean isLogical() {
    return libsbmlJNI.ASTNode_isLogical(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a user-defined variable name
   * or the symbols for time or Avogadro's constant.
   <p>
   * SBML Levels&nbsp;2 and&nbsp;3 provides <code>&lt;csymbol&gt;</code>
   * definitions for 'time' and 'avogadro', which can be used to represent
   * simulation time and Avogadro's constant in MathML.  Note that this
   * method does <em>not</em> return <code>true</code> for the other <code>csymbol</code>
   * values defined by SBML, 'delay', because the 'delay' is a function
   * and not a constant or variable.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a user-defined variable name in SBML
   * or the special symbols for time or Avogadro's constant. It returns 
   * <code>false</code> otherwise.
   */ public
 boolean isName() {
    return libsbmlJNI.ASTNode_isName(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents the special IEEE 754
   * value 'not a number' (NaN).
   <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 NaN, <code>false</code>
   * otherwise.
   */ public
 boolean isNaN() {
    return libsbmlJNI.ASTNode_isNaN(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents the special IEEE 754
   * value 'negative infinity'.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is the special IEEE 754 value negative
   * infinity, <code>false</code> otherwise.
   */ public
 boolean isNegInfinity() {
    return libsbmlJNI.ASTNode_isNegInfinity(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node contains a number.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a number, <code>false</code> otherwise.
   */ public
 boolean isNumber() {
    return libsbmlJNI.ASTNode_isNumber(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a mathematical
   * operator.
   <p>
   * The possible mathematical operators in the MathML syntax supported by
   * SBML are <code>+</code>, <code>-</code>, <code>*</code>, <code>/</code>
   * and <code>^</code> (power).
   <p>
   * @return <code>true</code> if this {@link ASTNode} is an operator, <code>false</code> otherwise.
   */ public
 boolean isOperator() {
    return libsbmlJNI.ASTNode_isOperator(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is the MathML
   * <code>&lt;piecewise&gt;</code> construct.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML <code>piecewise</code> function,
   * <code>false</code> otherwise.
   */ public
 boolean isPiecewise() {
    return libsbmlJNI.ASTNode_isPiecewise(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this node is a MathML
   * qualifier.
   <p>
   * The MathML qualifier node types are <code>bvar</code>, <code>degree</code>, <code>base</code>, 
   * <code>piece</code>, and <code>otherwise.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML qualifier, <code>false</code>
   * otherwise.
   */ public
 boolean isQualifier() {
    return libsbmlJNI.ASTNode_isQualifier(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents a rational number.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}, <code>false</code> otherwise.
   */ public
 boolean isRational() {
    return libsbmlJNI.ASTNode_isRational(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node can represent a real number.
   <p>
   * More precisely, this node must be of one of the following types:
   * {@link libsbmlConstants#AST_REAL AST_REAL}, {@link libsbmlConstants#AST_REAL_E AST_REAL_E} or {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   <p>
   * @return <code>true</code> if the value of this {@link ASTNode} can represented as a real
   * number, <code>false</code> otherwise.
   */ public
 boolean isReal() {
    return libsbmlJNI.ASTNode_isReal(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a MathML
   * relational operator.
   <p>
   * The MathML relational operators are <code>==</code>, <code>&gt;=</code>,
   * <code>&gt;</code>, <code>&lt;</code>, and <code>!=</code>.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML relational operator, 
   * <code>false</code> otherwise.
   */ public
 boolean isRelational() {
    return libsbmlJNI.ASTNode_isRelational(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this node is a MathML
   * semantics node.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a MathML semantics node, <code>false</code>
   * otherwise.
   */ public
 boolean isSemantics() {
    return libsbmlJNI.ASTNode_isSemantics(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node represents a square root
   * function.
   <p>
   * More precisely, the node type must be {@link libsbmlConstants#AST_FUNCTION_ROOT AST_FUNCTION_ROOT} with two children, the first of which is an
   * {@link libsbmlConstants#AST_INTEGER AST_INTEGER} node having value equal to 2.
   <p>
   * @return <code>true</code> if the given {@link ASTNode} represents a <code>sqrt()</code>
   * function, <code>false</code> otherwise.
   */ public
 boolean isSqrt() {
    return libsbmlJNI.ASTNode_isSqrt(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a unary minus operator.
   <p>
   * A node is defined as a unary minus node if it is of type
   * {@link libsbmlConstants#AST_MINUS AST_MINUS} and has exactly one child.
   <p>
   * For numbers, unary minus nodes can be 'collapsed' by negating the
   * number.  In fact, <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> does this during
   * its parsing process, and <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> has a
   * configuration option that allows this behavior to be turned on or off.
   * However, unary minus nodes for symbols ({@link libsbmlConstants#AST_NAME AST_NAME}) or functions cannot be 'collapsed', so this predicate function is
   * necessary.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a unary minus, <code>false</code>
   * otherwise.
   <p>
   * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
   */ public
 boolean isUMinus() {
    return libsbmlJNI.ASTNode_isUMinus(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node is a unary plus operator.
   <p>
   * A node is defined as a unary plus node if it is of type
   * {@link libsbmlConstants#AST_PLUS AST_PLUS} and has exactly one child.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is a unary plus, <code>false</code> otherwise.
   */ public
 boolean isUPlus() {
    return libsbmlJNI.ASTNode_isUPlus(swigCPtr, this);
  }

  
/**
  * Returns <code>true</code> if this node is of a certain type with a specific number
  * of children.
  <p>
  * Designed for use in cases where it is useful to discover if the node is a
  * unary not or unary minus, or a times node with no children, etc.
  <p>
  * @param type the type of {@link ASTNode} sought.
  * @param numchildren the number of child nodes sought.
  <p>
  * @return <code>true</code> if this {@link ASTNode} is has the specified type and number of
  * children, <code>false</code> otherwise.
  */ public
 int hasTypeAndNumChildren(int type, long numchildren) {
    return libsbmlJNI.ASTNode_hasTypeAndNumChildren(swigCPtr, this, type, numchildren);
  }

  
/**
   * Returns <code>true</code> if this node has an unknown type.
   <p>
   * 'Unknown' nodes have the type {@link libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}.
   * Nodes with unknown types will not appear in an {@link ASTNode} tree returned by
   * libSBML based upon valid SBML input; the only situation in which a node
   * with type {@link libsbmlConstants#AST_UNKNOWN AST_UNKNOWN} may appear is
   * immediately after having create a new, untyped node using the {@link ASTNode}
   * constructor.  Callers creating nodes should endeavor to set the type to
   * a valid node type as soon as possible after creating new nodes.
   <p>
   * @return <code>true</code> if this {@link ASTNode} is of type {@link libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}, <code>false</code> otherwise.
   */ public
 boolean isUnknown() {
    return libsbmlJNI.ASTNode_isUnknown(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has a value for the MathML
   * attribute <code>id.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} has an attribute id, <code>false</code>
   * otherwise.
   <p>
   * @see #isSetClass()
   * @see #isSetStyle()
   * @see #setId(String id)
   * @see #unsetId()
   */ public
 boolean isSetId() {
    return libsbmlJNI.ASTNode_isSetId(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has a value for the MathML
   * attribute <code>class.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} has an attribute class, <code>false</code>
   * otherwise.
   <p>
   * @see #isSetId()
   * @see #isSetStyle()
   * @see #setClassName(String id)
   * @see #unsetClass()
   */ public
 boolean isSetClass() {
    return libsbmlJNI.ASTNode_isSetClass(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has a value for the MathML
   * attribute <code>style.</code>
   <p>
   * @return <code>true</code> if this {@link ASTNode} has an attribute style, <code>false</code>
   * otherwise.
   <p>
   * @see #isSetClass()
   * @see #isSetId()
   * @see #setStyle(String id)
   * @see #unsetStyle()
   */ public
 boolean isSetStyle() {
    return libsbmlJNI.ASTNode_isSetStyle(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has the attribute
   * <code>sbml:units</code>.
   <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing Model.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class="fragment">&lt;math xmlns="http://www.w3.org/1998/Math/MathML"
      xmlns:sbml="http://www.sbml.org/sbml/level3/version1/core"&gt;
        &lt;cn type="integer" sbml:units="second"&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   <p>
   * @return <code>true</code> if this {@link ASTNode} has units associated with it, <code>false</code>
   * otherwise.
   <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   <p>
   * @see #hasUnits()
   * @see #setUnits(String units)
   */ public
 boolean isSetUnits() {
    return libsbmlJNI.ASTNode_isSetUnits(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node or any of its
   * children nodes have the attribute <code>sbml:units</code>.
   <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing Model.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class="fragment">&lt;math xmlns="http://www.w3.org/1998/Math/MathML"
      xmlns:sbml="http://www.sbml.org/sbml/level3/version1/core"&gt;
        &lt;cn type="integer" sbml:units="second"&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   <p>
   * @return <code>true</code> if this {@link ASTNode} or its children has units associated
   * with it, <code>false</code> otherwise.
   <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   <p>
   * @see #isSetUnits()
   * @see #setUnits(String units)
   */ public
 boolean hasUnits() {
    return libsbmlJNI.ASTNode_hasUnits(swigCPtr, this);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given character.  If character
   * is one of <code>+</code>, <code>-</code>, <code>*</code>, <code>/</code> or <code>^</code>, the node
   * type will be set accordingly.  For all other characters, the node type
   * will be set to {@link libsbmlConstants#AST_UNKNOWN AST_UNKNOWN}.
   <p>
   * @param value the character value to which the node's value should be
   * set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setCharacter(char value) {
    return libsbmlJNI.ASTNode_setCharacter(swigCPtr, this, value);
  }

  
/**
   * Sets the MathML attribute <code>id</code> of this {@link ASTNode}.
   <p>
   * @param id <code>string</code> representing the identifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #isSetId()
   * @see #getId()
   * @see #unsetId()
   */ public
 int setId(String id) {
    return libsbmlJNI.ASTNode_setId(swigCPtr, this, id);
  }

  
/**
   * Sets the MathML attribute <code>class</code> of this {@link ASTNode}.
   <p>
   * @param className <code>string</code> representing the MathML class for this node.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @note In the API interfaces for languages other than Java, this method
   * is named <code>setClass()</code>, but in Java it is renamed
   * <code>setClassName()</code> to avoid a name collision with Java's
   * standard object method of the same name.
   <p>
   * @see #isSetClass()
   * @see #getClass()
   * @see #unsetClass()
   */ public
 int setClassName(String className) {
    return libsbmlJNI.ASTNode_setClassName(swigCPtr, this, className);
  }

  
/**
   * Sets the MathML attribute <code>style</code> of this {@link ASTNode}.
   <p>
   * @param style <code>string</code> representing the identifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   *
   * </ul> <p>
   * @see #isSetStyle()
   * @see #getStyle()
   * @see #unsetStyle()
   */ public
 int setStyle(String style) {
    return libsbmlJNI.ASTNode_setStyle(swigCPtr, this, style);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given name.
   <p>
   * As a side effect, this {@link ASTNode} object's type will be reset to
   * {@link libsbmlConstants#AST_NAME AST_NAME} if (and <em>only if</em>) the
   * {@link ASTNode} was previously an operator (i.e., * {@link ASTNode#isOperator()} returns <code>true</code>), number (i.e., {@link ASTNode#isNumber()} returns <code>true</code>), or
   * unknown.  This allows names to be set for {@link libsbmlConstants#AST_FUNCTION AST_FUNCTION} nodes and the like.
   <p>
   * @param name the string containing the name to which this node's value
   * should be set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.ASTNode_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given (<code>long</code>) integer
   <p>
   * As a side effect, this operation sets the node type to
   * {@link libsbmlConstants#AST_INTEGER AST_INTEGER}.
   <p>
   * @param value the integer to which this node's value should be set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setValue(int value) {
    return libsbmlJNI.ASTNode_setValue__SWIG_0(swigCPtr, this, value);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given rational.
   <p>
   * As a side effect, this operation sets the node type to
   * {@link libsbmlConstants#AST_RATIONAL AST_RATIONAL}.
   <p>
   * @param numerator the numerator value of the rational.
   * @param denominator the denominator value of the rational.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setValue(int numerator, int denominator) {
    return libsbmlJNI.ASTNode_setValue__SWIG_1(swigCPtr, this, numerator, denominator);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>).
   <p>
   * As a side effect, this operation sets the node type to
   * {@link libsbmlConstants#AST_REAL AST_REAL}.
   <p>
   * This is functionally equivalent to:
   * <pre class='fragment'>
setValue(value, 0);
</pre>
   <p>
   * @param value the <code>double</code> format number to which this node's value
   * should be set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setValue(double value) {
    return libsbmlJNI.ASTNode_setValue__SWIG_2(swigCPtr, this, value);
  }

  
/**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>)
   <p>
   * As a side effet, this operation sets the node type to
   * {@link libsbmlConstants#AST_REAL_E AST_REAL_E}.
   <p>
   * @param mantissa the mantissa of this node's real-numbered value.
   * @param exponent the exponent of this node's real-numbered value.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int setValue(double mantissa, int exponent) {
    return libsbmlJNI.ASTNode_setValue__SWIG_3(swigCPtr, this, mantissa, exponent);
  }

  
/**
   * Sets the type of this {@link ASTNode}.
   <p>
   * This uses integer type codes, which may come from the set
   * of static integer constants whose names begin with the prefix
   * <code>AST_</code>  defined in the interface class
   * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>
   *  or an enumeration of AST types in an SBML
   * Level&nbsp;3 package.
   <p>
   * @param type the integer representing the type to which this node should
   * be set.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note A side-effect of doing this is that any numerical values
   * previously stored in this node are reset to zero.
   <p>
   * @see #getType()
   */ public
 int setType(int type) {
    return libsbmlJNI.ASTNode_setType(swigCPtr, this, type);
  }

  
/**
   * Sets the units of this {@link ASTNode} to units.
   <p>
   * The units will be set <em>only</em> if this {@link ASTNode} object represents a
   * MathML <code>&lt;cn&gt;</code> element, i.e., represents a number.
   * Callers may use
   * {@link ASTNode#isNumber()}
   * to inquire whether the node is of that type.
   <p>
   * SBML Level&nbsp;3 Version&nbsp;1 introduced the ability to include an
attribute <code>sbml:units</code> on MathML <code>cn</code> elements
appearing in SBML mathematical formulas.  The value of this attribute can
be used to indicate the unit of measurement to be associated with the
number in the content of the <code>cn</code> element.  The value of this
attribute must be the identifier of a unit of measurement defined by SBML
or the enclosing Model.  Here, the <code>sbml</code> portion is an XML
namespace prefix that must be associated with the SBML namespace for SBML
Level&nbsp;3.  The following example illustrates how this attribute can be
used to define a number with value <code>10</code> and unit of measurement
<code>second</code>:
<pre class="fragment">&lt;math xmlns="http://www.w3.org/1998/Math/MathML"
      xmlns:sbml="http://www.sbml.org/sbml/level3/version1/core"&gt;
        &lt;cn type="integer" sbml:units="second"&gt; 10 &lt;/cn&gt;
&lt;/math&gt;
</pre>

   <p>
   * @param units <code>string</code> representing the unit identifier.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   *
   * </ul> <p>
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   <p>
   * @see #isSetUnits()
   * @see #hasUnits()
   */ public
 int setUnits(String units) {
    return libsbmlJNI.ASTNode_setUnits(swigCPtr, this, units);
  }

  
/**
   * Swaps the children of this node with the children of another node.
   <p>
   * @param that the other node whose children should be used to replace
   * <em>this</em> node's children.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int swapChildren(ASTNode that) {
    return libsbmlJNI.ASTNode_swapChildren(swigCPtr, this, ASTNode.getCPtr(that), that);
  }

  
/**
   * Renames all the SIdRef attributes on this node and its child nodes.
   <p>
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.ASTNode_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * Renames all the UnitSIdRef attributes on this node and its child nodes.
   <p>
   * The only place UnitSIDRefs appear in MathML <code>&lt;cn&gt;</code>
   * elements, so the effects of this method are limited to that.
   <p>
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.ASTNode_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/** * @internal */ public
 void replaceIDWithFunction(String id, ASTNode function) {
    libsbmlJNI.ASTNode_replaceIDWithFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 void setIsChildFlag(boolean flag) {
    libsbmlJNI.ASTNode_setIsChildFlag(swigCPtr, this, flag);
  }

  
/**
   * Unsets the units of this {@link ASTNode}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetUnits() {
    return libsbmlJNI.ASTNode_unsetUnits(swigCPtr, this);
  }

  
/**
   * Unsets the MathML <code>id</code> attribute of this {@link ASTNode}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetId() {
    return libsbmlJNI.ASTNode_unsetId(swigCPtr, this);
  }

  
/**
   * Unsets the MathML <code>class</code> attribute of this {@link ASTNode}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetClass() {
    return libsbmlJNI.ASTNode_unsetClass(swigCPtr, this);
  }

  
/**
   * Unsets the MathML <code>style</code> attribute of this {@link ASTNode}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetStyle() {
    return libsbmlJNI.ASTNode_unsetStyle(swigCPtr, this);
  }

  
/**
   * Sets the MathML attribute <code>definitionURL.</code>
   <p>
   * @param url the URL value for the <code>definitionURL</code> attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #setDefinitionURL(String url)
   * @see #getDefinitionURL()
   * @see #getDefinitionURLString()
   */ public
 int setDefinitionURL(XMLAttributes url) {
    return libsbmlJNI.ASTNode_setDefinitionURL__SWIG_0(swigCPtr, this, XMLAttributes.getCPtr(url), url);
  }

  
/**
   * Sets the MathML attribute <code>definitionURL.</code>
   <p>
   * @param url the URL value for the <code>definitionURL</code> attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #setDefinitionURL(XMLAttributes url)
   * @see #getDefinitionURL()
   * @see #getDefinitionURLString()
   */ public
 int setDefinitionURL(String url) {
    return libsbmlJNI.ASTNode_setDefinitionURL__SWIG_1(swigCPtr, this, url);
  }

  
/**
   * Returns the MathML <code>definitionURL</code> attribute value.
   <p>
   * @return the value of the <code>definitionURL</code> attribute, in the form of
   * a libSBML {@link XMLAttributes} object.
   <p>
   * @see #setDefinitionURL(XMLAttributes url)
   * @see #setDefinitionURL(String url)
   * @see #getDefinitionURLString()
   */ public
 XMLAttributes getDefinitionURL() {
    long cPtr = libsbmlJNI.ASTNode_getDefinitionURL(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
/**
   * Replaces occurrences of a given name with a given {@link ASTNode}.
   <p>
   * For example, if the formula in this {@link ASTNode} is <code>x + y</code>,
   * and the function is called with <code>bvar</code> = <code>'x'</code> and <code>arg</code> = an {@link ASTNode}
   * representing the real value <code>3.</code>  This method would substitute <code>3</code> for 
   * <code>x</code> within this {@link ASTNode} object, resulting in the forula <code>3 + y</code>.
   <p>
   * @param bvar a string representing the variable name to be substituted.
   <p>
   * @param arg an {@link ASTNode} representing the name/value/formula to use as
   * a replacement.
   */ public
 void replaceArgument(String bvar, ASTNode arg) {
    libsbmlJNI.ASTNode_replaceArgument(swigCPtr, this, bvar, ASTNode.getCPtr(arg), arg);
  }

  
/**
   * Returns the parent SBML object.
   <p>
   * @return the parent SBML object of this {@link ASTNode}.
   <p>
   * 
   * @see #unsetParentSBMLObject()
   <p>
   * @see #isSetParentSBMLObject()
   */ public
 SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.ASTNode_getParentSBMLObject(swigCPtr, this), false);
}

  
/**
   * Unsets the parent SBML object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isSetParentSBMLObject()
   * @see #getParentSBMLObject()
   */ public
 int unsetParentSBMLObject() {
    return libsbmlJNI.ASTNode_unsetParentSBMLObject(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this node has a value for the parent SBML
   * object.
   <p>
   * @return <code>true</code> if this {@link ASTNode} has an parent SBML object set, <code>false</code> otherwise.
   <p>
   * 
   * @see #unsetParentSBMLObject()
   <p>
   * @see #getParentSBMLObject()
   */ public
 boolean isSetParentSBMLObject() {
    return libsbmlJNI.ASTNode_isSetParentSBMLObject(swigCPtr, this);
  }

  
/**
   * Reduces this {@link ASTNode} to a binary tree.
   <p>
   * Example: if this {@link ASTNode} is <code>and(x, y, z)</code>, then the
   * formula of the reduced node is <code>and(and(x, y), z)</code>.  The
   * operation replaces the formula stored in the current {@link ASTNode} object.
   */ public
 void reduceToBinary() {
    libsbmlJNI.ASTNode_reduceToBinary(swigCPtr, this);
  }

  
/**
  * Unsets the user data of this node.
  <p>
  * The user data can be used by the application developer to attach custom
  * information to the node.  In case of a deep copy, this attribute will
  * passed as it is. The attribute will be never interpreted by this class.
  <p>
  * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
  * <ul>
  * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
  * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
  *
  * </ul> */ public
 int unsetUserData() {
    return libsbmlJNI.ASTNode_unsetUserData(swigCPtr, this);
  }

  
/**
  * Returns <code>true</code> if this node has a user data object.
  <p>
  * @return <code>true</code> if this {@link ASTNode} has a user data object set, <code>false</code>
  * otherwise.
  */ public
 boolean isSetUserData() {
    return libsbmlJNI.ASTNode_isSetUserData(swigCPtr, this);
  }

  
/**
  * Returns <code>true</code> or <code>false</code> depending on whether this
  * {@link ASTNode} is well-formed.
  <p>
  * @note An {@link ASTNode} may be well-formed, with each node and its children
  * having the appropriate number of children for the given type, but may
  * still be invalid in the context of its use within an SBML model.
  <p>
  * @return <code>true</code> if this {@link ASTNode} is well-formed, <code>false</code> otherwise.
  <p>
  * @see #hasCorrectNumberArguments()
  */ public
 boolean isWellFormedASTNode() {
    return libsbmlJNI.ASTNode_isWellFormedASTNode(swigCPtr, this);
  }

  
/**
  * Returns <code>true</code> if this {@link ASTNode} has the correct number of children for
  * its type.
  <p>
  * For example, an {@link ASTNode} with type {@link libsbmlConstants#AST_MINUS AST_MINUS}
  * expects 1 or 2 child nodes.
  <p>
  * @return <code>true</code> if this {@link ASTNode} has the appropriate number of children
  * for its type, <code>false</code> otherwise.
  <p>
  * @note This function performs a check on the top-level node only.  Child
  * nodes are not checked.
  <p>
  * @see #isWellFormedASTNode()
  */ public
 boolean hasCorrectNumberArguments() {
    return libsbmlJNI.ASTNode_hasCorrectNumberArguments(swigCPtr, this);
  }

  
/**
   * Returns the MathML <code>definitionURL</code> attribute value as a string.
   <p>
   * @return the value of the <code>definitionURL</code> attribute, as a string.
   <p>
   * @see #getDefinitionURL()
   * @see #setDefinitionURL(String url)
   * @see #setDefinitionURL(XMLAttributes url)
   */ public
 String getDefinitionURLString() {
    return libsbmlJNI.ASTNode_getDefinitionURLString(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean representsBvar() {
    return libsbmlJNI.ASTNode_representsBvar(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean usesL3V2MathConstructs() {
    return libsbmlJNI.ASTNode_usesL3V2MathConstructs(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean usesRateOf() {
    return libsbmlJNI.ASTNode_usesRateOf(swigCPtr, this);
  }

  
/** * @internal */ public
 void write(XMLOutputStream stream) {
    libsbmlJNI.ASTNode_write(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream);
  }

  
/** * @internal */ public
 boolean read(XMLInputStream stream, String reqd_prefix) {
    return libsbmlJNI.ASTNode_read__SWIG_0(swigCPtr, this, XMLInputStream.getCPtr(stream), stream, reqd_prefix);
  }

  
/** * @internal */ public
 boolean read(XMLInputStream stream) {
    return libsbmlJNI.ASTNode_read__SWIG_1(swigCPtr, this, XMLInputStream.getCPtr(stream), stream);
  }

  
/** * @internal */ public
 void writeNodeOfType(XMLOutputStream stream, int type, boolean inChildNode) {
    libsbmlJNI.ASTNode_writeNodeOfType__SWIG_0(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream, type, inChildNode);
  }

  
/** * @internal */ public
 void writeNodeOfType(XMLOutputStream stream, int type) {
    libsbmlJNI.ASTNode_writeNodeOfType__SWIG_1(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream, type);
  }

  
/** * @internal */ public
 long getNumBvars() {
    return libsbmlJNI.ASTNode_getNumBvars(swigCPtr, this);
  }

  
/** * @internal */ public
 int getTypeCode() {
    return libsbmlJNI.ASTNode_getTypeCode(swigCPtr, this);
  }

  
/** * @internal */ public
 String getPackageName() {
    return libsbmlJNI.ASTNode_getPackageName(swigCPtr, this);
  }

  
/** * @internal */ public
 ASTBasePlugin getPlugin(String arg0) {
  return libsbml.DowncastASTBasePlugin(libsbmlJNI.ASTNode_getPlugin__SWIG_0(swigCPtr, this, arg0), false);
}

  
/** * @internal */ public
 ASTBasePlugin getPlugin(long n) {
  return libsbml.DowncastASTBasePlugin(libsbmlJNI.ASTNode_getPlugin__SWIG_2(swigCPtr, this, n), false);
}

  
/** * @internal */ public
 long getNumPlugins() {
    return libsbmlJNI.ASTNode_getNumPlugins(swigCPtr, this);
  }

  
/** * @internal */ public
 long getNumPiece() {
    return libsbmlJNI.ASTNode_getNumPiece(swigCPtr, this);
  }

  
  /**
   * Returns an {@link ASTNodeList} of all {@link ASTNode} objects.
   * 
   * Unlike the equivalent method in the libSBML C/C++ interface, this method does
   * not offer the ability to pass a predicate as an argument.  The method always
   * returns the list of all {@link ASTNode} objects.
   * 
   * @return the {@link ASTNodeList} of nodes for which the predicate
   * returned @c true (non-zero).
   * 
   * @warning The list returned is owned by the caller and should be deleted
   * after the caller is done using it.  The {@link ASTNode} objects in the
   * list; however, are <strong>not</strong> owned by the caller (as they
   * still belong to the tree itself), and therefore should not be deleted.
   */
 public ASTNodeList getListOfNodes() {
    long cPtr = libsbmlJNI.ASTNode_getListOfNodes(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNodeList(cPtr, true);
  }

}
