/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.util.*;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.translators.*;

/**
 *
 */
public class ReplyPacketUnicodeAsciiOutput
    extends ReplyPacket
{
    /**
     * creates a new ReplyPacketUnicode
     */
    public
    ReplyPacketUnicodeAsciiOutput (com.sap.dbtech.util.StructuredMem rawPacket)
    {
        super (rawPacket);
    }
    /**
     *
     * @param offset int
     * @param len int
     */
    public String getStrippedString (
        int offset,
        int lenInBytes)
    {
        String trimmedString;

        trimmedString = StringUtil.trimLeft (
            this.getString (offset, lenInBytes));
        return trimmedString;
    }
 

    protected DBTechTranslator getTranslator(
        int mode,
        int ioType,
        int dataType,
        int frac,
        int len,
        int ioLen,
        int bufpos,
        boolean spaceoption,
		boolean isDBProcedure,
        DBProcParameterInfo procParamInfo,
        boolean readOnly, boolean autoIncre)
        throws java.sql.SQLException {
          return TranslatorFactory.create (mode, ioType, dataType,
                  frac, len, ioLen, bufpos, spaceoption, isDBProcedure, procParamInfo, readOnly, autoIncre);  
    }
    
    public String getString (
            int offset,
            int lenInBytes)
        {
            char [] chars = this.mem.getBigUnicode(offset, lenInBytes);
            return new String (chars);
        }


}
