/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.exceptions;

import java.io.*;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/**
 *
 */
public class TimeoutException
    extends DatabaseException
{
    static public PrintWriter extendedTrace = null;
    /**
     */
    public TimeoutException(
        com.sap.dbtech.rte.comm.RTEException rteExc)
    {
        super (MessageTranslator.translate(MessageKey.ERROR_TIMEOUT), "08000", 700, 0);
        if (extendedTrace != null) {
            synchronized (extendedTrace) {
                extendedTrace.println ("============================= "
                    + (new java.sql.Timestamp (System.currentTimeMillis ())).toString ());
                extendedTrace.println ("Timeout because of: ");
                rteExc.printStackTrace(extendedTrace);
                extendedTrace.flush ();
            }
        }
    }
    /**
     *
     */
    public static synchronized void
    addExtendedTrace (
        String fname)
    {
        if (extendedTrace == null) {
            try {
                OutputStream outstream = new FileOutputStream (fname, true);
                extendedTrace = new PrintWriter (outstream);
            }
            catch (IOException ioExc) {
                // ignore
            }
        }
    }
    /**
     *
     */
    public static void
    println (
        String text)
    {
        if (extendedTrace != null) {
            extendedTrace.println (text);
            extendedTrace.flush ();
        }
    }

    public boolean isConnectionReleasing() { return true; }
}
