# toc_run_description = looking for libreadline/libhistory
# toc_begin_help =
# Searches for GNU libreadline.
#
#Sets the LIBREADLINE_LDADD make var and the HAVE_READLINE config.h var.
#
#Use --without-libreadline to explicitely disable libreadline support.
#
#Sample snippet for your shared makefile:
#
#	configure_with_libreadline = @configure_with_libreadline@
#	LIBREADLINE_LDADD = @LIBREADLINE_LDADD@
#
#And for client makefiles:
#
#	ifeq (1,$(configure_with_libreadline))
#	my_LDADD += $(LIBREADLINE_LDADD)
#	endif
#
#  In your config.h.at put something like:
#
#	#define HAVE_READLINE @HAVE_READLINE@
#
# = toc_end_help

toc_add_config_h HAVE_READLINE=0
toc_add_make configure_with_libreadline=0
toc_add_make LIBREADLINE_LDADD=

test "x${configure_with_libreadline}" = "x0" && {
    echo "libreadline has been explictely disabled with --without-readline."
    return 0
}
configure_with_libreadline=${configure_with_libreadline-0}


libpath=/usr/lib:/usr/local/lib:${prefix}/lib:/lib
do=0
for L in libreadline.a libreadline.so.4; do
    toc_find $L "$libpath" && {
        do=1
        break
    }
done
test x$do = x0 && {
    echo "libreadline library file not found."
    return 0
}
lib=${TOC_FIND_RESULT}

incpath=/usr/include:/usr/include/readline:/usr/local/include:/usr/local/include/readline:${prefix}/include:${prefix}/include/readline
for inc in readline.h history.h; do
    toc_find $inc $incpath || {
        echo "Required header file $inc not found in [$incpath]"
        return 1
    }
    #echo $inc=${TOC_FIND_RESULT}
done
LIBREADLINE_LDADD="-lreadline"
nc=-lncurses

# note, this grep is apparenlty not sufficient, so i'm going
# to assume the readline needs ncurses for now. :/
#if toc_find nm > /dev/null; then
##    echo -n "? Do we also need to link against $nc? ... "
#    if ${TOC_FIND_RESULT} ${lib} | grep -q tgoto; then
#        true
#    else
#        echo "It seems we also need to link against $n."
#        LIBREADLINE_LDADD="${LIBREADLINE_LDADD} $nc"
#    fi
#else
#    echo "Couldn't find 'nm' to check $lib with, so i'm going to assume we need $nc."
    LIBREADLINE_LDADD="${LIBREADLINE_LDADD} $nc"
#fi

configure_with_libreadline=1
toc_add_config_h HAVE_READLINE=1
toc_add_make configure_with_libreadline=1
toc_add_make LIBREADLINE_LDADD="${LIBREADLINE_LDADD}"
return 0
