# toc_run_description = encourage the user to read the LICENSE file
# toc_begin_help = 
# Accepts a license filename as $1 and returns 1 if the license could
# not be read or if the user does not answer yes to the question of
# accepting the license.

# If ${accept_license_LICENSES} is not empty then the
# user is prompted to select one of the licenses, and this test
# returns 1 if the user do not choose one of them.

# It accepts the following "quick bypass":
# --accept-license=license
# where license is one of ${accept_license_LICENSES}

# Upon returning, if successful then ${accept_license_LICENSE} is set
# to the selected license.

# = toc_end_help



#

lc=${1-LICENSE}
# cat $lc
test -r "$lc" || {
    echo "accept_license: could not find license file $lc."
    return 1
}
toc_boldecho -e "\tPLEASE READ THE LICENSE!"
test "x${accept_license-0}" = "x0" && {
    echo "You are going to be shown a license (file: $lc), after which you will be asked whether you accept the license or not."
    echo -n "Tap ENTER to continue."; read
    ${PAGER-more} $lc
    err=$?
    test $err = 0 || {
        echo "Display of license agreement returned an error!"
        return $err
    }
    echo "END OF LICENSE"
}

#echo -n "Enter 'r' to read the software license file ($lc). "
#read foo
#test "$foo" = 'r' -o "$foo" = 'R' || {
#    echo "You chose to skip over the license. ${TOC_EMOTICON_WARNING}" 
#    return 1
#}


test -z "${accept_license_LICENSES}" -o "$(echo ${accept_license_LICENSES} '' | wc -w)" = "1" && {

    echo -n "Enter [y] if you accept that your copy of '${PACKAGE_NAME}' must be maintained under the terms of the license you just read every single last word of. "
    read foo
    test "x$foo" = "xy" -o "x$foo" = "xY" && return 0
    echo "You chose not to accept the license."
    return 1
}

license=${accept_license}
test -z "$license" -o "$license" = "1" && {
    echo "Select your choice of license: "
    select license in ${accept_license_LICENSES} none; do
        break
    done
}

for foo in ${accept_license_LICENSES} none; do
    got=0
    test "$foo" = "$license" && { got=$foo; break; }
 #   test "$got" = "$foo" && break
done

accept_license_LICENSE=
toc_add_config PACKAGE_LICENSE="none"

test "x$foo" = "xnone" && {
    echo "You chose no license."
    return 1
}

test "x$got" = "x0" && {
    echo "$license is not a valid license."
    return 1
}

accept_license_LICENSE=$license
toc_add_config PACKAGE_LICENSE="$license"

return 0

