/*
 * Filter module that strips away unnecessary whitespace.
 *
 * $Log: stripper.pike,v $
 * Revision 1.8  2000/12/01 15:09:42  gibreel
 * Better checking for null values.
 *
 * Revision 1.7  2000/08/17 11:00:08  gibreel
 * Returns a NULL value instead of barfing if a NULL value is passed to
 * the filter function (404 and such).
 *
 * Revision 1.6  2000/07/24 13:34:27  gibreel
 * Loginfo test.
 *
 * Revision 1.5  2000/07/24 13:32:49  gibreel
 * Loginfo test.
 *
 * Revision 1.4  2000/07/24 13:31:27  gibreel
 * Loginfo test.
 *
 * Revision 1.3  2000/07/24 13:22:39  gibreel
 * Loginfo test.
 *
 * Revision 1.2  2000/07/24 13:20:58  gibreel
 * Fortsatt i ferd med  bli opprettet.
 */

// This is for debug output
//#define RETURN_ERROR(x) http_string_answer(x)
#define RETURN_ERROR(x) 0

constant cvs_version = "$Id: stripper.pike,v 1.8 2000/12/01 15:09:42 gibreel Exp $";
int thread_safe=1;

#include <module.h>
inherit "module";
inherit "roxenlib";

int usecount;

string starttime = ctime(time());

string status()
{
   return "Called " + usecount + " times since " + starttime;
}

array register_module()
{
  return ({ MODULE_FILTER,
	    "Whitespace stripper",
	    "Strips away unnecessary whitespace from HTML code to be delivered to browsers.",
	    ({ }),
	    1
         });
}

void create()
{
    defvar("types", ({ "text/html" }), "Handled MIME types", TYPE_STRING_LIST,
	   "The MIME types to be handled by this filter. This will mostly only be text/html.");
}

mixed strip_whitespace(mixed s)
{
    array f,r = ({});
    int i;
    string t;
    
    if (!stringp(s)) return s;
    
    f = s / "\n";
    f = f - ({""});
    for (i=0;i<sizeof(f);i++) {
	sscanf(f[i],"%*[ \t]%s",t);
	if (strlen(t))
	    r += ({t});
    }
    return r * "\n";
}

mixed filter(mapping response, object id)
{
    if (!response) return response;
    if (search(query("types")-({""}),response["type"]) == -1)
	return response;
    response["data"] = strip_whitespace(response["data"]);
    return response;
}
