// Referrer Deny by David Hedbor <david@hedbor.org>
// Deny accesses to certain files based on the referrer. Useful to stop people
// from leeching your bandwidth or to make it harder for people to exploit
// cgi security holes.

#include <module.h>
inherit "module";
inherit "roxenlib";

constant cvs_version = "$Id: referrerdeny.pike,v 1.4 1999/05/24 07:35:38 neotron Exp $";
constant thread_safe=1;

void create()
{
  defvar("exts", "(\\.gif|\\.jpg|\\.png|\\.pjpg|\\.jpeg)",
	 "File Regexp", TYPE_STRING, 
	 "Files matching this regexp will be denied if their referrer "
	 "doesn't match the allowed regexp.");
  defvar("msg", "Sorry, leeching not allowed.", 
	 "Deny message", TYPE_TEXT_FIELD, 
	 "Message to send for denied accesses.");
  defvar("match", "Change Me Please", 
	 "Allowed Regexp", TYPE_STRING, 
	 "Referrers matching this regexp will not be allowed access to "
	 "files matching the file regexp.");
  defvar("noempty", 1, 
	 "Deny empty referrers ", TYPE_FLAG, 
	 "If set, always deny accesses without a referrer.");
}

mixed register_module()
{
  return ({ MODULE_FIRST, 
	      "Referrer Deny module", 
	      ("A module which allows you to deny accesses to files matching "
	       "a certain regexp based on their referrer. Useful to stop "
	       "people from leeching images or files from your server "
	       "without your permission."), 
	    ({}), 0 });
}

object freg, areg;

void start()
{
  catch { 
    freg = Regexp(QUERY(exts));
    areg = Regexp(QUERY(match));
  };
}

mixed first_try(object id)
{
  if((sizeof(id->referer*"") || QUERY(noempty)) &&
     freg->match(id->not_query) && !areg->match(id->referer * " "))
  {
    // Tada. This sucker is asking to be denied. We won't let them down.
    // Cowabunga.
#ifdef LOG_DENIES
    werror("Denied access to %s\n  with referrer [%s].\n"
	   "  with user agent [%s]\n  from [%s]\n",
	   id->not_query, id->referer * " ", id->client * " ",
	   id->remoteaddr);
#endif
    return http_low_answer(403, QUERY(msg));
  }
#if 0
  if(!sizeof(id->referer*""))
    werror("Warning: Empty referrer to %s\n"
	   "  with user agent [%s]\n  from [%s]\n",
	   id->not_query, id->client * " ",
	   id->remoteaddr);
#endif
}
