/*
  imho_romanian.pike v0.1 for IMHO v0.98.3
  
  Copyright  
  Andreea Munteanu <andreea@trej.net> 2001

  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

string imho_lang() {
  return "romana";
}

string imho_lang_short() {
  return "ro";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  // This isn't needed anymore since IMHO now encodes characters that cannot be represented by
  // the current characterset as HTML entities.
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    return("Conecteaza:");
  case M_PASSWORD:
    return "Parola:";

  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Acces imposibil:</b> Parola gresita sau conectare incorecta.Incearca din nou. ";

  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Problema cu serverul IMAP.Contacteaza administratorul sistemului.";


  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Problema cu serverul pentru mesaj trimis SMTP, mesajul nu a fost trimis.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Din preferinte";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Interfata utilizator:";

  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "Compune";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
   // return sprintf("Brevlda: %s",@arg);
    return sprintf("Casuta postala: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Casute postale";
  case M_FILES:
    //return "Files";
    return "Fisiere";
  case M_PREFS:
    //return "Preferences";
    return "Preferinte";
  case M_LOGOUT:
    //return "Logout";
    return "Deconecteaza";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Casuta postala curenta";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Verifica casutele postale active";
  case M_FROM:
    //return "From";
    return "Expeditor";
  case M_TO:
    //return "To";
    return "Destinatar";
  case M_CC:
    //return "Cc";
    return "Copie";
  case M_BCC:
    //return "Bcc";
    return "Copie ascunsa";
  case M_SUBJECT:
    //return "Subject";
    return "Subiect";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Anexe";
  case M_TIME:
    //return "Time";
    return "Ora";
  case M_DATE:
    //return "Date";
    return "Data";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Trimite";
  case M_CANCELSEND:
    //return "Cancel";
    return "Anuleaza";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Selecteaza fisierele de trimis. Apasa pe 'Ctrl' pentru selectie fisiere multiple.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Compune mesaj";
  case M_SPELLCHECK:
    return "Verifica ortografia";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Nu salva mesajul acesta.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Ataseaza fisierul";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Fara anexe";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Ataseaza...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Anuleaza anexele marcate";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Incarca fisierul la anexe.";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Adauga fisierele marcate la anexe";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Incarca fisierul la anexe";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Revenire la mesaj";
  case M_NOATTACHFILES:
    //return "No files";
    return "Nu exista fisiere";
  case  M_ATTACHMENTSHEADER:
    return "Anexe";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Mesajul a fost trimis,dar salveaza-l in dosarul pentru esuari.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Trebuie specificat destinatarul mesajului.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Raporteaza trimiterea intirziata.";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Raporteaza trimiterea indeplinita.";
  case M_SAVEDRAFT:
    //return("Save draft");
    return("Salveaza schita");
  case M_SAVEDRAFTINSESSION:
    //return("Save draft (during session)");
    return("Salveaza schita (in timpul sedintei)");
  case M_COMPOSEDRAFT:
    //return("You have a draft mail saved. Do you want to start from it now?");
    return("Ai o schita de mesaj salvata. Vrei sa incepi de aici acum?");
  case M_DRAFTEXISTS:
    // return("There is already another draft mail saved.");
    return("Mai exista o alta schita de mesaj salvata.");
  case M_OVERWRITEDRAFT:
    //return("Owerwrite current draft");
    return("Rescrie schita curenta.");
  case M_DISCARDDRAFT:
    //return("Discard current mail, keep draft");
    return("Ignora mesajul curent, pastreaza schita"); 
  case M_SENDBROKENADDR:
    //return(sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0]));
    //return(sprintf("Adressen \"%s\" r inte korrekt. Rtta till felet och frsk igen.", arg[0])); 
    return(sprintf("Adresa \"%s\" nu este o adresa de posta electronica corecta.Corecteaz-o si incearca din nou.", arg[0])); 
  case M_SAVEMAILCOPY:
    //return("Save a copy");  
    return("Salveaza o copie");

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Anuleaza fisierele marcate";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Muta fisierele marcate la";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Selecteaza o casuta postala)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Verifica noile mesaje";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Mesaje %d-%d / %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Precedent %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Urmatorul %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return(sprintf("Esti sigur(a) ca vrei sa anulezi mesajele marcate %d ?",@arg));
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Marcheaza citeva mesaje prima data.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Schimba ordinea sortarii";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Trimite mesajele marcate la gunoi";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Anuleaza mesajele de la gunoi";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Nu exista mesaje]";
  case M_MARKALL:
    //return "Mark all";
    return "Marcheaza tot";
  case M_PAGEGO:
    //return "Go";
    return "Mergi la";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Casuta postala";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Anuleaza mesajele marcate";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Creeaza o noua casuta postala";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nume)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Esti sigur(a) ca vrei sa anulezi urmatoarele casute postale?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Marcheaza cel putin o casuta postala.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Tasteaza un nume prima data.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Esec in crearea unei casute postale. Nume ilegal sau casuta postala existenta deja.";
  case M_INBOX:
    //return "Inbox";
    return "Casuta";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Nivelul precedent]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Cale:";
  case M_BOXTRASH:
    //return "Trash";
    return("Gunoi");
  case M_BOXSENTMAIL:
    //return "Sent";
    return("Trimis");
  case M_USEMARKEDINMENULIST:
    //return "Use marked in menu list";
    return "Utilizeaza fisierele marcate in menu";
  case M_CHANGEINBOXESMSG:
    // return "The marked mailboxes will appear in the menu after you\n"
    // "reload the whole page or re-login.";
    // return "De markerade brevldorna kommer synas i menylistan om du\n"
    //  "laddar om sidan eller loggar in igen.";
	return "Casutele postale marcate vor aparea in menu dupa ce\n"
	"reincarci intreaga pagina sau te reconectezi";


  case M_FILENAME:
    //return "Filename";
    return "Nume fisier";
  case M_SIZE:
    //return "Size";
    return "Marime";
  case M_MIMETYPE:
    //return "Type";
    return "Tip";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Anuleaza fisierele marcate";
  case M_UPLOAD:
    //return "Upload";
    return "Incarca";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Ai %d Kb disponibil pentru incarcat fisiere.",@arg);
  case M_WINDOWSBUG :
    return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";


  case M_NOFILES:
    //return "You have no uploades files.";
    return "Nu ai incarcat nici un fisier.";

  case M_PNAME:
    //return "Name";
    return "Nume";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Adresa electronica";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Cale de cautare a postei";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Include mesajul original cind raspunzi expeditorului";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Semnatura";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Deconectare inactiva (minute)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Salveaza si utilizeaza";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Mesaje afisate in casuta";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Ordinea sortarii mesajelor";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    //return ([ "forward": "framlnges", "backward":"baklnges"])[arg[0]];
    return ([ "forward": "foreward", "backward":"backward"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Locatie gunoi";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Dosar mesaje trimise";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Adresa copie ascunsa in lipsa";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Salveaza anexele";
  case M_PLANGUAGE:
    //return "Language";
    return "Limba";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Interfata utilizator";
  case M_PINBOXES:
    //return "Inboxes";
    return "Casute";
  case M_PCOMMASEPARATED: 
    //return "(Comma separated list of mailboxes)";
    return "(Lista de casute postale separate prin virgula)";
  case M_PHEADER:
    //return "Extra headers";
    return "Extra antete";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Siruri cu antete in acest format: antet:valoare)";
  case M_PSORTCOLUMN:
    //return "Sort on column";
    return("Sorteaza pe coloana");
  case M_PSHOWHTML:
    // return "Show HTML messages";
    return("Afiseaza mesajele HTML");
  case M_PSHOWHIDDENHEADERS:
    return "Enable <i>\"Show full headers\"</i>-button";
    // return("\"Visa all mailinfo\"-knapp");
  case M_PMAILADDRESSDESC:
    //return "(List of addresses from which you would like to be able to send mail. One per line or comma-separated.)";
    return "(Lista cu adrese din care sa poti trimite  mesaje.Cite una pe linie sau despartite prin virgula.)";
  case M_PPROCMAIL:
    //return "Filtering";
    return "Filtru";
  case M_PPROCMAILDESC:
    return "(Filtering directives in the form <code>mailbox to/from/subject toaddr/fromaddr/subject (regexp))</code><br><i><b>Note:</b> Only rules created using this interface are affected</i><br>Examples:<pre>hugbox    from     hugs@someplace.cozy\nlistbox   to       list@lots.of.maillists\nspambox   subject  .*SPAM.*</pre>";
   //  return "(Filtreringsdirektiv i formatet <code>mailbox to/from/subject toaddr/fromaddr/subject (regexp))</code><br><i><b>Notera:</b> Endast regler skapade i detta grnssnitt pverkas</i><br>Exampel:<pre>hugbox    from     hugs@someplace.cozy\nlistbox   to       list@lots.of.maillists\nspambox   subject  .*SPAM.*</pre>";
  case M_PFORWARDING:
    //return "Forwarding";
    return "Inaintare";
  case M_PFORWARDINGDESC:
    return "(List of addresses to forward your incoming mail to. One per line or comma-separated.)";
    // return "(Lista cu adrese in care sa trimiti mesajele care sosesc.)";



  case M_SPELLDONE:
    //return "Done";
    return "Corectare efectuata";
  case M_SPELLPREV:
    //return "Previous";
    return "Precedent";
  case M_SPELLNEXT:
    //return "Next";
    return "Urmatorul";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Inlocuieste cu";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Sugestii";
  case M_NOSPELLINGERRORS:
    // return "No spelling errors found.";
    return "Nu sunt greseli de ortografie";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "Esti deconectat.Inchide acest navigator pentru a fi sigur(a) ca nimeni nu-ti citeste mesajele.<br><br>Reincarca aceasta pagina pentru a te conecta.";

  case M_LOGGEDOUT:
    //return "Logged out";
    return "Deconectat";

  case M_QUESTION:
    //return "Question"; 
    return "Intrebare";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Raspuns";
  case M_READPREV:
    //return "Read previous";
    return "Citeste precedentul";
  case M_READNEXT:
    //return "Read next";
    return "Citeste urmatorul";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sanexe cu tip %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Eroare:</b> Esec in recuperarea mesajului.Incearca din nou.<br>";

  case M_MAILMISSINGBACK:
    //return "Back";
    return "Revenire";
  case M_DELETE:
    //return "Delete";
    return "Anuleaza";
  case M_FORWARD:
    //return "Forward";
    return "Inainteaza";
  case M_MAIL:
    // return "Mail";
    return "Posta";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Afiseaza antetele";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Ascunde antetele";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Mesajul e prea mare pentru a putea fi afisat.Da click aici pentru a-l salva.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Raspuns la tot";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Trimite la gunoi";
  case M_CHARSETWARNING:
    return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    // return sprintf("Varning! Misslyckades med att avkoda teckenuppsttningen \"%s\". Meddelandet r ej avkodat.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Adrese");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Adrese...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Nume de index (da click pentru a adauga ca destinatar)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nume de index (da click pentru a redacta)");
  case M_ADDRESS:
    //return("Address");
    return("Adresa electronica");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Nu exista adrese");
  case M_NEWADDRESS:
    //return("New address...");
    return("Adresa noua...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Redacteaza adresa");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Adauga la adrese");
  case M_INDEXNAME:
    //return("Index name");
    return("Nume de index");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Adresa(e) electronica(e), despartita(e) prin virgula");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Salveaza si utilizeaza");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Anuleaza adresa");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Anuleaza");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Imposibil de introdus aceste adrese, format nerecunoscut.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Introdu adrese");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Incarca un fisier Pine sau Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Fisierul de adrese Pine se gaseste adesea in ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Incarca si introdu");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Introdu adrese...");
  case M_GLOBALADDRESSES:
    return("Adrese comune:");
  case M_INSERTMARKEDADDRESSES:
    //return("Insert marked");
    return("Insereaza adresa marcata");
  case M_DELETEMARKEDADDRESSES:
    //return("Delete marked");
    return("Anuleaza adresa marcata");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("Adrese LDAP");
  case M_LDAP:
    //return("LDAP search");
    return("Cautare LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Cauta LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Cauta numele care contine:");
  case M_OU:
    //return("OU");
    return("OU");

 case M_MAILNOTIFYWINDOW:
   //return("Mail notification...");
    return("Anunt mesaje...");
  case M_GETNEWMAIL:
    //return("Get new mail...");
    return("Primeste mesaje noi...");

  case M_SEARCHMAILTITLE:
    //return("Search mail");
    return("Cauta mesaje");
  case M_SEARCHMAIL:
    //return("Search...");
    return("Cauta...");
  case M_SEARCHMAILBOX:
    //return(sprintf("Find mail in mailbox <b>%s</b> which contains",arg[0]));
    return(sprintf("Gaseste mesaje in casuta <b>%s</b> care contine",arg[0]));
  case M_SEARCHANYWHERE:
    //return("anywhere");
    return("oriunde");
  case M_SEARCHFROMFIELD:
    //return("in 'from' field");
    return("in domeniul 'expeditor'");
  case M_SEARCHTOFIELD:
    //return("in 'to' field");
    return("in domeniul 'destinatar'");
  case M_SEARCHSUBJECT:
    //return("in subject");
    return("in subiect");
  case M_SEARCHBODY:
    //return("in mail body");
    return("in corpul de mesaje");
  case M_SEARCHAND:
    //return("AND");
    return("SI");
  case M_SEARCHSHOWINGMAIL:
    //return("Showing mail with ");
    return("Afiseaza mesajul cu ");

  case M_YES:
    //return "Yes";
    return "Da";
  case M_NO:
    //return "No";
    return "Nu";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Anuleaza";
   
  }
  return 0;
}
