// 
// From Torsten.Hentschel@dinet.de Mon Jun  9 17:50:47 1997
// Date: Mon, 9 Jun 1997 16:21:32 +0200 (MET DST)
// From: Torsten Hentschel <Torsten.Hentschel@dinet.de>
// To: roxen@roxen.com
// Newsgroups: roxen.general
// Subject: small module: expires tag
// 
// Hi!
// 
// This days I needed to make it for end users somewhat
// easier to create their semi-dynamic pages with roxen.
// My problem was: How to make an expire header configurable.
// The syntax of
// 
//   <HEADER NAME="Expires" VALUE="Mon, 09 Jun 1997 12:30:01 +0000">
// 
// is somewhat cruel. For an end user the exact syntax is
// hard to remember. So I wrote a little module for roxen to fix
// this problem. I simply appended it to this mail.
// 
// The module adds the expires tag. Syntax is
// 
//   <EXPIRES SECONDS=12 MINUTES=7 HOURS=1 DAYS=13>
// 
// Each argument is optional. You may omitt all of
// them. This will create an expires header with
// the epoche that should expire immediately anywhere.
// 
// Just insert this tag anywhere in your document
// (preferably within <HEAD> ... </HEAD>).
// Hope this module is useful for someone else than me.
// 
// Regards,
// 
//   Torsten Hentschel
// 
// -- 
// 
//    Delta Internet              http://www.DInet.de/
// 				  Tel. +49 2932 91 6 161
//   Zeit UmZuDenken!             Fax. +49 2932 91 6 230
// 
// 
// 
// 
// ------8<----------
string cvs_version = "$Id: expires.pike,v 0.1 1997/06/09 15:09:01 todd Exp $";
#include <module.h>
inherit "module";
inherit "roxenlib";

array register_module()
{
  return ({ MODULE_PARSER,
            "Expires tag",
            "This module adds the tag &lt;expires&gt;. It makes it possible"
            " to easily add an expires header relative to the actual time."
            " You may specify time in seconds, minutes, hours and days from now."
            " Therefore the tag takes the arguments &lt;expires"
            " seconds=... minutes=..."
            " hours=... days=...&gt;. All arguments are optional. If none is given"
            " the epoche is inserted as expire header, so that the document will"
            " expire immediately. You may also give negative arguments. Just"
            " experiment with them.",
            ({}), 1 });
}

string expires_tag( string tag_name, mapping arguments,
                    object request_id, object file, mapping defines )
{
  int t;
  int seconds;
  int minutes;
  int hours;
  int days;

  t = 0;

  if (arguments->seconds) {
    if ( 1 == sscanf( arguments->seconds, "%d", seconds ) ) {
      t += seconds;
    }
  }

  if (arguments->minutes) {
    if ( 1 == sscanf( arguments->minutes, "%d", minutes ) ) {
      t += minutes * 60;
    }
  }

  if (arguments->hours) {
    if ( 1 == sscanf( arguments->hours, "%d", hours ) ) {
      t += hours * 3600;
    }
  }

  if (arguments->days) {
    if ( 1 == sscanf( arguments->days, "%d", days ) ) {
      t += days * 86400;
    }
  }

  if ( 0 != t ) {
    t += time();
  }

  request_id->misc->moreheads = ([ "Expires":http_date(t), ]);

  return "";
}

mapping query_tag_callers() { return (["expires":expires_tag,]); }

mapping query_container_callers() { return ([]); }

