/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_PLOT_ITEM
#define QWT_PLOT_ITEM

#include "qwt_global.h"

class QwtPlot;

/*!
  \brief Base class for items on the plot canvas
*/

class QWT_EXPORT QwtPlotItem
{
public:
    QwtPlotItem(QwtPlot *parent, bool nbl = TRUE);

    void reparent(QwtPlot *plot);

    //! \return parent plot
    QwtPlot *parentPlot() { return d_parent; }

    //! \return parent plot
    const QwtPlot *parentPlot() const { return d_parent; }
    
    virtual void setEnabled(bool);
    bool enabled() const;

    virtual void itemChanged();

private:
    bool d_enabled;
    QwtPlot *d_parent;
};
            

/*!
  \brief Base class for items on the plot canvas,
  that are attached to x and y axes.
*/
class QWT_EXPORT QwtPlotMappedItem : public QwtPlotItem 
{
public:
    QwtPlotMappedItem(QwtPlot *parent, bool nbl = TRUE);
    
    void setAxis(int xAxis, int yAxis);

    void setXAxis(int axis);
    int xAxis() const;

    void setYAxis(int axis);
    int yAxis() const;

private:
    int d_xAxis;
    int d_yAxis;
};

#endif
