#include <qapplication.h>
#include <qwt_plot.h>
#include <math.h>

//-----------------------------------------------------------------
//              simple.cpp
//
//      A simple example which shows how to use QwtPlot
//-----------------------------------------------------------------

class Plot : public QwtPlot
{
public:
    Plot();
};


Plot::Plot()
{
    setTitle("A Simple QwtPlot Demonstration");
    setAutoLegend(TRUE); // We want a legend
	setLegendPos(Qwt::Right);

    // Set axis titles
    setAxisTitle(xBottom, "x -->");
    setAxisTitle(yLeft, "y -->");
    
    // Insert new curves
    long cSin = insertCurve("y = sin(x)");
    long cCos = insertCurve("y = cos(x)");

    // Set curve styles
    setCurvePen(cSin, QPen(red));
    setCurvePen(cCos, QPen(blue));

    //
    //  Calculate some values
    //
	const int nPoints = 100;
    double x[nPoints];
    double y[nPoints];
    double z[nPoints];

    for (int i = 0; i < nPoints; i++)
    {
        x[i] = 0.1 * double(i);
        y[i] = sin(x[i]);
        z[i] = cos(x[i]);
    }

    // Copy the data    
    setCurveData(cSin, x, y, nPoints);
    setCurveData(cCos, x, z, nPoints);

    // Insert markers
    
    //  ...a horizontal line at y = 0...
    long mY = insertLineMarker("y = 0", QwtPlot::yLeft);     
    setMarkerYPos(mY, 0.0);

    //  ...a vertical line at x = 2 * pi
    long mX = insertLineMarker("x = 2 pi", QwtPlot::xBottom);
    setMarkerXPos(mX, 6.284);

	replot();
}

int main(int argc, char **argv)
{
    QApplication a(argc, argv);
    Plot plot;
    a.setMainWidget(&plot);
	plot.resize(500,300);
    plot.show();
    return a.exec(); 
}
