#ifndef _REALTIMEPLOT_H_
#define _REALTIMEPLOT_H_ 1

#include <qarray.h>
#include <qintdict.h>
#include "incrementalplot.h"

class RealtimeCurveData
{
public:
	RealtimeCurveData();

	void append(double *x, double *y, int count);
	int count() const;
	int size() const;
	double *X() const;
	double *Y() const;

private:
	int _count;
	QArray<double> _x;
	QArray<double> _y;
};

class RealtimePlot : public IncrementalPlot
{
	Q_OBJECT;
public:
	RealtimePlot(QWidget *parent = 0, const char *name = 0);
	virtual ~RealtimePlot();

	virtual void appendCurveData(long curveId,
		double *x, double *y, int size);

	void removeCurveData(long curveId);
private:

	QIntDict<RealtimeCurveData> _curveDictionary;
};

#endif // _REALTIMEPLOT_H_
