#include <qapp.h>
#include <qfont.h>
#include <qwt_thermo.h>
#include <qlabel.h>
#include <iostream.h>
#include <fstream.h>
#include <qwt_math.h>

class MainWin : public QWidget 
{
public:

    enum {MemUsed, MemShared, MemBuffers, MemCached, SwapUsed, ThermoCnt };
    QwtThermo *th[ThermoCnt];
    QLabel  *lb[ThermoCnt];
    int tmrID;
    
public:

    MainWin();
    ~MainWin();
    void start();
    void update();
    
protected:

    void timerEvent(QTimerEvent *e);
    
};


void MainWin::start()
{
    update();
    tmrID = startTimer(2000);
}


void MainWin::update()
{
    double mtotal, mused, mcached, mshared, mbuffers, mfree;
    double stotal, sused, sfree;
    static char buffer[81];
    QString text;	
    ifstream inp("/proc/meminfo");

    inp.getline(buffer, 80);
    inp >> buffer >> mtotal >> mused >> mfree >> mshared >> mbuffers
       >> mcached;
    inp >> buffer >> stotal >> sused >> sfree;

    mtotal *= 0.01;
    stotal *= 0.01;

    mused /= mtotal;
    mshared /= mtotal;
    mbuffers /= mtotal;
    mcached /= mtotal;
    sused /= stotal;
    
    // set values
    th[MemUsed]->setValue(mused);
    th[MemShared]->setValue(mshared);
    th[MemBuffers]->setValue(mbuffers);
    th[MemCached]->setValue(mcached);
    th[SwapUsed]->setValue(sused);

    text.setNum(mused, 'g', 3);
    text = QString("Used: ") + text + QString(" %"); 
    lb[MemUsed]->setText(text);
    
    text.setNum(mshared, 'g', 3);
    text = QString("Shared: ") + text + QString(" %"); 
    lb[MemShared]->setText(text);

    text.setNum(mbuffers, 'g', 3);
    text = QString("Buffers: ") + text + QString(" %"); 
    lb[MemBuffers]->setText(text);

    text.setNum(mcached, 'g', 3);
    text = QString("Cache: ") + text + QString(" %"); 
    lb[MemCached]->setText(text);

    text.setNum(sused, 'g', 3);
    text = QString("Swap Used: ") + text + QString(" %"); 
    lb[SwapUsed]->setText(text);
}


void MainWin::timerEvent(QTimerEvent *)
{
    update();
}



MainWin::MainWin()
: QWidget()
{

    int i;

    QFont fnThermo("Helvetica", 8);
    QFont fnLabel("Helvetica", 10);
    QColor cFill("DarkMagenta");

    //
    // initialize members
    //
    tmrID = 0;

    //
    // create widgets
    //
    for(i=0;i<ThermoCnt;i++)		
       th[i] = new QwtThermo(this,"");
    
    lb[MemUsed] = new QLabel("Used",this);
    lb[MemShared] = new QLabel("Shared",this);
    lb[MemCached] = new QLabel("Cache",this);
    lb[MemBuffers] = new QLabel("Buffers",this);
    lb[SwapUsed] = new QLabel("Swap Used",this);

    //
    // place widgets
    //
    for (i=0; i<ThermoCnt; i++)
    {
	lb[i]->setGeometry(0,i*65,130,20);
	th[i]->setGeometry(0,20 + i * 65 ,130,45);
    }

    //
    // configure thermometers
    //
    for (i=0;i<ThermoCnt;i++)
    {
	th[i]->setOrientation(QwtThermo::Horizontal, QwtThermo::Bottom);
	th[i]->setRange(0.0,100.0);
	th[i]->setValue(0.0);
	th[i]->setFont(fnThermo);
	th[i]->setPipeWidth(6);
	th[i]->setScaleMaxMajor(6);
	th[i]->setScaleMaxMinor(5);
	th[i]->setMargin(10);
	th[i]->setFillColor(cFill);
    }

    //
    // configure labels
    //
    for (i=0;i<ThermoCnt;i++)
    {
	lb[i]->setFont(fnLabel);
	lb[i]->setAlignment(AlignCenter);
    }
    

    setCaption("Memory Usage");
    setFixedSize(130,325);
}


MainWin::~MainWin()
{
    int i;

    for(i=0;i<ThermoCnt;i++)
    {	
	delete th[i];
	delete lb[i];
    }   
    if (tmrID != 0) killTimer(tmrID);
}


int main (int argc, char **argv)
{
    QApplication a(argc, argv);

    MainWin w;
    w.resize(180,140);

    a.setMainWidget(&w);
    w.start();
    w.show();
    
    return a.exec();
}









