#include <quicktime/lqt.h>
#include <quicktime/colormodels.h>
#include <funcprotos.h>

#include <string.h>

#include "lqt_xanim.h"

int lqt_xanim_decode_video_1(quicktime_t *file, unsigned char **row_pointers, 
                             int track)
  {
  int compressed_size, result, bpp, i, use_temp;
  int video_width, video_height;

  quicktime_trak_t *trak = file->vtracks[track].track;
  
  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_1_t * codec =
    (lqt_xanim_codec_1_t*)(((quicktime_codec_t*)vtrack->codec)->priv);

  video_height = trak->tkhd.track_height;
  video_width = trak->tkhd.track_width;
  
  quicktime_set_video_position(file, vtrack->current_position, track);
  compressed_size =
    quicktime_frame_size(file, vtrack->current_position, track);
  
  if(codec->work_buffer_size < compressed_size)
    {
    codec->work_buffer = realloc(codec->work_buffer, compressed_size);
    codec->work_buffer_size = compressed_size;
    }
  result = !quicktime_read_data(file, codec->work_buffer, compressed_size);

  codec->decode_func(codec->pixel_buffer, codec->work_buffer,
                     compressed_size, &(codec->info));
  
  if(file->color_model != XANIM_COLORMODEL ||
     file->in_x != 0 ||
     file->in_y != 0 ||
     file->in_w != video_width ||
     file->in_h != video_height ||
     file->out_w != video_width ||
     file->out_h != video_height)
    {
    cmodel_transfer(row_pointers, /* Leave NULL if non existent */
                    codec->pixel_buffer_rows,
                    row_pointers[0], /* Leave NULL if non existent */
                    row_pointers[1],
                    row_pointers[2],
                    NULL, /* Leave NULL if non existent */
                    NULL,
                    NULL,
                    file->in_x, 
                    file->in_y, 
                    file->in_w, 
                    file->in_h,
                    0,       /* Dimensions to project on output frame */
                    0, 
                    file->out_w, 
                    file->out_h,
                    XANIM_COLORMODEL, 
                    file->color_model,
                    0,      /* When transfering BC_RGBA8888 to non-alpha this is the background color in 0xRRGGBB hex */
                    video_width * 4,       /* For planar use the luma rowspan */
                    file->out_w);          /* For planar use the luma rowspan */
    }
  else
    {
    for(i = 0; i < video_height; i++)
      memcpy(row_pointers[i], codec->pixel_buffer_rows[i], video_width * 4);
    
    }
  
  return result;
  }

int lqt_xanim_decode_video_2(quicktime_t *file, unsigned char **row_pointers, 
                              int track)
  {
  int compressed_size, result, i, use_temp;

  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_2_t * codec = (lqt_xanim_codec_2_t*)(((quicktime_codec_t*)vtrack->codec)->priv);

  quicktime_set_video_position(file, vtrack->current_position, track);
  compressed_size =
    quicktime_frame_size(file, vtrack->current_position, track);

  if(codec->work_buffer_size < compressed_size)
    {
    codec->work_buffer = realloc(codec->work_buffer, compressed_size);
    codec->work_buffer_size = compressed_size;
    }
  result = !quicktime_read_data(file, codec->work_buffer, compressed_size);

  codec->decode_func(row_pointers[0], codec->work_buffer, compressed_size, &(codec->info));
  return result;

  }

int lqt_xanim_delete_vcodec_1(quicktime_video_map_t *vtrack)
  {
  lqt_xanim_codec_1_t * codec = (lqt_xanim_codec_1_t*)(((quicktime_codec_t*)vtrack->codec)->priv);
  if(codec->work_buffer) free(codec->work_buffer);

  if(codec->pixel_buffer)
    free(codec->pixel_buffer);
  if(codec->pixel_buffer_rows)
    free(codec->pixel_buffer_rows);

  if(codec->info.map)
    free(codec->info.map);
  
  free(codec);
  return 0;
  }

int lqt_xanim_delete_vcodec_2(quicktime_video_map_t *vtrack)
  {
  lqt_xanim_codec_2_t * codec =
    (lqt_xanim_codec_2_t*)(((quicktime_codec_t*)vtrack->codec)->priv);

  if(codec->work_buffer) free(codec->work_buffer);

  
  free(codec);
  
  return 0;
  }

void lqt_xanim_init_vcodec_1(quicktime_t * file, int track)
  {
  int video_width, video_height, i, depth;
  
  quicktime_trak_t *trak = file->vtracks[track].track;

  quicktime_ctab_t * ctab;
  
  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_1_t * codec = (lqt_xanim_codec_1_t*)(((quicktime_codec_t*)vtrack->codec)->priv);

  video_height = trak->tkhd.track_height;
  video_width = trak->tkhd.track_width;
  depth = quicktime_video_depth(file, track);

  init_xanimcodecs();
  
  codec->info.cmd = 0;                 /* decode or query */
  codec->info.skip_flag = 0;           /* skip_flag */
  codec->info.imagex = video_width;
  codec->info.imagey = video_height;   /* Image Buffer Size */
  codec->info.imaged = 32;             /* Image depth */
  codec->info.chdr = 0;                /* Color Map Header */
  codec->info.map_flag = 1;            /* remap image? */
  codec->info.map = 0;                 /* map to use */
  codec->info.xs = 0;
  codec->info.ys = 0;                  /* pos of changed area */
  codec->info.xe = 0;                  /* size of change area */
  codec->info.ye = 0;
  codec->info.special = 0;             /* Special Info */
  codec->info.extra = 0;               /* Decompression specific info */

  codec->pixel_buffer =
    calloc(video_width * video_height * 4, sizeof(char));
  
  codec->pixel_buffer_rows = calloc(video_height, sizeof(char*));
  
  for(i = 0; i < video_height; i++)
    codec->pixel_buffer_rows[i] = &(codec->pixel_buffer[i*video_width*4]);

  /* Create the colormap */

  ctab = &(trak->mdia.minf.stbl.stsd.table->ctab);

  if(!ctab->size)
    xanim_create_qt_colormap(&(codec->info), depth,
                             quicktime_video_compressor(file, track));
  else
    {
    codec->info.map = malloc(sizeof(xaULONG)*ctab->size);

    for(i = 0; i < ctab->size; i++)
      {
      codec->info.map[i]  = (xaULONG)(ctab->red[i]   & 0xff00) << 8; 
      codec->info.map[i] |= (xaULONG)(ctab->green[i] & 0xff00);
      codec->info.map[i] |= (xaULONG)(ctab->blue[i]  & 0xff00) >> 8; 
      /*    fprintf(stderr, "map[%d]: 0x%08x\n", i, info->map[i]); */
      }
    }
  
  codec->initialized = 1;
  }

void lqt_xanim_alloc_temp_frame_1(quicktime_t * file, int track)
  {
  int i;
  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_1_t * codec =
    (lqt_xanim_codec_1_t*)(((quicktime_codec_t*)vtrack->codec)->priv);
  
  codec->pixel_buffer =
    calloc(codec->info.imagex * codec->info.imagey * 4, sizeof(char));
  
  codec->pixel_buffer_rows = calloc(codec->info.imagey, sizeof(char*));
  
  for(i = 0; i < (int)codec->info.imagey; i++)
    codec->pixel_buffer_rows[i] =
      &(codec->pixel_buffer[i*codec->info.imagex*4]);
  }


void lqt_xanim_init_vcodec_2(quicktime_t * file, int track)
  {
  quicktime_video_map_t *vtrack = &(file->vtracks[track]);
  lqt_xanim_codec_2_t * codec = (lqt_xanim_codec_2_t*)(((quicktime_codec_t*)vtrack->codec)->priv);
  
  }
