/*
 *  Jajuk
 *  Copyright (C)2006  bflorat
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  $Revision: 1.3 $
 */


package org.qdwizard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * 
 *  Screen Header
 *
 * @author     Bertrand Florat
 * @created    1 mai 2006
 */
class Header extends JPanel{
        
    private static final long serialVersionUID = 1L;
	JLabel jta;
    
    /**
     * 
     * @param sTextID I18N ID of header
     */
    public Header(){
        setLayout(new GridLayout());
        jta = new JLabel(); 
        jta.setOpaque(true);
        jta.setForeground(Color.BLACK);
        jta.setBackground(Color.WHITE);
        jta.setFont(new Font("Dialog",Font.PLAIN,14)); //$NON-NLS-1$
        jta.setPreferredSize(new Dimension(0,70));
        add(jta); //$NON-NLS-1$
    }
    
    /**
     * Set the header text
     * @param sText
     */
    public void setText(String sText){
        jta.setText(sText);
    }
    
}