/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_GLOBALS_H
#define LIBPOLYXMASS_GLOBALS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  /*
    #define _(String) (String)
    #define N_(String) String
    #define textdomain(GETTEXT_PACKAGE)
    #define bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR)
  */

  /* When ready for the gettext step, change lines above with:
   */
  // #include <libintl.h>  replace with the wrapper ENABLE_NLS depending one:
#include "gettext.h" // see gettext manual page 111.
#define _(String) gettext (String) 
#define gettext_noop(String) String 
#define N_(String) gettext_noop (String)
  /*
   */

#define debug_printf( x ) \
{ \
  printf ( "%s @ %u : ", __FILE__, __LINE__ ); \
  printf x; \
  fflush ( stdout ); \
}

  /* to format the position of the * in pointers:
   * First operate this regexp replace: \([a-z]\)\* to \1 *
   * Next operate this regexp replace: \([a-z]\) \* \([a-z]\) to \1 *\2
   */

#if 0

  The way to change all the debug_printf statement into commented
  material is by using the following sed script:

  sed 's|debug_printf (\(.*\));|/\*debug_printf (\1);\*/|'

#endif


  /* all the includes */
#include <glib.h>
#include <math.h>
#include <stddef.h>
#include <limits.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <stdlib.h>
#include <locale.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


  /* ************************** GLIB IMPORTS ***************************
   * these data have been imported from the glib (garray.c) in order 
   * to be able to write a function that was not available at the time
   * of this writing : the function g_ptr_array_insert_val () below.
   */
  /* #define imported from glib with no change
   */
#define MIN_ARRAY_SIZE  16

  /* typedef imported with no change
   */
  typedef struct _GRealPtrArray  GRealPtrArray;

  /* struct definition imported with no change
   */
  struct _GRealPtrArray
  {
    gpointer *pdata;
    guint     len;
    guint     alloc;
  };

  void 
  g_ptr_array_maybe_expand (GRealPtrArray *array, gint len);

  gint 
  g_nearest_pow (gint num);

  /* this one I had to write myself because it did not exist in the glib
   * Returns: a pointer to the data after insertion at 'index'.
   */
  gpointer 
  g_ptr_array_insert_val (GPtrArray * farray, guint index,
			  gpointer data);
  /* *********************** END OF GLIB IMPORTS ************************
   */




  /********************** GENERALLY UNIVERSAL DEFINES **********************/
#define MAX_LINE_LENGTH 1000
#define MAX_ATOM_SYMBOL_LEN 2

#define CONFIG_USER 1
#define CONFIG_SYSTEM 2
#define CONFIG_BOTH 3

#define CONFIG_APPEND 1
#define CONFIG_PREPEND 2

  /* The delimitor for separating monomer codes in a string.
   */
#define libpolyxmass_globals_delim '@'


  /* Chemical entities that may modify the outcome of a mass calculation
   * or of a formula calculation. We have two kinds of chemical entities,
   * the ones that apply onto the polymer, and the ones that apply onto
   * monomers.
   */
  typedef enum _PxmEnd PxmEnd;
  typedef enum _PxmFragEnd PxmFragEnd;
  typedef enum _PxmMnmChement PxmMnmChement;
  typedef enum _PxmPlmChement PxmPlmChement;
  typedef enum _PxmMasscalcRes PxmMasscalcRes;
  typedef enum _PxmMasscalcTarget PxmMasscalcTarget;
  typedef enum _PxmCompcalcRes PxmCompcalcRes;
  typedef enum _PxmCapping PxmCapping;
  typedef enum _PxmMassType PxmMassType;
  typedef enum _PxmMassTolerance PxmMassTolerance;
  
  typedef enum _PxmHowCmp PxmHowCmp;
  typedef enum _PxmHowDup PxmHowDup;

  enum _PxmEnd
    {
      PXM_END_NONE = 1 << 0,
      PXM_END_LEFT = 1 << 1,
      PXM_END_RIGHT = 1 << 2,
      PXM_END_BOTH = (PXM_END_LEFT | PXM_END_RIGHT),
    };
  
  enum _PxmFragEnd
    {
      PXM_FRAG_END_NONE = 1 << 0,
      PXM_FRAG_END_LEFT = 1 << 1,
      PXM_FRAG_END_RIGHT = 1 << 2,
      PXM_FRAG_END_BOTH = (PXM_FRAG_END_LEFT | PXM_FRAG_END_RIGHT),
    };
  
  
  enum _PxmMnmChement
    {
      PXMCHEMENT_MNM_NONE = 0,
      PXMCHEMENT_MNM_MODIF = 1,
    };
  
  enum _PxmPlmChement
    {
      PXMCHEMENT_PLM_NONE = 1 << 0,
      PXMCHEMENT_PLM_LEFT_MODIF = 1 << 1,
      PXMCHEMENT_PLM_RIGHT_MODIF = 1 << 2,
      PXMCHEMENT_PLM_BOTH_MODIF = 
      (PXMCHEMENT_PLM_LEFT_MODIF | PXMCHEMENT_PLM_RIGHT_MODIF),
    };
  
  enum _PxmCapping
    {
      PXM_CAPPING_NONE = 1 << 0,
      PXM_CAPPING_LEFT = 1 << 1,
      PXM_CAPPING_RIGHT = 1 << 2,
      PXM_CAPPING_BOTH = (PXM_CAPPING_LEFT | PXM_CAPPING_RIGHT),
    };
    
  enum _PxmMasscalcRes
    {
      PXM_MASSCALC_FAILURE,
      PXM_MASSCALC_SUCCESS,
    };

  enum _PxmMasscalcTarget
    {
      PXM_MASSCALC_TARGET_WHOLE_SEQ = 1 << 0,
      PXM_MASSCALC_TARGET_SELEC_SEQ = 1 << 1,
      PXM_MASSCALC_TARGET_BOTH = 
      (PXM_MASSCALC_TARGET_WHOLE_SEQ | PXM_MASSCALC_TARGET_SELEC_SEQ),
    };

  enum _PxmCompcalcRes
    {
      PXM_COMPCALC_FAILURE,
      PXM_COMPCALC_SUCCESS,
    };

  enum _PxmMassType
    {
      PXM_MASS_NONE = 1 << 0,
      PXM_MASS_MONO = 1 << 1,
      PXM_MASS_AVG = 1 << 2,
      PXM_MASS_BOTH = (PXM_MASS_MONO | PXM_MASS_AVG),
    };
  
  enum _PxmMassTolerance
    {
      PXM_MASS_TOLERANCE_AMU = 0,
      PXM_MASS_TOLERANCE_PCT,
      PXM_MASS_TOLERANCE_PPM,
    };
  
  enum
    {
      MODIF_FAILURE = 0,
      MODIF_SUCCESS = 1,
    };
  
  enum
    {
      UN_MODIF_FAILURE = 0,
      UN_MODIF_SUCCESS = 1,
      UN_MODIF_NO_MATCH,
      UN_MODIF_NO_MODIF,
    };
  
  enum
    {
      NONE,
      INC,
      DEC,
    };

  enum 
    {
      ODD, 
      EVEN,
      ALL
    };

enum
  {
    FILE_VECTOR,
    FILE_RASTER,
    FILE_NONE,
    FILE_ANY,
    FILE_BOTH
  };

  enum _PxmHowDup
    {
      PXM_DUP_NO_DEEP = 0,
      PXM_DUP_DEEP = 1,
    };
    
  enum _PxmHowCmp
    {
      PXM_CMP_NO_DEEP = 0,
      PXM_CMP_1_SUBSET_OF_2 = 1 << 0,
      PXM_CMP_2_SUBSET_OF_1 = 1 << 1,
    };
  



  /* Numerical formats for the different weighing species and related
   * functions. See libpolyxmass-globals.c for non-extern declaration.
   */
  extern gchar* libpolyxmass_globals_atom_num_format;
  extern gchar* libpolyxmass_globals_monomer_num_format;
  extern gchar* libpolyxmass_globals_oligomer_num_format;
  extern gchar* libpolyxmass_globals_polymer_num_format;

  extern gchar *etc_polyxmass_data_cfg_file;
  extern gchar *etc_polchem_defs_cat;
  extern gchar *etc_atom_defs_cat;
  extern gchar *etc_polchem_defs_atom_defs_dic;
  


  /* NUMERAL-FORMATTING FUNCTIONS.
   */
  gchar*
  libpolyxmass_globals_set_atom_num_format (gchar* fmt);


  gchar*
  libpolyxmass_globals_set_monomer_num_format (gchar* fmt);


  gchar*
  libpolyxmass_globals_set_oligomer_num_format (gchar* fmt);


  gchar*
  libpolyxmass_globals_set_polymer_num_format (gchar* fmt);




  /* STRING MANIPULATION FUNCTIONS
   */
  gchar * 
  libpolyxmass_globals_unspacify_string (gchar **str);

  gint
  libpolyxmass_globals_parse_masses_in_text (gchar *text,
					GPtrArray *GPA);






  /* XML-format TRANSACTIONS
   */
  gchar*
  libpolyxmass_globals_format_string_lead (gchar *indent, gint offset);


  gboolean
  libpolyxmass_globals_check_xml_file (gchar *file);



  /* FILE COPYING UTILITIES
   */
  gboolean 
  libpolyxmass_globals_copy_files (gchar *dest, gchar *src);





  /* NUMERICAL <--> STRING conversions.
   */
  gboolean
  libpolyxmass_globals_strtod (gchar *str, gdouble *val);


  gboolean
  libpolyxmass_globals_strtoi (gchar *str, gint *val, gint base);


  gchar *
  libpolyxmass_globals_dtoa (gdouble val, gint prec);



  /* HELPER FUNCTIONS
   */
  gint
  libpolyxmass_globals_locate_string_in_array (gchar *string,
					       GPtrArray *GPA);
  
  gint 
  libpolyxmass_globals_fill_int_array_match_exp (gchar *exp, GArray *GA,
					     gint max);

  gint
  libpolyxmass_globals_match_int_subexp (gchar *exp, GArray *GA, gint max);

  gint
  libpolyxmass_globals_match_int_single_value_subexp (gchar * exp, 
						  GArray *GA, gint max);

  gint
  libpolyxmass_globals_match_int_bracketted_dashed_values_subexp (gchar * exp, 
							      GArray *GA, 
							      gint max);

  gint
  libpolyxmass_globals_match_int_all_subexp (GArray *GA, 
					 gint max);

  gint
  libpolyxmass_globals_match_int_even_subexp (GArray *GA, 
					  gint max);

  gint
  libpolyxmass_globals_match_int_odd_subexp (GArray *GA, 
					 gint max);
  
  gboolean
  libpolyxmass_globals_parse_range_coordinates (gchar *coords,
						gint *start, gint *end);
  


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* ifndef LIBPOLYXMASS_GLOBALS_H */

