/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_FORMULA_H
#define PXMCHEM_FORMULA_H

#include "libpolyxmass-globals.h"
#include "pxmchem-atom.h"



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


gboolean
pxmchem_formula_parse (gchar *formula, GPtrArray *atom_refGPA,
		       gint times, GPtrArray *GPA);


gboolean
pxmchem_formula_set_atomcount_in_GPA (GPtrArray *GPA,
				      PxmAtomcount* atomcount);


gboolean 
pxmchem_formula_check (gchar *formula, GPtrArray *atom_refGPA);


gboolean
pxmchem_actform_split_parts (gchar *actform,
			     GPtrArray *atom_refGPA,
			     gchar **plus,
			     gchar **minus);

gboolean
pxmchem_actform_check (gchar *actform, GPtrArray *atom_refGPA);
  


gchar * 
pxmchem_formula_make_string_from_atomcount_GPA (GPtrArray *GPA);
  
  
  
/* MASS/ELEMENTAL COMPOSITION CALCULATION FUNCTIONS
 */
gboolean
pxmchem_formula_account_mass (gchar *formula, GPtrArray *atom_refGPA,
			      gint times, PxmMasspair *masspair);

gboolean
pxmchem_actform_account_mass (gchar *actform, GPtrArray *atom_refGPA, 
			      gint times, PxmMasspair *masspair);

gboolean
pxmchem_actform_account_elemcompos (gchar *actform, GPtrArray *atom_refGPA,
				    gint times, GPtrArray *acGPA);










#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* PXMCHEM_FORMULA_H */
