/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libpolyxmass-plugin.h"
#include "libpolyxmass-note.h"


/* These were declared extern in the libpolyxmass-plugin.h.
 */
gchar *
(*libpolyxmass_prop_formatter_xml_prop_plugin) (PxmProp *prop,
						gchar *indent,
						gint offset,
						gpointer data);

gchar *
(*libpolyxmass_prop_formatter_txt_prop_plugin) (PxmProp *prop,
						gpointer data);


PxmProp *
(*libpolyxmass_prop_renderer_xml_prop_plugin) (xmlDocPtr xml_doc,
					       xmlNodePtr xml_node,
					       gpointer user_data);



gpointer
libpolyxmass_prop_choose_format_xml_prop_plugin (gchar *name)
{
  g_assert (name != NULL);
  g_assert (strlen (name) > 0);
  
  /* Depending on the PxmProp's name passed as parameter,
   * return the proper pointer that knows how to handle the
   * xml-formatting for this specific kind of PxmProp.
   */
  if (0 == strcmp (name, "MODIF"))
    return libpolyxmass_prop_format_xml_prop_default;

  else if (0 == strcmp (name, "LEFT_END_MODIF"))
    return libpolyxmass_prop_format_xml_prop_default;

  else if (0 == strcmp (name, "RIGHT_END_MODIF"))
    return libpolyxmass_prop_format_xml_prop_default;

  else if (0 == strcmp (name, "NOTE"))
    return libpolyxmass_note_prop_format_xml_note;

  /*
  else if (0 == strcmp (name, "CHEMBRIDGE"))
  return pxmchem_chembridge_prop_format_xml_node_chembridge;
  */
  
  g_log (G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE,
	_("%s@%d: plugin prop has no registered xml formatter: '%s'\n"),
	 __FILE__, __LINE__, name);
  
  return NULL;
}


gpointer
libpolyxmass_prop_choose_format_txt_prop_plugin (gchar *name)
{
  g_assert (name != NULL);
  g_assert (strlen (name) > 0);
  
  /* Depending on the PxmProp's name passed as parameter,
   * return the proper pointer that knows how to handle the
   * xml-formatting for this specific kind of PxmProp.
   */
  if (0 == strcmp (name, "MODIF"))
    return libpolyxmass_prop_format_txt_prop_default;

  else if (0 == strcmp (name, "LEFT_END_MODIF"))
    return libpolyxmass_prop_format_txt_prop_default;

  else if (0 == strcmp (name, "RIGHT_END_MODIF"))
    return libpolyxmass_prop_format_txt_prop_default;

  else if (0 == strcmp (name, "NOTE"))
    return libpolyxmass_note_prop_format_txt_note;

  /*
  else if (0 == strcmp (name, "CHEMBRIDGE"))
  return pxmchem_chembridge_prop_format_txt_chembridge;
  */
  
  g_log (G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE,
	_("%s@%d: plugin prop has no registered txt formatter: '%s'\n"),
	 __FILE__, __LINE__, name);
  
  return NULL;
}


gpointer
libpolyxmass_prop_choose_render_xml_prop_plugin (gchar *name)
{
  g_assert (name != NULL);
  g_assert (strlen (name) > 0);
  
  /* Depending on the PxmProp's name passed as parameter,
   * return the proper pointer that knows how to handle the
   * xml-formatting for this specific kind of PxmProp.
   */
  if (0 == strcmp (name, "MODIF"))
    return libpolyxmass_prop_render_xml_prop_default;

  else if (0 == strcmp (name, "LEFT_END_MODIF"))
    return libpolyxmass_prop_render_xml_prop_default;

  else if (0 == strcmp (name, "RIGHT_END_MODIF"))
    return libpolyxmass_prop_render_xml_prop_default;

  else if (0 == strcmp (name, "NOTE"))
    return libpolyxmass_note_prop_render_xml_note;

  /*
  else if (0 == strcmp (name, "CHEMBRIDGE"))
  return pxmchem_chembridget_prop_format_xml_node_chembridge;
  */

  g_log (G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE,
	_("%s@%d: plugin prop has no registered xml formatter: '%s'\n"),
	 __FILE__, __LINE__, name);
  
  return NULL;
}


