#define PHIDGETS_INTERNAL

#include <phidgets/phidgets.h>
#include <phidgets/servomotor.h>

#include <debug.h>
#include <assert.h>

void phidget_reset_PhidgetServoMotor(PhidgetServoMotor* const servo)
{
  servo->min_pulse = 0;
  servo->max_pulse = 0;
  servo->factor = 0.0;
  servo->position = 0;
}

phidget_return phidget_servomotor_set_parameters(PhidgetServoMotor* const servo,
    unsigned short const min, unsigned short const max, float const factor)
{
  if (!servo) {
    ERROR("trying to set parameters of NULL servo.");
    return PHIDGET_RET_INVALID_PARAMETER;
  }

  if (min == max) {
    WARNING("setting servo parameter min_pulse == max_pulse makes no sense.");
    return PHIDGET_RET_INVALID_PARAMETER;
  }
  
  if (min > max) {
    WARNING("setting servo parameter min_pulse > max_pulse makes no sense.");
    return PHIDGET_RET_INVALID_PARAMETER;
  }

  if (factor < 0.0 || (unsigned int)(factor * UINT_MAX) == 0) {
    WARNING("setting servo parameter factor <= 0.0 makes no sense.");
    return PHIDGET_RET_INVALID_PARAMETER;
  }

  servo->min_pulse = min;
  servo->max_pulse = max;
  servo->factor = factor;

  return PHIDGET_RET_SUCCESS;
}

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
