#ifndef _UTILYTY_LEGAL_MOVES_H
#define _UTILYTY_LEGAL_MOVES_H

#include "osl/state/numEffectState.h"

namespace osl
{
  namespace container
  {    
    class MoveVector;
  }
  namespace move_generator
  {
    struct LegalMoves
    {
      /**
       * 全ての合法手を生成する. 玉の素抜きや打歩詰の確認をする．
       * ただし, 打歩詰め絡み以外では有利にはならない手
       * （Move::hasIgnoredUnpromote）は生成しない.
       */
      static void generate(const NumEffectState&, container::MoveVector&);
      /**
       * 打歩詰め絡み以外では有利にはならない手も含め, 全ての合法手を生成す 
       * る（Move::hasIgnoredUnpromoteも生成する）. 玉の素抜きや打歩詰の確認
       * をする．
       */
      static void generateWithFullUnpromotions(const NumEffectState&, 
                                               container::MoveVector&);
    };
  }
  using move_generator::LegalMoves;
}

/* ------------------------------------------------------------------------- */

#endif /* _UTILYTY_LEGAL_MOVES_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
