/* doUndoMoveLock.t.cc
 */
#include "osl/apply_move/applyMove.h"
#include "osl/state/historyState.h"
#include "osl/record/csaRecord.h"
#include "osl/record/csaString.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>

class DoUndoMoveLockTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(DoUndoMoveLockTest);
  CPPUNIT_TEST(testLock);
  CPPUNIT_TEST(testFiles);
  CPPUNIT_TEST_SUITE_END();
public:
  void testLock();
  void testFiles();
};
CPPUNIT_TEST_SUITE_REGISTRATION(DoUndoMoveLockTest);

using namespace osl;
void DoUndoMoveLockTest::testLock()
{
  HistoryState state, state2;
  {
    DoUndoMoveLock lk(state, Move(Position(7,7), Position(7,6), PAWN, PTYPE_EMPTY, false, BLACK));
    CPPUNIT_ASSERT(state.isConsistent());
  }
  CPPUNIT_ASSERT_EQUAL(state, state2);
  {
    DoUndoMoveLock lk(state, Move::PASS(BLACK));
    CPPUNIT_ASSERT(state.isConsistent());
  }
  CPPUNIT_ASSERT_EQUAL(state, state2);
}

static void testMove(const NumEffectState& state, Move move) 
{
  {
    HistoryState state2(state);
    DoUndoMoveLock lk(state2, move);
    CPPUNIT_ASSERT(state2.state().isConsistent(state, move));
    CPPUNIT_ASSERT(state2.isConsistent());
  }
  {
    NumEffectState state2=state;
    ApplyMoveOfTurn::doMove(state2, move);
    CPPUNIT_ASSERT(state2.isConsistent(state, move));
    CPPUNIT_ASSERT(state2.isConsistent());
  }
}

void DoUndoMoveLockTest::testFiles()
{
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string filename;
  for (int i=0; (ifs >> filename); ++i) {
    if ((i % 200) == 199)
      std::cerr << '.';
    if (filename == "") 
      break;
    Record record=CsaFile(OslConfig::testCsaFile(filename)).getRecord();
    NumEffectState state(record.getInitialState());
    const vector<Move> moves=record.getMoves();
    for (size_t j=0; j<moves.size(); ++j) {
      testMove(state, moves[j]);
      testMove(state, Move::PASS(state.getTurn()));
      ApplyMoveOfTurn::doMove(state, moves[j]);
    }
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
