#include "osl/eval/pieceEval.h"
#include "osl/eval/pieceEval.tcc"
#include "osl/eval/evalTraits.h"
#include "osl/state/numEffectState.h"
#include "osl/pieceTable.h"
#include <iostream>
namespace osl
{
  // explicit template instantiation
  template int PieceEval::computeDiffAfterMove<BLACK>
  (const NumEffectState&, Move);
  template int PieceEval::computeDiffAfterMove<WHITE>
  (const NumEffectState&, Move);
}

osl::PieceEval::PieceEval(const NumEffectState& state)
{
  int ret=0;
  for (int num=0;num<Piece::SIZE;num++) {
    if (state.standMask(BLACK).test(num))
    {
      ret+=Ptype_Eval_Table.value(newPtypeO(BLACK,Piece_Table.getPtypeOf(num)));
    }
    else if (state.standMask(WHITE).test(num))
    {
      ret+=Ptype_Eval_Table.value(newPtypeO(WHITE,Piece_Table.getPtypeOf(num)));
    }
    else{
      assert(state.isOnBoard(num));
      Piece p=state.getPieceOf(num);
      ret+=Ptype_Eval_Table.value(p.ptypeO());
    }
  }
  val=ret;
}

osl::eval::PtypeEvalTable::PtypeEvalTable()
{ 
  init();
}
osl::eval::PtypeEvalTable::~PtypeEvalTable()
{ 
}

void osl::eval::PtypeEvalTable::init()
{
  ptypeO2Val[PTYPE_EMPTY-PTYPEO_MIN]=0;
  ptypeO2Val[PTYPE_EDGE-PTYPEO_MIN]=0;
  ptypeO2Val[PAWN-PTYPEO_MIN]=PtypeEvalTraits<PAWN>::val;
  ptypeO2Val[PPAWN-PTYPEO_MIN]=PtypeEvalTraits<PPAWN>::val;
  ptypeO2Val[LANCE-PTYPEO_MIN]=PtypeEvalTraits<LANCE>::val;
  ptypeO2Val[PLANCE-PTYPEO_MIN]=PtypeEvalTraits<PLANCE>::val;
  ptypeO2Val[KNIGHT-PTYPEO_MIN]=PtypeEvalTraits<KNIGHT>::val;
  ptypeO2Val[PKNIGHT-PTYPEO_MIN]=PtypeEvalTraits<PKNIGHT>::val;
  ptypeO2Val[SILVER-PTYPEO_MIN]=PtypeEvalTraits<SILVER>::val;
  ptypeO2Val[PSILVER-PTYPEO_MIN]=PtypeEvalTraits<PSILVER>::val;
  ptypeO2Val[GOLD-PTYPEO_MIN]=PtypeEvalTraits<GOLD>::val;
  ptypeO2Val[KING-PTYPEO_MIN]=PtypeEvalTraits<KING>::val;
  ptypeO2Val[BISHOP-PTYPEO_MIN]=PtypeEvalTraits<BISHOP>::val;
  ptypeO2Val[PBISHOP-PTYPEO_MIN]=PtypeEvalTraits<PBISHOP>::val;
  ptypeO2Val[ROOK-PTYPEO_MIN]=PtypeEvalTraits<ROOK>::val;
  ptypeO2Val[PROOK-PTYPEO_MIN]=PtypeEvalTraits<PROOK>::val;
  for(int i=PTYPE_MIN;i<=PTYPE_MAX;i++)
  {
    Ptype ptype=static_cast<Ptype>(i);
    ptypeO2Val[newPtypeO(WHITE,ptype)-PTYPEO_MIN]=
      -ptypeO2Val[newPtypeO(BLACK,ptype)-PTYPEO_MIN];
  }
  for(int i=PTYPEO_MIN;i<=PTYPEO_MAX;i++)
  {
    PtypeO ptypeO=static_cast<PtypeO>(i);
    PtypeO basicPtypeO=unpromote(ptypeO);
    // note: value() depends on ptypeO2Val
    promoteVal[i-PTYPEO_MIN]=Ptype_Eval_Table.value(ptypeO)-
      Ptype_Eval_Table.value(basicPtypeO);
  }
  // EMPTYのcapture
  captureVal[0]=0;
  for(int i=PTYPEO_MIN;i<=PTYPEO_MAX;i++)
  {
    PtypeO ptypeO=static_cast<PtypeO>(i);
    // note: value() depends on ptypeO2Val
    if(isPiece(ptypeO))
      captureVal[i-PTYPEO_MIN]=Ptype_Eval_Table.value(captured(ptypeO))-
	Ptype_Eval_Table.value(ptypeO);
    else
      captureVal[i-PTYPEO_MIN]=0;
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
