/* numEffectState.tcc
 */
#ifndef OSL_NUM_EFFECT_STATE_TCC
#define OSL_NUM_EFFECT_STATE_TCC

#include "osl/state/numEffectState.h"
#include "osl/effect/numSimpleEffect.tcc"
#include "osl/checkmate/king8Info.h"

template <osl::Player P>
bool osl::NumEffectState::
hasEffectByWithRemove(Position target,Position removed) const
{
  const Piece piece = getPieceAt(removed);
  if (! piece.isPiece()) 
    return hasEffectBy<P>(target);
  if (piece.owner() == P) 
  {
    if (hasEffectNotBy(P, piece, target))
      return true;
  }
  else 
  {
    if (hasEffectBy(P, target))
      return true;
  }
  if (! selectLong(removed, P).any())
    return false;
  const Direction d = Board_Table.getLongDirection<BLACK>(Offset32(target,removed));
  if (!isLong(d))
    return false;
  const int num=longEffectNumTable()[piece.number()][longToShort(d)];
  return (! Piece::isEmptyNum(num)
	  && getPieceOf(num).owner()==P);
}

#endif /* OSL_NUM_EFFECT_STATE_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
