#ifndef _OSL_RECORD_KANJI_CODE_H
#define _OSL_RECORD_KANJI_CODE_H

#include <string>

namespace osl
{
  namespace record
  {
    /**
     * Define Kanji characters by using EUC-JP codes.
     */
    const static std::string K_BLACK_SIGN  = "\xA2\xA5"; // ▲
    const static std::string K_WHITE_SIGN  = "\xA2\xA4"; // △
    const static std::string K_SPACE       = "\xA1\xA1"; // "　"
    const static std::string K_NAKAGURO    = "\xA1\xA6"; // ・
    const static std::string K_COLON       = "\xA1\xA7"; // ：
    const static std::string K_R1          = "\xA3\xB1"; // １
    const static std::string K_R2          = "\xA3\xB2"; // ２
    const static std::string K_R3          = "\xA3\xB3"; // ３
    const static std::string K_R4          = "\xA3\xB4"; // ４
    const static std::string K_R5          = "\xA3\xB5"; // ５
    const static std::string K_R6          = "\xA3\xB6"; // ６
    const static std::string K_R7          = "\xA3\xB7"; // ７
    const static std::string K_R8          = "\xA3\xB8"; // ８
    const static std::string K_R9          = "\xA3\xB9"; // ９
    const static std::string K_K1          = "\xB0\xEC"; // 一
    const static std::string K_K2          = "\xC6\xF3"; // 二
    const static std::string K_K3          = "\xBB\xB0"; // 三
    const static std::string K_K4          = "\xBB\xCD"; // 四
    const static std::string K_K5          = "\xB8\xDE"; // 五
    const static std::string K_K6          = "\xCF\xBB"; // 六
    const static std::string K_K7          = "\xBC\xB7"; // 七
    const static std::string K_K8          = "\xC8\xAC"; // 八
    const static std::string K_K9          = "\xB6\xE5"; // 九
    const static std::string K_MIGI        = "\xB1\xA6"; // 右
    const static std::string K_HIDARI      = "\xBA\xB8"; // 左
    const static std::string K_UE          = "\xBE\xE5"; // 上
    const static std::string K_SHITA       = "\xB2\xBC"; // 下
    const static std::string K_SUGU        = "\xC4\xBE"; // 直
    const static std::string K_YORU        = "\xB4\xF3"; // 寄
    const static std::string K_HIKU        = "\xB0\xFA"; // 引
    const static std::string K_YUKU        = "\xB9\xD4"; // 行
    const static std::string K_ONAZI       = "\xC6\xB1"; // 同
    const static std::string K_NARU        = "\xC0\xAE"; // 成
    const static std::string K_FUNARI      = "\xC9\xD4" + K_NARU; // 不成
    const static std::string K_UTSU        = "\xC2\xC7"; // 打
    // pieces
    const static std::string K_PAWN        = "\xCA\xE2"; // 歩
    const static std::string K_PAWN_R      = "\xA7\xAE"; // М
    const static std::string K_PPAWN       = "\xA4\xC8"; // と
    const static std::string K_PPAWN_R     = "\xA7\xAF"; // Н
    const static std::string K_LANCE       = "\xB9\xE1"; // 香
    const static std::string K_LANCE_R     = "\xA7\xAC"; // К
    const static std::string K_PLANCE      = "\xB0\xC9"; // 杏
    const static std::string K_PLANCE_R    = "\xA7\xAD"; // Л
    const static std::string K_PLANCE_D    = K_NARU + K_LANCE; // 成香
    const static std::string K_KNIGHT      = "\xB7\xCB"; // 桂
    const static std::string K_KNIGHT_R    = "\xA7\xAA"; // И
    const static std::string K_PKNIGHT     = "\xB7\xBD"; // 圭
    const static std::string K_PKNIGHT_R   = "\xA7\xAB"; // Й
    const static std::string K_PKNIGHT_D   = K_NARU + K_KNIGHT; // 成桂
    const static std::string K_SILVER      = "\xB6\xE4"; // 銀
    const static std::string K_SILVER_R    = "\xA7\xA8"; // Ж
    const static std::string K_PSILVER     = "\xC1\xB4"; // 全
    const static std::string K_PSILVER_R   = "\xA7\xA9"; // З
    const static std::string K_PSILVER_D   = K_NARU + K_SILVER; // 成銀
    const static std::string K_GOLD        = "\xB6\xE2"; // 金
    const static std::string K_GOLD_R      = "\xA7\xA7"; // Ё
    const static std::string K_BISHOP      = "\xB3\xD1"; // 角
    const static std::string K_BISHOP_R    = "\xA7\xA4"; // Г
    const static std::string K_PBISHOP     = "\xC7\xCF"; // 馬
    const static std::string K_PBISHOP_R   = "\xA7\xA5"; // Д
    const static std::string K_ROOK        = "\xC8\xF4"; // 飛
    const static std::string K_ROOK_R      = "\xA7\xA2"; // Б
    const static std::string K_PROOK       = "\xCE\xB6"; // 龍
    const static std::string K_PROOK2      = "\xCE\xB5"; // 竜
    const static std::string K_PROOK_R     = "\xA7\xA3"; // В
    const static std::string K_KING        = "\xB6\xCC"; // 玉
    const static std::string K_KING_R      = "\xA7\xA1"; // А
    //
    const static std::string K_BLACK       = "\xC0\xE8\xBC\xEA"; // 先手
    const static std::string K_WHITE       = "\xB8\xE5\xBC\xEA"; // 後手
    const static std::string K_BLACK_STAND = K_BLACK + "\xBB\xFD\xB6\xF0"; // 先手持駒
    const static std::string K_WHITE_STAND = K_WHITE + "\xBB\xFD\xB6\xF0"; // 後手持駒
    const static std::string K_TEAIWARI    = "\xBC\xEA\xB9\xE7\xB3\xE4"; // 手合割
    const static std::string K_PASS        = "\xA5\xD1\xA5\xB9"; // パス
    const static std::string K_SENKEI      = "\xC0\xEF\xB7\xBF";  // 戦型
    const static std::string K_TORYO       = "\xc5\xea\xce\xbb";  // 投了
    const static std::string K_HENKA       = "\xca\xd1\xb2\xbd"; // 変化
    const static std::string K_KISEN       = "\xb4\xfd\xc0\xef"; // 棋戦
    const static std::string K_KIFU        = "\xb4\xfd\xc9\xe8"; // 棋譜
    const static std::string K_TSUMERO     = "\xb5\xcd\xa4\xe1\xa4\xed"; // 詰めろ
  } // namespace record
} // namespace osl


#endif /* _OSL_RECORD_KANJI_CODE_H */
/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
