#ifndef _MOVE_GENERATOR_ATTACK_TO_PINNED_TCC
#define _MOVE_GENERATOR_ATTACK_TO_PINNED_TCC
#include "osl/move_generator/attackToPinned.h"
#include "osl/ptypeTable.h"
#include "osl/effectContent.h"
#include "osl/move_generator/addEffectWithEffect.h"
#include "osl/misc/loki.h"
using namespace osl;

namespace osl
{
  namespace move_generator
  {
    namespace {
      template<Player P,Ptype T,class Action>
      void generatePtype(const NumEffectState& state,Action& action)
      {
	Position target=state.template getKingPosition<PlayerTraits<P>::opponent>();
	for(int num=PtypeTraits<T>::indexMin;num<PtypeTraits<T>::indexLimit;num++){
	  Piece p=state.getPieceOf(num);
	  if(p.template isOnBoardByOwner<P>()){
	    Position from=p.position();
	    EffectContent effect=Ptype_Table.getEffect(newPtypeO(P,T),from,target);
	    if(effect.hasEffect()){
	      Offset offset=effect.offset();
	      assert(!offset.zero());
	      Piece p1;
	      Position pos=target-offset;
	      for(;(p1=state.getPieceAt(pos)).isEmpty();pos-=offset) ;
	      if(p1.canMoveOn<P>() &&
		 state.hasEffectByPiece(p,pos)){
		AddEffectWithEffect<Action>::template generate<P,false>(state,pos,action);
	      }
	    }
	  }
	}
      }
    }
    template<Player P>
    template<class Action>
    void AttackToPinned<P>::
    generate(const NumEffectState& state,Action& action)
    {
      generatePtype<P,ROOK,Action>(state,action);
      generatePtype<P,BISHOP,Action>(state,action);
      generatePtype<P,LANCE,Action>(state,action);
    }

  }
}

#endif /* _MOVE_GENERATOR_ATTACK_TO_PINNED_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
