#ifndef OSL_MOVE_GENERATER_ADD_EFFECT_WITH_EFFECT_H
#define OSL_MOVE_GENERATER_ADD_EFFECT_WITH_EFFECT_H
#include "osl/move_action/concept.h"
#include "osl/state/numEffectState.h"
#include "osl/move_action/store.h"
#include "osl/container/moveVector.h"
#include <boost/static_assert.hpp>

namespace osl
{
  namespace move_generator
  {
    /**
     * 利きをつける手を生成 利きを持つstateでしか使えない.
     * アルゴリズム:
     * \li 利きをつけたいマスから8近傍方向(長い利きも)，桂馬近傍の自分の利きをチェック
     * \li 自分の利きがあった時に，そこに移動したら問題のマスに利きをつけられる駒の種類かをチェックする
     * 特徴:
     * \li 相手玉の自由度が小さく，近傍に自分の利きがない時は高速に判定
     */
    template<class Action>
    class AddEffectWithEffect
    {
    public:
      template<Player P,bool isAttackToKing>
      static void generate(const NumEffectState& state,Position target,Action& action,bool& hasPawnCheckmate);
      template<Player P,bool isAttackToKing>
      static void generate(const NumEffectState& state,Position target,Action& action){
	bool dummy;
	generate<P,isAttackToKing>(state,target,action,dummy);
      }
    };
    struct GenerateAddEffectWithEffect
    {
      /**
       * 対象とするマスに利きを付ける手を生成する.
       * Note: Action がPlayerで型付けされていると，無駄があるのでStore限定に
       */
      template<bool isAttackToKing>
      static void generate(Player player, const NumEffectState& state, Position target, 
			   move_action::Store& store);
      template<bool isAttackToKing>
      static void generate(Player player,const NumEffectState& state,Position target,MoveVector& out, bool& has_pawn_checkmate) {
	move_action::Store store(out);
	if(player==BLACK)
	   AddEffectWithEffect<move_action::Store>::template generate<BLACK,isAttackToKing>(state,target,store,has_pawn_checkmate);
	else
	   AddEffectWithEffect<move_action::Store>::template generate<WHITE,isAttackToKing>(state,target,store,has_pawn_checkmate);
      }
      template<bool isAttackToKing>
      static void generate(Player player,const NumEffectState& state,Position target,MoveVector& out) {
	bool dummy;
	generate<isAttackToKing>(player,state,target,out,dummy);
      }
    };
  } // namespace move_generator
} // namespace osl
#endif /* OSL_MOVE_GENERATER_ADD_EFFECT_WITH_EFFECT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
