#ifndef _DIRECTION_H
#define _DIRECTION_H
#include <cassert>
#include <iosfwd>

namespace osl
{
  enum Direction{
    SHORT_DIRECTION_MIN=0,
    SHORT8_DIRECTION_MIN=0,
    UL=0,
    U=1,
    UR=2,
    L=3,
    R=4,
    DL=5,
    D=6,
    DR=7,
    SHORT8_DIRECTION_MAX=7,
    UUL=8,
    UUR=9,
    LONG_DIRECTION_MIN=10,
    LONG_UL=10,
    LONG_U=11,
    LONG_UR=12,
    LONG_L=13,
    LONG_R=14,
    LONG_DL=15,
    LONG_D=16,
    LONG_DR=17,
    LONG_DIRECTION_MAX=17,
    DIRECTION_MIN=0,
    SHORT_DIRECTION_MAX=9,
    SHORT_DIRECTION_SIZE=10,
    DIRECTION_MAX=17,
    DIRECTION_INVALID_VALUE=18,
    DIRECTION_SIZE=18
  };
  
  inline bool isShort(Direction d){
    return d<=SHORT_DIRECTION_MAX;
  }

  inline bool isShort8(Direction d){
    return d<=SHORT8_DIRECTION_MAX;
  }

  inline bool isLong(Direction d){
    return d>=LONG_DIRECTION_MIN;
  }

  inline Direction inverseUnsafe(Direction d){
    return static_cast<Direction>(7 - d);
  }

  inline Direction inverse(Direction d){
    assert(isShort8(d) );
    return inverseUnsafe(d);
  }

  /**
   * 8方向について，primitiveな4方向を求める
   */
  inline Direction primDir(Direction d){
    assert(isShort8(d) );
    if(d<4) return d;
    else return inverse(d);
  }
  /**
   * 8方向について，primitiveな4方向を求める
   * dとしてknight, INVALIDなども来る
   */
  inline Direction primDirUnsafe(Direction d){
    if(d<4) return d;
    else return inverseUnsafe(d);
  }

  bool isValid(Direction d);
  
  inline Direction longToShort(Direction d){
    assert(isLong(d));
    return static_cast<Direction>(static_cast<int>(d)-LONG_UL);
  }
  
  /**
   * 引数に longDirを与えてはいけない
   */
  inline Direction shortToLong(Direction d){
    assert(isShort(d));
    return static_cast<Direction>(static_cast<int>(d)+LONG_UL);
  }

  inline int dirToMask(Direction dir){
    return (1<<static_cast<int>(dir));
  }
  
  std::ostream& operator<<(std::ostream& os,const Direction d);
}
#endif /* _DIRECTION_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
