/* applyMoveWithPath.h
 */
#ifndef OSL_APPLYMOVEWITHPATH_H
#define OSL_APPLYMOVEWITHPATH_H

#include "osl/apply_move/applyMove.h"
#include "osl/pathEncoding.h"
namespace osl
{
  namespace apply_move
  {
    template<Player P>
    struct ApplyMoveWithPath
    {
      /**
       * doUndoMove の PathEncoding をメンテナンスするバージョン
       */
      template <class State, class Function>
      static 
      void doUndoMove(State& state, PathEncoding& path, Move move, Function& h)
      {
	assert(state.getTurn() == move.player());
	const PathEncoding old_path = path;
	path.pushMove(move);
	ApplyMove<P>::doUndoMove(state,move,h);
	path = old_path;
      }
      template <class State, class Function>
      static 
      void doUndoMoveOrPass(State& state, PathEncoding& path, Move move, Function& h)
      {
	assert(state.getTurn() == move.player());
	const PathEncoding old_path = path;
	path.pushMove(move);
	ApplyMove<P>::doUndoMoveOrPass(state,move,h);
	path = old_path;
      }
    };
  } // namespace apply_move
  using apply_move::ApplyMoveWithPath;
} // namespace osl


#endif /* OSL_APPLYMOVEWITHPATH_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
