/***************************************************************************
 $RCSfile: openhbci.h.in,v $
 -------------------
 cvs         : $Id: openhbci.h.in,v 1.28 2003/05/18 18:08:32 aquamaniac Exp $
 begin       : Fri Dec 07 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : martin@aquamaniac.de
***************************************************************************/


/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/** @file openhbci.h
 * @short Includes all OpenHBCI headers.
 */

#ifndef OPENHBCI_H
#define OPENHBCI_H

#define OPENHBCI_VERSION_MAJOR 0
#define OPENHBCI_VERSION_MINOR 9
#define OPENHBCI_VERSION_PATCHLEVEL 14
#define OPENHBCI_VERSION_BUILD 0
#define OPENHBCI_VERSION_STRING "0.9.14"
#define OPENHBCI_VERSION_FULL_STRING "0.9.14.0"
#define OPENHBCI_PLUGIN_INTERFACE_VERSION 14


/* STL */
#ifdef __cplusplus
#include <string>
#include <list>
#endif /* __cplusplus */

/* Helper classes for applications */
#include <openhbci/dllimport.h>
#ifdef __cplusplus
#include <openhbci/tree.h>
#include <openhbci/conf.h>
#include <openhbci/simpleconfig.h>
#include <openhbci/cmdlineoptions.h>
#include <openhbci/filestream.h>
#include <openhbci/parser.h>
#include <openhbci/stream.h>
#include <openhbci/directory.h>
#endif /* __cplusplus */

/* Core HBCI classes that aren't included through api.h */
#ifdef __cplusplus
# include <openhbci/hbcistring.h>
#endif /* __cplusplus */
#include <openhbci/mediumrdhbase.h>
#ifdef __cplusplus
#endif /* __cplusplus */

/* HBCI classes on wrapper layer */
/* Most stuff is included by api.h anyway */
#include <openhbci/api.h> 
#include <openhbci/outbox.h>
#include <openhbci/outboxjob.h>
#include <openhbci/outboxjobs.h>
#include <openhbci/outboxaccjobs.h>
#include <openhbci/outboxstojobs.h>
#include <openhbci/outboxjobkeys.h>

#endif
