MODULE VO:QuickHelpPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,
       Z   := VO:Base:Size,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PG  := VO:Prefs:GUI,
       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       Q   := VO:QuickHelp;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                frame : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="QuickHelp";
         
    d.frame:=V.CreateIntModel();
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo : FSD.FrmSelCombo;
    frame : FG.FrameGroup;

  BEGIN
    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Frame");

      combo:=FSD.CreateFrmSelCombo();
      combo.SetModel(d.frame);
    frame.SetObject(combo);

    RETURN frame;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.frame.SetLongint(Q.prefs.frame);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    Q.prefs.frame:=p.frame.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    F.LoadFrame("frame",top,Q.prefs.frame);
    Z.LoadSize("hOffset",top,Q.prefs.hOffset);
    Z.LoadSize("vOffset",top,Q.prefs.vOffset);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    block.AddItemValue("frame",F.internalFrames[Q.prefs.frame]);
    Z.SaveSize("hOffset",block,Q.prefs.hOffset);
    Z.SaveSize("vOffset",block,Q.prefs.vOffset);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:QuickHelpPrefs.