(**
    Demo for VisualOberon. Demonstrates the table object.
**)

MODULE TestTable;

(*
    Demo for VisualOberon. Demonstrates the table object.
    Copyright (C) 1998  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,
       F   := VO:Base:Frame,
       O   := VO:Base:Object,
       Z   := VO:Base:Size,

       TM  := VO:Model:Table,

              VO:Prefs:All,  (* Include preferences for all objects *)

       B   := VO:Button,
       C   := VO:ColorArea,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       P   := VO:Panel,
       PL  := VO:Plate,
       T   := VO:Table,
       TA  := VO:Tab,
       V   := VO:VecImage,
       W   := VO:Window,
       WG  := VO:WindowGroup,

              Err;

TYPE
  Window     = POINTER TO WindowDesc;
  WindowDesc = RECORD (W.WindowDesc)
                 insert,
                 delete  : B.Button;
                 model   : TM.LTableModel;
               END;

VAR
  w        : Window;
  msg2Exit : D.Msg2Exit;

  PROCEDURE (w : Window) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
        IF message.source=w.insert THEN
          w.model.AppendEntry();
          w.model.SetString(1,w.model.GetRows(),"Added");
        ELSIF message.source=w.delete THEN
          IF w.model.sy>0 THEN
            w.model.DeleteEntry(w.model.sy);
          END;
        END;
        RETURN;
    ELSE
      w.Receive^(message);
    END;
  END Receive;

  PROCEDURE (w : Window) PreInit*;

  VAR
    x        : LONGINT;
    plate    : PL.Plate;
    color    : C.ColorArea;
    frame    : FG.FrameGroup;
    image    : V.VecImage;
    tab      : TA.Tab;
    table    : T.Table;
    wGroup   : WG.WindowGroup;
    panel1,
    panel2   : P.Panel;

    model1   : TM.TestTable;
    model2   : TM.ASTableModel;
    model3,
    model4   : TM.LTableModel;

  BEGIN
    wGroup:=WG.CreateWindowGroup();

    tab:=TA.CreateTab();
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});
    w.AddFocusObject(tab);

    NEW(model1);
    model1.Init;
    model1.SetSelectionType(TM.cellSelect);

    table:=T.CreateTable();
    table.SetModel(model1);
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetMinWidth(Z.unit,50);
    table.SetMinHeight(Z.unit,50);
    table.SetShowHeader(FALSE);
    w.AddFocusObject(table.table);
    tab.AddStringTab("Cell selection",table);

    NEW(model2);
    model2.Init;
    model2.SetSize(5,2);
    model2.SetColumnString(1,"\ebTestcolumn\en\n\esone");
    model2.SetColumnString(2,"\ebTestcolumn\en\n\estwo");
    model2.SetColumnString(3,"\ebTestcolumn\en\n\esthree");
    model2.SetColumnString(4,"\ebTestcolumn\en\n\esfour");
    model2.SetColumnString(5,"\ebTestcolumn\en\n\esfive");
    model2.SetString(1,1,"(1,1)");
    model2.SetString(2,1,"(2,1)");
    model2.SetString(3,1,"(3,1)");
    model2.SetString(4,1,"(4,1)");
    model2.SetString(5,1,"(5,1)");
    model2.SetString(1,2,"(1,2)");
    model2.SetString(2,2,"(2,2)");
    model2.SetSelectionType(TM.singleLineSelect);

    table:=T.CreateTable();
    table.SetModel(model2);
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetMinWidth(Z.unit,50);
    table.SetMinHeight(Z.unit,50);
    table.SetShowHeader(TRUE);
    w.AddFocusObject(table.table);
  tab.AddStringTab("Header",table);

    NEW(model3);
    model3.Init;
    w.model:=model3;
    model3.SetSelectionType(TM.singleLineSelect);
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 1");
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 2");
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 3");
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 4");
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 5");
    model3.AppendEntry;
    model3.SetString(1,model3.GetRows(),"Entry 6");

    panel1:=P.CreateHPanel();
    panel1.SetFlags({G.horizontalFlex,G.verticalFlex});

    table:=T.CreateTable();
    table.SetModel(model3);
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetMinWidth(Z.unit,50);
    table.SetMinHeight(Z.unit,50);
    table.SetShowHeader(FALSE);
    w.AddFocusObject(table.table);

    panel1.Add(table);

    panel2:=P.CreateVPanel();
    panel2.SetFlags({G.verticalFlex});

      w.insert:=B.CreateButton();
      w.insert.SetFlags({G.horizontalFlex});
      w.insert.SetText("Insert");
      w.insert.Forward(B.pressedMsg,w);
    panel2.Add(w.insert);

      w.delete:=B.CreateButton();
      w.delete.SetFlags({G.horizontalFlex});
      w.delete.SetText("Delete");
      w.delete.Forward(B.pressedMsg,w);
    panel2.Add(w.delete);

    panel1.Add(panel2);

    tab.AddStringTab("Classic",panel1);

    NEW(model4);
    model4.Init;
    model4.SetSelectionType(TM.singleLineSelect);
    model4.SetColumnString(1,"Object");
    model4.SetColumnWidth(1,60);
    model4.SetColumnString(2,"Objectname");
    model4.SetColumnWidth(2,150);

    FOR x:=0 TO D.colorCount-1 DO
      plate:=PL.CreatePlate();
        color:=C.CreateColorArea();
        color.SetMinWidth(Z.unit,6);
        color.SetMinHeight(Z.unit,3);
        color.SetColor(D.GetColorByIndex(x));
      plate.Add(color);
      model4.AppendEntry;
      model4.SetObject(1,model4.GetRows(),plate);
      model4.SetString(2,model4.GetRows(),D.colorNames[x]);
    END;

    FOR x:=0 TO F.internalFrameCount-1 DO
      plate:=PL.CreatePlate();
        frame:=FG.CreateFrameGroup();
        frame.SetMinWidth(Z.unit,3);
        frame.SetMinHeight(Z.unit,3);
        frame.SetFrame(x);
      plate.Add(frame);
      model4.AppendEntry;
      model4.SetObject(1,model4.GetRows(),plate);
      model4.SetString(2,model4.GetRows(),F.internalFrames[x]);
    END;

    FOR x:=0 TO V.imageCount-1 DO
      plate:=PL.CreatePlate();
        image:=V.CreateVecImage();
        image.SetMinWidth(Z.unit,3);
        image.SetMinHeight(Z.unit,3);
        image.Set(x);
      plate.Add(image);
      model4.AppendEntry;
      model4.SetObject(1,model4.GetRows(),plate);
      model4.SetString(2,model4.GetRows(),V.images[x]);
    END;

    table:=T.CreateTable();
    table.SetModel(model4);
    table.table.SetRowHeight(40);
    table.SetFlags({G.horizontalFlex,G.verticalFlex});
    table.SetMinWidth(Z.unit,50);
    table.SetMinHeight(Z.unit,50);
    table.SetShowHeader(TRUE);
    w.AddFocusObject(table.table);
    tab.AddStringTab("Objects",table);

    wGroup.Set(NIL,tab,TRUE);

    w.SetTop(wGroup);

    w.PreInit^;
  END PreInit;

BEGIN
  D.display.SetAppName("TestTable");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(w);
  w.Init;
  w.SetTitle("Table");
  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  D.display.EventLoop;

  D.display.Close;
END TestTable.