# Web::Interface::Rinda
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'web/interface/basic'
require 'web/persistent/idgen/default'

module Web
  module Interface
    class Rinda < Basic
      EOL = "\r\n"
      def initialize(opt={})
        @name = opt[:name] || $0.sub(/\.[^.]+$/,'')
        @uri  = opt[:uri]
        require 'drb/drb'
        require 'drb/rinda'
        DRb.start_service()
        @ts = TupleSpaceProxy.new(DRbObject.new(nil, @uri))
      end
      
      def forward(req)
        @ts.out([@name, req])
        name, id, rsp = @ts.in([@name, req.request_id, nil])
        rsp
      end
      
      def each_forward(api)
        api.each {|req|
          rsp = forward(req)
          api.response req, rsp
        }
      end
      
      # W͂RequestgݗĂ
      def request(arg={})
        name, req = @ts.in([@name, nil])
        req
      end
      
      def response(req, rsp)
        @ts.out([@name, req.request_id, rsp])
      end # Rinda#response
      
    end # Rinda
  end # Interface
end # Web
