/*******************************************************************************
 * Copyright (c) 2003, 2006 svnClientAdapter project and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     svnClientAdapter project committers - initial API and implementation
 ******************************************************************************/
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import org.tigris.subversion.svnclientadapter.SVNClientException;

/**
 * A JavaHL base implementation of {@link org.tigris.subversion.svnclientadapter.ISVNClientAdapter}.
 *
 * @author C�dric Chabanois (cchabanois at no-log.org)
 * @author Panagiotis Korros (pkorros at bigfoot.com) 
 *
 */
public class JhlClientAdapter extends AbstractJhlClientAdapter {

    /**
     * tells if JhlClientAdapter is usable
     * @return true if Jhl client adapter is available
     * @deprecated
     */
    public static boolean isAvailable() {
       	return JhlClientAdapterFactory.isAvailable();
    }
    
    /**
     * @return an error string describing problems during loading platform native libraries (if any)
     * @deprecated
     */
    public static String getLibraryLoadErrors() {
    	return JhlClientAdapterFactory.getLibraryLoadErrors();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
