/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.iiop;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.management.NotificationFilter;
import javax.rmi.PortableRemoteObject;

import mx4j.tools.connector.rmi.RemoteNotificationFilterSupport;

/**
 * @version $Revision: 1.3 $
 */
public class IIOPRemoteNotificationFilterSupport extends RemoteNotificationFilterSupport
{
   public IIOPRemoteNotificationFilterSupport(NotificationFilter clientFilter)
   {
      super(clientFilter);
   }

   public void export() throws RemoteException
   {
      PortableRemoteObject.exportObject(getRemoteNotificationFilter());
   }

   public void unexport() throws NoSuchObjectException
   {
      PortableRemoteObject.unexportObject(getRemoteNotificationFilter());
   }
}
