/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector;

import javax.management.MBeanServerConnection;

/**
 * A restricted MBeanServer interface to be used by RMI clients. <p>
 * For now is exactly equal to MBeanServer, but
 * <ul>
 * <li> instantiate returns the MBean without registering it, has no sense remotely
 * <li> deserialize makes no sense used remotely and should be removed
 * </ul>
 * <p/>
 * This interface is simply a marker interface extended from MBeanServerConnection to identify
 * remote MBeanServer.
 *
 * @version $Revision: 1.3 $
 */
public interface RemoteMBeanServer extends MBeanServerConnection
{

}
