package Locales::DB::Language::th;

# Auto generated from CLDR

$Locales::DB::Language::th::VERSION = '0.09';

$Locales::DB::Language::th::cldr_version = '2.0';

%Locales::DB::Language::th::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "\{0\}",
        'list'     => {
            2        => "\{0\}และ\{1\}",
            'end'    => "\{0\}\ และ\{1\}",
            'middle' => "\{0\}\ \{1\}",
            'start'  => "\{0\}\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "\{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => [ 'other' ],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => 'ไม่ใช่',
        'yesstr' => 'ใช่'
    },
);

%Locales::DB::Language::th::code_to_name = (
    'aa'    => 'อะฟาร์',
    'ab'    => 'อับคาซ',
    'ace'   => 'อาเจะห์',
    'ach'   => 'อาโคลิ',
    'ada'   => 'อาแดงมี',
    'ady'   => 'อะดืยเก',
    'ae'    => 'อเวสตะ',
    'af'    => 'แอฟริกานส์',
    'afa'   => "ภาษาแอฟโร\-เอเชียติก",
    'afh'   => 'แอฟริฮีลี',
    'agq'   => 'Aghem',
    'ain'   => 'ไอนุ',
    'ak'    => 'อาคัน',
    'akk'   => 'อักกาด',
    'ale'   => 'อาลิวต์',
    'alg'   => 'ภาษาอัลกองเควียน',
    'alt'   => 'อัลไตใต้',
    'am'    => 'อัมฮารา',
    'an'    => 'อารากอน',
    'ang'   => 'อังกฤษโบราณ',
    'anp'   => 'อังคิกา',
    'apa'   => 'ภาษาอาปาเช่',
    'ar'    => 'อาหรับ',
    'arc'   => 'อราเมอิก',
    'arn'   => 'อาเราคาเนียน',
    'arp'   => 'อาราปาโฮ',
    'art'   => 'ภาษาประดิษฐ์',
    'arw'   => 'อาราวัก',
    'as'    => 'อัสสัม',
    'asa'   => 'Asu',
    'ast'   => 'อัสตูเรียส',
    'ath'   => 'ภาษาอาทาพาสกาน',
    'aus'   => 'ภาษาออสเตรเลีย',
    'av'    => 'อาวาร์',
    'awa'   => 'อวธี',
    'ay'    => 'ไอย์มารา',
    'az'    => 'อะเซอรี',
    'ba'    => 'บัชคีร์',
    'bad'   => 'บันดา',
    'bai'   => 'ภาษาบามีเลก์',
    'bal'   => 'บาลูชิ',
    'ban'   => 'บาหลี',
    'bas'   => 'บาสา',
    'bat'   => 'ภาษาบอลติก',
    'be'    => 'เบลารุส',
    'bej'   => 'เบจา',
    'bem'   => 'เบมบา',
    'ber'   => 'เบอร์เบอร์',
    'bez'   => 'Bena',
    'bg'    => 'บัลแกเรีย',
    'bh'    => 'พิหาร',
    'bho'   => 'โภชปุรี',
    'bi'    => 'บิสลามา',
    'bik'   => 'บิกอล',
    'bin'   => 'บินี',
    'bla'   => 'สิกสิกา',
    'bm'    => 'บัมบารา',
    'bn'    => 'เบงกาลี',
    'bnt'   => 'บันตู',
    'bo'    => 'ทิเบต',
    'br'    => 'เบรตัน',
    'bra'   => 'พัรช',
    'brx'   => 'Bodo',
    'bs'    => 'บอสเนีย',
    'btk'   => 'บาตัก',
    'bua'   => 'บูเรียต',
    'bug'   => 'บูกิส',
    'byn'   => 'บลิน',
    'ca'    => 'กาตาลัง',
    'cad'   => 'คัดโด',
    'cai'   => 'ภาษาอเมริกันอินเดียนกลาง',
    'car'   => 'คาริบ',
    'cau'   => 'ภาษาคอเคเซียน',
    'cay'   => 'Cayuga',
    'cch'   => 'แอตแซม',
    'ce'    => 'เชเชน',
    'ceb'   => 'เซบู',
    'cel'   => 'ภาษาเซลติก',
    'cgg'   => 'Chiga',
    'ch'    => 'ชามอร์โร',
    'chb'   => 'ชิบชา',
    'chg'   => 'ชะกะไต',
    'chk'   => 'ชูก',
    'chm'   => 'มารี',
    'chn'   => 'ชินุกจาร์กอน',
    'cho'   => 'ช็อกทอว์',
    'chp'   => 'ชิพิวยัน',
    'chr'   => 'เชอโรกี',
    'chy'   => 'เชเยนเน',
    'cmc'   => 'ภาษาชามิก',
    'co'    => 'คอร์ซิกา',
    'cop'   => 'คอปติก',
    'cpe'   => 'ครีโอลหรือพิดจิ้นที่มาจากภาษาอังกฤษ',
    'cpf'   => 'ครีโอลหรือพิดจิ้นที่มาจากภาษาฝรั่งเศส',
    'cpp'   => 'ครีโอลหรือพิดจิ้นที่มาจากภาษาโปรตุเกส',
    'cr'    => 'ครี',
    'crh'   => 'ตุรกีไครเมีย',
    'crp'   => 'ครีโอลหรือพิดจิ้น',
    'cs'    => 'เช็ก',
    'csb'   => 'คาซูเบียน',
    'cu'    => 'เชอร์ชสลาวิก',
    'cus'   => 'ภาษาคูชิทิก',
    'cv'    => 'ชูวัช',
    'cy'    => 'เวลส์',
    'da'    => 'เดนมาร์ก',
    'dak'   => 'ดาโกทา',
    'dar'   => 'ดาร์กิน',
    'dav'   => 'Taita',
    'day'   => 'ดายัก',
    'de'    => 'เยอรมัน',
    'de_at' => "เยอรมัน\ \-\ ออสเตรีย",
    'de_ch' => "เยอรมันสูง\ \(สวิส\)",
    'del'   => 'เดลาแวร์',
    'den'   => 'สเลวี',
    'dgr'   => 'โดกริบ',
    'din'   => 'ดิงกา',
    'dje'   => 'Zarma',
    'doi'   => 'โฑครี',
    'dra'   => 'ภาษาดราวิเดียน',
    'dsb'   => 'ซอร์บส์ตอนล่าง',
    'dua'   => 'ดัวลา',
    'dum'   => 'ดัตช์กลาง',
    'dv'    => 'ธิเวหิ',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'ดิวลา',
    'dz'    => 'ซองคา',
    'ebu'   => 'Embu',
    'ee'    => 'เอเว',
    'efi'   => 'อีฟิก',
    'egy'   => 'อียิปต์โบราณ',
    'eka'   => 'อีกาจุก',
    'el'    => 'กรีก',
    'elx'   => 'อีลาไมต์',
    'en'    => 'อังกฤษ',
    'en_au' => "อังกฤษ\ \-\ ออสเตรเลีย",
    'en_ca' => "อังกฤษ\ \-\ แคนาดา",
    'en_gb' => "อังกฤษ\ \-\ สหราชอาณาจักร",
    'en_us' => "อังกฤษ\ \-\ อเมริกัน",
    'enm'   => 'อังกฤษกลาง',
    'eo'    => 'เอสเปอรันโต',
    'es'    => 'สเปน',
    'es_es' => "สเปน\ \(ไอบีเรีย\)",
    'et'    => 'เอสโตเนีย',
    'eu'    => 'บัสเก',
    'ewo'   => 'อีวันโด',
    'fa'    => 'เปอร์เซีย',
    'fan'   => 'ฟอง',
    'fat'   => 'ฟันติ',
    'ff'    => 'ฟูลาฮ์',
    'fi'    => 'ฟินแลนด์',
    'fil'   => 'ฟิลิปปินส์',
    'fiu'   => "ภาษาฟินโน\-อูกริก",
    'fj'    => 'ฟิจิ',
    'fo'    => 'แฟโร',
    'fon'   => 'ฟอน',
    'fr'    => 'ฝรั่งเศส',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "ฝรั่งเศส\ \(สวิส\)",
    'frm'   => 'ฝรั่งเศสกลาง',
    'fro'   => 'ฝรั่งเศสโบราณ',
    'frr'   => 'ฟริเซียนเหนือ',
    'frs'   => 'ฟริเซียนตะวันออก',
    'fur'   => 'ฟรูลี',
    'fy'    => 'ฟริเซียนตะวันตก',
    'ga'    => 'ไอริช',
    'gaa'   => 'กา',
    'gay'   => 'กาโย',
    'gba'   => 'กบายา',
    'gd'    => 'สกอตส์กาลิก',
    'gem'   => 'ภาษาเจอร์เมนิก',
    'gez'   => 'กีซ',
    'gil'   => 'กิลเบอร์ต',
    'gl'    => 'กาลิเซีย',
    'gmh'   => 'เยอรมันสูงกลาง',
    'gn'    => 'กวารานี',
    'goh'   => 'เยอรมันสูงโบราณ',
    'gon'   => 'กอนดิ',
    'gor'   => 'กอรอนทาโล',
    'got'   => 'โกธิก',
    'grb'   => 'เกรโบ',
    'grc'   => 'กรีกโบราณ',
    'gsw'   => 'เยอรมันสวิส',
    'gu'    => 'คุชราต',
    'guz'   => 'Gusii',
    'gv'    => 'มานซ์',
    'gwi'   => 'กวิชอิน',
    'ha'    => 'เฮาชา',
    'hai'   => 'ไฮดา',
    'haw'   => 'ฮาวาย',
    'he'    => 'ฮิบรู',
    'hi'    => 'ฮินดี',
    'hil'   => 'ฮีลีกัยนน',
    'him'   => 'หิมาจัล',
    'hit'   => 'ฮิตไตต์',
    'hmn'   => 'ม้ง',
    'ho'    => 'ฮีรีโมตู',
    'hr'    => 'โครเอเชีย',
    'hsb'   => 'ซอร์บส์ตอนบน',
    'ht'    => 'เฮติ',
    'hu'    => 'ฮังการี',
    'hup'   => 'ฮูปา',
    'hy'    => 'อาร์เมเนีย',
    'hz'    => 'เฮเรโร',
    'ia'    => 'อินเตอร์ลิงกัว',
    'iba'   => 'อิบาน',
    'id'    => 'อินโดนีเชีย',
    'ie'    => 'อินเตอร์ลิงกิว',
    'ig'    => 'อิกโบ',
    'ii'    => 'เสฉวนยิ',
    'ijo'   => 'อิโจ',
    'ik'    => 'อีนูเปียก',
    'ilo'   => 'อีโลโก',
    'inc'   => 'ภาษาอินดิก',
    'ine'   => "ภาษาอินโด\-ยุโรป",
    'inh'   => 'อินกุช',
    'io'    => 'อีโด',
    'ira'   => 'ภาษาอิหร่าน',
    'iro'   => 'ภาษาอีโรกัวส์',
    'is'    => 'ไอซ์แลนด์',
    'it'    => 'อิตาลี',
    'iu'    => 'อินุกติตุต',
    'ja'    => 'ญี่ปุ่น',
    'jbo'   => 'โลชบัน',
    'jmc'   => 'Machame',
    'jpr'   => "ยิว\-เปอร์เซีย",
    'jrb'   => "ยิว\-อาหรับ",
    'jv'    => 'ชวา',
    'ka'    => 'จอร์เจีย',
    'kaa'   => "การา\-กาลพาก",
    'kab'   => 'กาไบล',
    'kac'   => 'กะฉิ่น',
    'kaj'   => 'คจู',
    'kam'   => 'คัมบา',
    'kar'   => 'กะเหรี่ยง',
    'kaw'   => 'กวี',
    'kbd'   => 'คาร์บาเดีย',
    'kcg'   => 'ทีแยป',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'โคโร',
    'kg'    => 'คองโก',
    'kha'   => 'กาสี',
    'khi'   => 'ภาษาคอยซาน',
    'kho'   => 'โคตัน',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'กีกูยู',
    'kj'    => 'กวนยามา',
    'kk'    => 'คาซัค',
    'kl'    => 'กรีนแลนด์',
    'kln'   => 'Kalenjin',
    'km'    => 'เขมร',
    'kmb'   => 'คิมบุนดู',
    'kn'    => 'กันนาดา',
    'ko'    => 'เกาหลี',
    'kok'   => 'กอนกานี',
    'kos'   => 'คูสไร',
    'kpe'   => 'กาแปล',
    'kr'    => 'คานูรี',
    'krc'   => "คาราไช\-บัลคาร์",
    'krl'   => 'แกรเลียน',
    'kro'   => 'ครู',
    'kru'   => 'กุรุข',
    'ks'    => 'กัศมีร์',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'เคิร์ด',
    'kum'   => 'คูมืยค์',
    'kut'   => 'คูเทไน',
    'kv'    => 'โกมิ',
    'kw'    => 'คอร์นิช',
    'ky'    => 'คีร์กีซ',
    'la'    => 'ละติน',
    'lad'   => 'ลาดิโน',
    'lag'   => 'Langi',
    'lah'   => 'ลาฮ์นดา',
    'lam'   => 'แลมบา',
    'lb'    => 'ลักเซมเบิร์ก',
    'lez'   => 'เลซเกียน',
    'lg'    => 'ยูกันดา',
    'li'    => 'ลิมเบิร์ก',
    'ln'    => 'ลิงกาลา',
    'lo'    => 'ลาว',
    'lol'   => 'มองโก',
    'loz'   => 'โลซิ',
    'lt'    => 'ลิทัวเนีย',
    'lu'    => "ลูบา\-กาตองกา",
    'lua'   => "ลูบา\-ลูลัว",
    'lui'   => 'ลุยเซโน',
    'lun'   => 'ลันดา',
    'luo'   => 'ลัว',
    'lus'   => 'ลูไช',
    'luy'   => 'Luyia',
    'lv'    => 'ลัตเวีย',
    'mad'   => 'มาดูรา',
    'mag'   => 'มคหี',
    'mai'   => 'ไมถิลี',
    'mak'   => 'มากาซาร์',
    'man'   => 'มันดิงกา',
    'map'   => 'ออสโตรนีเซียน',
    'mas'   => 'มาไซ',
    'mdf'   => 'มอคชา',
    'mdr'   => 'มานดาร์',
    'men'   => 'เมนเด',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'มาลากาซี',
    'mga'   => 'ไอริชกลาง',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'มาร์แชลลิส',
    'mi'    => 'เมารี',
    'mic'   => 'มิกแมก',
    'min'   => 'มีนังกาเบา',
    'mis'   => 'ภาษาอื่นๆ',
    'mk'    => 'มาซิโดเนีย',
    'mkh'   => "ภาษามอญ\-เขมร",
    'ml'    => 'มาลายาลัม',
    'mn'    => 'มองโกเลีย',
    'mnc'   => 'แมนจู',
    'mni'   => 'มณีปุระ',
    'mno'   => 'ภาษามาโนโบ',
    'mo'    => 'มอลโดวา',
    'moh'   => 'โมฮอว์ก',
    'mos'   => 'โมซี',
    'mr'    => 'มราฐี',
    'ms'    => 'มาเลย์',
    'mt'    => 'มอลตา',
    'mua'   => 'Mundang',
    'mul'   => 'หลายภาษา',
    'mun'   => 'ภาษามันดา',
    'mus'   => 'ครีก',
    'mwl'   => 'มีรันดา',
    'mwr'   => 'มารวาฑี',
    'my'    => 'พม่า',
    'myn'   => 'ภาษามายา',
    'myv'   => 'เอียร์ซยา',
    'na'    => 'นาอูรู',
    'nah'   => 'นาฮัว',
    'nai'   => 'ภาษาอินเดียอเมริกาเหนือ',
    'nap'   => 'นาโปลี',
    'naq'   => 'Nama',
    'nb'    => 'นอร์เวย์บุคมอล',
    'nd'    => 'เอ็นเดเบเลเหนือ',
    'nds'   => "เยอรมันต่ำ\ \-\ แซกซอนต่ำ",
    'ne'    => 'เนปาล',
    'new'   => 'เนวาร์',
    'ng'    => 'ดองกา',
    'nia'   => 'นีอัส',
    'nic'   => "ภาษาไนเจอร์\-คอร์โดฟาเนียน",
    'niu'   => 'นีอู',
    'nl'    => 'ดัตช์',
    'nl_be' => 'เฟลมิช',
    'nmg'   => 'Kwasio',
    'nn'    => 'นอร์เวย์นีนอสก์',
    'no'    => 'นอร์เวย์',
    'nog'   => 'โนไก',
    'non'   => 'นอร์สโบราณ',
    'nqo'   => 'เอ็นโก',
    'nr'    => 'เอ็นเดเบเลใต้',
    'nso'   => 'โซโทเหนือ',
    'nub'   => 'ภาษานูเบียน',
    'nus'   => 'Nuer',
    'nv'    => 'นาวาโฮ',
    'nwc'   => 'เนวาร์ดั้งเดิม',
    'ny'    => 'เนียนจา',
    'nym'   => 'เนียมเวซี',
    'nyn'   => 'เนียนโกเล',
    'nyo'   => 'นิโอโร',
    'nzi'   => 'นซิมา',
    'oc'    => 'อ็อกซิตัน',
    'oj'    => 'โอจิบวา',
    'om'    => 'โอโรโม',
    'or'    => 'โอริยา',
    'os'    => 'ออสเซเตีย',
    'osa'   => 'โอซากี',
    'ota'   => 'ตุรกีออตโตมัน',
    'oto'   => 'ภาษาโอโตมี',
    'pa'    => 'ปัญจาบ',
    'paa'   => 'ภาษาปาปัว',
    'pag'   => 'ปางาซีนัน',
    'pal'   => 'ปะห์ลาวี',
    'pam'   => 'ปัมปางา',
    'pap'   => 'ปาเปียเมนโต',
    'pau'   => 'ปาเลา',
    'peo'   => 'เปอร์เซียโบราณ',
    'phi'   => 'ภาษาฟิลิปปิน',
    'phn'   => 'ฟินิเชีย',
    'pi'    => 'บาลี',
    'pl'    => 'โปแลนด์',
    'pon'   => 'พอห์นเพ',
    'pra'   => 'ภาษาปรากฤต',
    'pro'   => 'โปรวองซาลโบราณ',
    'ps'    => 'พุชโต',
    'pt'    => 'โปรตุเกส',
    'pt_br' => "โปรตุเกส\ \-\ บราซิล",
    'pt_pt' => "โปรตุเกส\ \-\ ไอบีเรีย",
    'qu'    => 'ควิชัว',
    'raj'   => 'ราชสถาน',
    'rap'   => 'ราปานู',
    'rar'   => 'ราโรทองกา',
    'rm'    => "เรโต\-โรแมนซ์",
    'rn'    => 'บุรุนดี',
    'ro'    => 'โรมาเนีย',
    'roa'   => 'ภาษาโรมานซ์',
    'rof'   => 'Rombo',
    'rom'   => 'โรมานี',
    'ru'    => 'รัสเซีย',
    'rup'   => 'อาโรมาเนียน',
    'rw'    => 'รวันดา',
    'rwk'   => 'Rwa',
    'sa'    => 'สันสกฤต',
    'sad'   => 'ซันดาเว',
    'sah'   => 'ยาคุต',
    'sai'   => 'ภาษาอเมริกันอินเดียนใต้',
    'sal'   => 'ภาษาชาลิช',
    'sam'   => 'อราเมอิกซามาเรีย',
    'saq'   => 'Samburu',
    'sas'   => 'ซาซัก',
    'sat'   => 'สันตาลี',
    'sbp'   => 'Sangu',
    'sc'    => 'ซาร์เดญา',
    'scn'   => 'ซิซิลี',
    'sco'   => 'สกอตส์',
    'sd'    => 'สินธุ',
    'se'    => 'ซามิเหนือ',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'เซลคุป',
    'sem'   => 'ภาษาเซมิติก',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'แซงโก',
    'sga'   => 'ไอริชโบราณ',
    'sgn'   => 'ภาษาสัญญาณ',
    'sh'    => "เซอร์โบ\-โครเอเชีย",
    'shi'   => 'Tachelhit',
    'shn'   => 'ไทใหญ่',
    'si'    => 'สิงหล',
    'sid'   => 'ซิดาโม',
    'sio'   => 'ภาษาซิอวน',
    'sit'   => "ภาษาซิโน\-ทิเบต",
    'sk'    => 'สโลวัก',
    'sl'    => 'สโลวีเนีย',
    'sla'   => 'ภาษาสลาวิก',
    'sm'    => 'ซามัว',
    'sma'   => 'ซามิใต้',
    'smi'   => 'ภาษาซามิ',
    'smj'   => 'ซามิลูเล',
    'smn'   => 'ซามิอีนารี',
    'sms'   => 'ซามิสคอลต์',
    'sn'    => 'โชนา',
    'snk'   => 'โซนีนเก',
    'so'    => 'โซมาลี',
    'sog'   => 'ซอกดีน',
    'son'   => 'ซองไฮ',
    'sq'    => 'แอลเบเนีย',
    'sr'    => 'เซอร์เบีย',
    'srn'   => 'ซูรินาเม',
    'srr'   => 'เซแรร์',
    'ss'    => 'สวาติ',
    'ssa'   => "ภาษานิโล\-ซาฮารัน",
    'ssy'   => 'Saho',
    'st'    => 'โซโทใต้',
    'su'    => 'ซุนดา',
    'suk'   => 'ซูคูมา',
    'sus'   => 'ซูซู',
    'sux'   => 'ซูเมอ',
    'sv'    => 'สวีเดน',
    'sw'    => 'สวาฮีลี',
    'swb'   => 'โคเมอเรียน',
    'swc'   => "Congo\ Swahili",
    'syc'   => 'ซีเรียแบบดั้งเดิม',
    'syr'   => 'ซีเรีย',
    'ta'    => 'ทมิฬ',
    'tai'   => 'ภาษาไท',
    'te'    => 'เตลูกู',
    'tem'   => 'ทิมเน',
    'teo'   => 'Teso',
    'ter'   => 'เทเรโน',
    'tet'   => 'เตตุม',
    'tg'    => 'ทาจิก',
    'th'    => 'ไทย',
    'ti'    => 'ติกริญญา',
    'tig'   => 'ตีเกร',
    'tiv'   => 'ทิฟ',
    'tk'    => 'เติร์กเมนิสถาน',
    'tkl'   => 'โตเกเลา',
    'tl'    => 'ตากาล็อก',
    'tlh'   => 'คลิงกอน',
    'tli'   => 'ทลิงกิต',
    'tmh'   => 'ทามาเชก',
    'tn'    => 'บอตสวานา',
    'to'    => 'ตองกา',
    'tog'   => 'ไนอะซาตองกา',
    'tpi'   => 'ท็อกพิซิน',
    'tr'    => 'ตุรกี',
    'trv'   => 'Taroko',
    'ts'    => 'ซิิตซองกา',
    'tsi'   => 'ซิมชีแอน',
    'tt'    => 'ตาตาร์',
    'tum'   => 'ทุมบูกา',
    'tup'   => 'ภาษาตูปี',
    'tut'   => 'ภาษาอัลตาอิก',
    'tvl'   => 'ตูวาลู',
    'tw'    => 'ทวิ',
    'twq'   => 'Tasawaq',
    'ty'    => 'ตาฮิตี',
    'tyv'   => 'ตูวา',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'อุดมูร์ต',
    'ug'    => 'อุยกูร์',
    'uga'   => 'ยูการิต',
    'uk'    => 'ยูเครน',
    'umb'   => 'อุมบุนดู',
    'und'   => 'ไม่มีข้อมูล',
    'ur'    => 'อูรดู',
    'uz'    => 'อุซเบก',
    'vai'   => 'ไว',
    've'    => 'เวนดา',
    'vi'    => 'เวียดนาม',
    'vo'    => 'โวลาพึค',
    'vot'   => 'โวทิก',
    'vun'   => 'Vunjo',
    'wa'    => 'วาโลนี',
    'wae'   => 'Walser',
    'wak'   => 'ภาษาวากาชาน',
    'wal'   => 'วาลาโม',
    'war'   => 'วาเรย์',
    'was'   => 'วาโช',
    'wen'   => 'ภาษาซอร์บส์',
    'wo'    => 'โวลอฟ',
    'xal'   => 'คัลมืยค์',
    'xh'    => 'คะห์โอซา',
    'xog'   => 'Soga',
    'yao'   => 'เย้า',
    'yap'   => 'ยัป',
    'yav'   => 'Yangben',
    'yi'    => 'ยิว',
    'yo'    => 'โยรูบา',
    'ypk'   => 'ภาษาอูย์ปิค',
    'yue'   => 'กวางตุ้ง',
    'za'    => 'จ้วง',
    'zap'   => 'ซาโปเตก',
    'zbl'   => 'บลิสซิมโบลส์',
    'zen'   => 'เซนากา',
    'zh'    => 'จีน',
    'znd'   => 'ซันเด',
    'zu'    => 'ซูลู',
    'zun'   => 'ซูนิ',
    'zxx'   => 'ไม่มีข้อมูลภาษา',
    'zza'   => 'ซาซา',
);

%Locales::DB::Language::th::name_to_code = (
    'aghem'                                                                                                           => 'agq',
    'asu'                                                                                                             => 'asa',
    'bafia'                                                                                                           => 'ksf',
    'bena'                                                                                                            => 'bez',
    'bodo'                                                                                                            => 'brx',
    'canadianfrench'                                                                                                  => 'fr_ca',
    'cayuga'                                                                                                          => 'cay',
    'centralmoroccotamazight'                                                                                         => 'tzm',
    'chiga'                                                                                                           => 'cgg',
    'colognian'                                                                                                       => 'ksh',
    'congoswahili'                                                                                                    => 'swc',
    'embu'                                                                                                            => 'ebu',
    'gusii'                                                                                                           => 'guz',
    'jolafonyi'                                                                                                       => 'dyo',
    'kabuverdianu'                                                                                                    => 'kea',
    'kalenjin'                                                                                                        => 'kln',
    'koyraborosenni'                                                                                                  => 'ses',
    'koyrachiini'                                                                                                     => 'khq',
    'kwasio'                                                                                                          => 'nmg',
    'langi'                                                                                                           => 'lag',
    'luyia'                                                                                                           => 'luy',
    'machame'                                                                                                         => 'jmc',
    'makhuwameetto'                                                                                                   => 'mgh',
    'makonde'                                                                                                         => 'kde',
    'meru'                                                                                                            => 'mer',
    'morisyen'                                                                                                        => 'mfe',
    'mundang'                                                                                                         => 'mua',
    'nama'                                                                                                            => 'naq',
    'nuer'                                                                                                            => 'nus',
    'rombo'                                                                                                           => 'rof',
    'rwa'                                                                                                             => 'rwk',
    'saho'                                                                                                            => 'ssy',
    'samburu'                                                                                                         => 'saq',
    'sangu'                                                                                                           => 'sbp',
    'sena'                                                                                                            => 'seh',
    'seneca'                                                                                                          => 'see',
    'shambala'                                                                                                        => 'ksb',
    'soga'                                                                                                            => 'xog',
    'tachelhit'                                                                                                       => 'shi',
    'taita'                                                                                                           => 'dav',
    'taroko'                                                                                                          => 'trv',
    'tasawaq'                                                                                                         => 'twq',
    'teso'                                                                                                            => 'teo',
    'vunjo'                                                                                                           => 'vun',
    'walser'                                                                                                          => 'wae',
    'yangben'                                                                                                         => 'yav',
    'zarma'                                                                                                           => 'dje',
    'กบายา'                                                                                                 => 'gba',
    'กรีก'                                                                                                    => 'el',
    'กรีกโบราณ'                                                                                     => 'grc',
    'กรีนแลนด์'                                                                                     => 'kl',
    'กวนยามา'                                                                                           => 'kj',
    'กวางตุ้ง'                                                                                        => 'yue',
    'กวารานี'                                                                                           => 'gn',
    'กวิชอิน'                                                                                           => 'gwi',
    'กวี'                                                                                                       => 'kaw',
    'กอนกานี'                                                                                           => 'kok',
    'กอนดิ'                                                                                                 => 'gon',
    'กอรอนทาโล'                                                                                     => 'gor',
    'กะฉิ่น'                                                                                              => 'kac',
    'กะเหรี่ยง'                                                                                     => 'kar',
    'กันนาดา'                                                                                           => 'kn',
    'กัศมีร์'                                                                                           => 'ks',
    'กา'                                                                                                          => 'gaa',
    'กาตาลัง'                                                                                           => 'ca',
    'การากาลพาก'                                                                                  => 'kaa',
    'กาลิเซีย'                                                                                        => 'gl',
    'กาสี'                                                                                                    => 'kha',
    'กาแปล'                                                                                                 => 'kpe',
    'กาโย'                                                                                                    => 'gay',
    'กาไบล'                                                                                                 => 'kab',
    'กิลเบอร์ต'                                                                                     => 'gil',
    'กีกูยู'                                                                                              => 'ki',
    'กีซ'                                                                                                       => 'gez',
    'กุรุข'                                                                                                 => 'kru',
    'คจู'                                                                                                       => 'kaj',
    'ครี'                                                                                                       => 'cr',
    'ครีก'                                                                                                    => 'mus',
    'ครีโอลหรือพิดจิ้น'                                                             => 'crp',
    'ครีโอลหรือพิดจิ้นที่มาจากภาษาฝรั่งเศส' => 'cpf',
    'ครีโอลหรือพิดจิ้นที่มาจากภาษาอังกฤษ'       => 'cpe',
    'ครีโอลหรือพิดจิ้นที่มาจากภาษาโปรตุเกส' => 'cpp',
    'ครู'                                                                                                       => 'kro',
    'คลิงกอน'                                                                                           => 'tlh',
    'ควิชัว'                                                                                              => 'qu',
    'คองโก'                                                                                                 => 'kg',
    'คอปติก'                                                                                              => 'cop',
    'คอร์ซิกา'                                                                                        => 'co',
    'คอร์นิช'                                                                                           => 'kw',
    'คะห์โอซา'                                                                                        => 'xh',
    'คัดโด'                                                                                                 => 'cad',
    'คัมบา'                                                                                                 => 'kam',
    'คัลมืยค์'                                                                                        => 'xal',
    'คาซัค'                                                                                                 => 'kk',
    'คาซูเบียน'                                                                                     => 'csb',
    'คานูรี'                                                                                              => 'kr',
    'คาราไชบัลคาร์'                                                                         => 'krc',
    'คาริบ'                                                                                                 => 'car',
    'คาร์บาเดีย'                                                                                  => 'kbd',
    'คิมบุนดู'                                                                                        => 'kmb',
    'คีร์กีซ'                                                                                           => 'ky',
    'คุชราต'                                                                                              => 'gu',
    'คูมืยค์'                                                                                           => 'kum',
    'คูสไร'                                                                                                 => 'kos',
    'คูเทไน'                                                                                              => 'kut',
    'จอร์เจีย'                                                                                        => 'ka',
    'จีน'                                                                                                       => 'zh',
    'จ้วง'                                                                                                    => 'za',
    'ชวา'                                                                                                       => 'jv',
    'ชะกะไต'                                                                                              => 'chg',
    'ชามอร์โร'                                                                                        => 'ch',
    'ชินุกจาร์กอน'                                                                            => 'chn',
    'ชิบชา'                                                                                                 => 'chb',
    'ชิพิวยัน'                                                                                        => 'chp',
    'ชูก'                                                                                                       => 'chk',
    'ชูวัช'                                                                                                 => 'cv',
    'ช็อกทอว์'                                                                                        => 'cho',
    'ซอกดีน'                                                                                              => 'sog',
    'ซองคา'                                                                                                 => 'dz',
    'ซองไฮ'                                                                                                 => 'son',
    'ซอร์บส์ตอนบน'                                                                            => 'hsb',
    'ซอร์บส์ตอนล่าง'                                                                      => 'dsb',
    'ซันดาเว'                                                                                           => 'sad',
    'ซันเด'                                                                                                 => 'znd',
    'ซาซัก'                                                                                                 => 'sas',
    'ซาซา'                                                                                                    => 'zza',
    'ซามัว'                                                                                                 => 'sm',
    'ซามิลูเล'                                                                                        => 'smj',
    'ซามิสคอลต์'                                                                                  => 'sms',
    'ซามิอีนารี'                                                                                  => 'smn',
    'ซามิเหนือ'                                                                                     => 'se',
    'ซามิใต้'                                                                                           => 'sma',
    'ซาร์เดญา'                                                                                        => 'sc',
    'ซาโปเตก'                                                                                           => 'zap',
    'ซิซิลี'                                                                                              => 'scn',
    'ซิดาโม'                                                                                              => 'sid',
    'ซิมชีแอน'                                                                                        => 'tsi',
    'ซิิตซองกา'                                                                                     => 'ts',
    'ซีเรีย'                                                                                              => 'syr',
    'ซีเรียแบบดั้งเดิม'                                                             => 'syc',
    'ซุนดา'                                                                                                 => 'su',
    'ซูคูมา'                                                                                              => 'suk',
    'ซูซู'                                                                                                    => 'sus',
    'ซูนิ'                                                                                                    => 'zun',
    'ซูรินาเม'                                                                                        => 'srn',
    'ซูลู'                                                                                                    => 'zu',
    'ซูเมอ'                                                                                                 => 'sux',
    'ญี่ปุ่น'                                                                                           => 'ja',
    'ดองกา'                                                                                                 => 'ng',
    'ดัตช์'                                                                                                 => 'nl',
    'ดัตช์กลาง'                                                                                     => 'dum',
    'ดัวลา'                                                                                                 => 'dua',
    'ดายัก'                                                                                                 => 'day',
    'ดาร์กิน'                                                                                           => 'dar',
    'ดาโกทา'                                                                                              => 'dak',
    'ดิงกา'                                                                                                 => 'din',
    'ดิวลา'                                                                                                 => 'dyu',
    'ตองกา'                                                                                                 => 'to',
    'ตากาล็อก'                                                                                        => 'tl',
    'ตาตาร์'                                                                                              => 'tt',
    'ตาฮิตี'                                                                                              => 'ty',
    'ติกริญญา'                                                                                        => 'ti',
    'ตีเกร'                                                                                                 => 'tig',
    'ตุรกี'                                                                                                 => 'tr',
    'ตุรกีออตโตมัน'                                                                         => 'ota',
    'ตุรกีไครเมีย'                                                                            => 'crh',
    'ตูวา'                                                                                                    => 'tyv',
    'ตูวาลู'                                                                                              => 'tvl',
    'ทมิฬ'                                                                                                    => 'ta',
    'ทลิงกิต'                                                                                           => 'tli',
    'ทวิ'                                                                                                       => 'tw',
    'ทาจิก'                                                                                                 => 'tg',
    'ทามาเชก'                                                                                           => 'tmh',
    'ทิฟ'                                                                                                       => 'tiv',
    'ทิมเน'                                                                                                 => 'tem',
    'ทิเบต'                                                                                                 => 'bo',
    'ทีแยป'                                                                                                 => 'kcg',
    'ทุมบูกา'                                                                                           => 'tum',
    'ท็อกพิซิน'                                                                                     => 'tpi',
    'ธิเวหิ'                                                                                              => 'dv',
    'นซิมา'                                                                                                 => 'nzi',
    'นอร์สโบราณ'                                                                                  => 'non',
    'นอร์เวย์'                                                                                        => 'no',
    'นอร์เวย์นีนอสก์'                                                                   => 'nn',
    'นอร์เวย์บุคมอล'                                                                      => 'nb',
    'นาวาโฮ'                                                                                              => 'nv',
    'นาอูรู'                                                                                              => 'na',
    'นาฮัว'                                                                                                 => 'nah',
    'นาโปลี'                                                                                              => 'nap',
    'นิโอโร'                                                                                              => 'nyo',
    'นีอัส'                                                                                                 => 'nia',
    'นีอู'                                                                                                    => 'niu',
    'บลิน'                                                                                                    => 'byn',
    'บลิสซิมโบลส์'                                                                            => 'zbl',
    'บอตสวานา'                                                                                        => 'tn',
    'บอสเนีย'                                                                                           => 'bs',
    'บัชคีร์'                                                                                           => 'ba',
    'บันดา'                                                                                                 => 'bad',
    'บันตู'                                                                                                 => 'bnt',
    'บัมบารา'                                                                                           => 'bm',
    'บัลแกเรีย'                                                                                     => 'bg',
    'บัสเก'                                                                                                 => 'eu',
    'บาตัก'                                                                                                 => 'btk',
    'บาลี'                                                                                                    => 'pi',
    'บาลูชิ'                                                                                              => 'bal',
    'บาสา'                                                                                                    => 'bas',
    'บาหลี'                                                                                                 => 'ban',
    'บิกอล'                                                                                                 => 'bik',
    'บินี'                                                                                                    => 'bin',
    'บิสลามา'                                                                                           => 'bi',
    'บุรุนดี'                                                                                           => 'rn',
    'บูกิส'                                                                                                 => 'bug',
    'บูเรียต'                                                                                           => 'bua',
    'ปะห์ลาวี'                                                                                        => 'pal',
    'ปัญจาบ'                                                                                              => 'pa',
    'ปัมปางา'                                                                                           => 'pam',
    'ปางาซีนัน'                                                                                     => 'pag',
    'ปาเปียเมนโต'                                                                               => 'pap',
    'ปาเลา'                                                                                                 => 'pau',
    'ฝรั่งเศส'                                                                                        => 'fr',
    'ฝรั่งเศสกลาง'                                                                            => 'frm',
    'ฝรั่งเศสสวิส'                                                                            => 'fr_ch',
    'ฝรั่งเศสโบราณ'                                                                         => 'fro',
    'พม่า'                                                                                                    => 'my',
    'พอห์นเพ'                                                                                           => 'pon',
    'พัรช'                                                                                                    => 'bra',
    'พิหาร'                                                                                                 => 'bh',
    'พุชโต'                                                                                                 => 'ps',
    'ฟริเซียนตะวันตก'                                                                   => 'fy',
    'ฟริเซียนตะวันออก'                                                                => 'frs',
    'ฟริเซียนเหนือ'                                                                         => 'frr',
    'ฟรูลี'                                                                                                 => 'fur',
    'ฟอง'                                                                                                       => 'fan',
    'ฟอน'                                                                                                       => 'fon',
    'ฟันติ'                                                                                                 => 'fat',
    'ฟิจิ'                                                                                                    => 'fj',
    'ฟินิเชีย'                                                                                        => 'phn',
    'ฟินแลนด์'                                                                                        => 'fi',
    'ฟิลิปปินส์'                                                                                  => 'fil',
    'ฟูลาฮ์'                                                                                              => 'ff',
    'ภาษาคอยซาน'                                                                                  => 'khi',
    'ภาษาคอเคเซียน'                                                                         => 'cau',
    'ภาษาคูชิทิก'                                                                               => 'cus',
    'ภาษาชามิก'                                                                                     => 'cmc',
    'ภาษาชาลิช'                                                                                     => 'sal',
    'ภาษาซอร์บส์'                                                                               => 'wen',
    'ภาษาซามิ'                                                                                        => 'smi',
    'ภาษาซิอวน'                                                                                     => 'sio',
    'ภาษาซิโนทิเบต'                                                                         => 'sit',
    'ภาษาดราวิเดียน'                                                                      => 'dra',
    'ภาษาตูปี'                                                                                        => 'tup',
    'ภาษานิโลซาฮารัน'                                                                   => 'ssa',
    'ภาษานูเบียน'                                                                               => 'nub',
    'ภาษาบอลติก'                                                                                  => 'bat',
    'ภาษาบามีเลก์'                                                                            => 'bai',
    'ภาษาประดิษฐ์'                                                                            => 'art',
    'ภาษาปรากฤต'                                                                                  => 'pra',
    'ภาษาปาปัว'                                                                                     => 'paa',
    'ภาษาฟินโนอูกริก'                                                                   => 'fiu',
    'ภาษาฟิลิปปิน'                                                                            => 'phi',
    'ภาษามอญเขมร'                                                                               => 'mkh',
    'ภาษามันดา'                                                                                     => 'mun',
    'ภาษามายา'                                                                                        => 'myn',
    'ภาษามาโนโบ'                                                                                  => 'mno',
    'ภาษาวากาชาน'                                                                               => 'wak',
    'ภาษาสลาวิก'                                                                                  => 'sla',
    'ภาษาสัญญาณ'                                                                                  => 'sgn',
    'ภาษาออสเตรเลีย'                                                                      => 'aus',
    'ภาษาอัลกองเควียน'                                                                => 'alg',
    'ภาษาอัลตาอิก'                                                                            => 'tut',
    'ภาษาอาทาพาสกาน'                                                                      => 'ath',
    'ภาษาอาปาเช่'                                                                               => 'apa',
    'ภาษาอินดิก'                                                                                  => 'inc',
    'ภาษาอินเดียอเมริกาเหนือ'                                           => 'nai',
    'ภาษาอินโดยุโรป'                                                                      => 'ine',
    'ภาษาอิหร่าน'                                                                               => 'ira',
    'ภาษาอีโรกัวส์'                                                                         => 'iro',
    'ภาษาอื่นๆ'                                                                                     => 'mis',
    'ภาษาอูย์ปิค'                                                                               => 'ypk',
    'ภาษาอเมริกันอินเดียนกลาง'                                        => 'cai',
    'ภาษาอเมริกันอินเดียนใต้'                                           => 'sai',
    'ภาษาเจอร์เมนิก'                                                                      => 'gem',
    'ภาษาเซมิติก'                                                                               => 'sem',
    'ภาษาเซลติก'                                                                                  => 'cel',
    'ภาษาแอฟโรเอเชียติก'                                                          => 'afa',
    'ภาษาโรมานซ์'                                                                               => 'roa',
    'ภาษาโอโตมี'                                                                                  => 'oto',
    'ภาษาไท'                                                                                              => 'tai',
    'ภาษาไนเจอร์คอร์โดฟาเนียน'                                        => 'nic',
    'มคหี'                                                                                                    => 'mag',
    'มณีปุระ'                                                                                           => 'mni',
    'มราฐี'                                                                                                 => 'mr',
    'มอคชา'                                                                                                 => 'mdf',
    'มองโก'                                                                                                 => 'lol',
    'มองโกเลีย'                                                                                     => 'mn',
    'มอลตา'                                                                                                 => 'mt',
    'มอลโดวา'                                                                                           => 'mo',
    'มันดิงกา'                                                                                        => 'man',
    'มากาซาร์'                                                                                        => 'mak',
    'มาซิโดเนีย'                                                                                  => 'mk',
    'มาดูรา'                                                                                              => 'mad',
    'มานซ์'                                                                                                 => 'gv',
    'มานดาร์'                                                                                           => 'mdr',
    'มารวาฑี'                                                                                           => 'mwr',
    'มารี'                                                                                                    => 'chm',
    'มาร์แชลลิส'                                                                                  => 'mh',
    'มาลากาซี'                                                                                        => 'mg',
    'มาลายาลัม'                                                                                     => 'ml',
    'มาเลย์'                                                                                              => 'ms',
    'มาไซ'                                                                                                    => 'mas',
    'มิกแมก'                                                                                              => 'mic',
    'มีนังกาเบา'                                                                                  => 'min',
    'มีรันดา'                                                                                           => 'mwl',
    'ม้ง'                                                                                                       => 'hmn',
    'ยัป'                                                                                                       => 'yap',
    'ยาคุต'                                                                                                 => 'sah',
    'ยิว'                                                                                                       => 'yi',
    'ยิวอาหรับ'                                                                                     => 'jrb',
    'ยิวเปอร์เซีย'                                                                            => 'jpr',
    'ยูกันดา'                                                                                           => 'lg',
    'ยูการิต'                                                                                           => 'uga',
    'ยูเครน'                                                                                              => 'uk',
    'รวันดา'                                                                                              => 'rw',
    'รัสเซีย'                                                                                           => 'ru',
    'ราชสถาน'                                                                                           => 'raj',
    'ราปานู'                                                                                              => 'rap',
    'ราโรทองกา'                                                                                     => 'rar',
    'ละติน'                                                                                                 => 'la',
    'ลักเซมเบิร์ก'                                                                            => 'lb',
    'ลัตเวีย'                                                                                           => 'lv',
    'ลันดา'                                                                                                 => 'lun',
    'ลัว'                                                                                                       => 'luo',
    'ลาดิโน'                                                                                              => 'lad',
    'ลาว'                                                                                                       => 'lo',
    'ลาฮ์นดา'                                                                                           => 'lah',
    'ลิงกาลา'                                                                                           => 'ln',
    'ลิทัวเนีย'                                                                                     => 'lt',
    'ลิมเบิร์ก'                                                                                     => 'li',
    'ลุยเซโน'                                                                                           => 'lui',
    'ลูบากาตองกา'                                                                               => 'lu',
    'ลูบาลูลัว'                                                                                     => 'lua',
    'ลูไช'                                                                                                    => 'lus',
    'วาลาโม'                                                                                              => 'wal',
    'วาเรย์'                                                                                              => 'war',
    'วาโช'                                                                                                    => 'was',
    'วาโลนี'                                                                                              => 'wa',
    'สกอตส์'                                                                                              => 'sco',
    'สกอตส์กาลิก'                                                                               => 'gd',
    'สวาติ'                                                                                                 => 'ss',
    'สวาฮีลี'                                                                                           => 'sw',
    'สวีเดน'                                                                                              => 'sv',
    'สันตาลี'                                                                                           => 'sat',
    'สันสกฤต'                                                                                           => 'sa',
    'สิกสิกา'                                                                                           => 'bla',
    'สิงหล'                                                                                                 => 'si',
    'สินธุ'                                                                                                 => 'sd',
    'สเปน'                                                                                                    => 'es',
    'สเปนไอบีเรีย'                                                                            => 'es_es',
    'สเลวี'                                                                                                 => 'den',
    'สโลวัก'                                                                                              => 'sk',
    'สโลวีเนีย'                                                                                     => 'sl',
    'หลายภาษา'                                                                                        => 'mul',
    'หิมาจัล'                                                                                           => 'him',
    'อราเมอิก'                                                                                        => 'arc',
    'อราเมอิกซามาเรีย'                                                                => 'sam',
    'อวธี'                                                                                                    => 'awa',
    'ออสเซเตีย'                                                                                     => 'os',
    'ออสโตรนีเซียน'                                                                         => 'map',
    'อะดืยเก'                                                                                           => 'ady',
    'อะฟาร์'                                                                                              => 'aa',
    'อะเซอรี'                                                                                           => 'az',
    'อักกาด'                                                                                              => 'akk',
    'อังกฤษ'                                                                                              => 'en',
    'อังกฤษกลาง'                                                                                  => 'enm',
    'อังกฤษสหราชอาณาจักร'                                                       => 'en_gb',
    'อังกฤษออสเตรเลีย'                                                                => 'en_au',
    'อังกฤษอเมริกัน'                                                                      => 'en_us',
    'อังกฤษแคนาดา'                                                                            => 'en_ca',
    'อังกฤษโบราณ'                                                                               => 'ang',
    'อังคิกา'                                                                                           => 'anp',
    'อับคาซ'                                                                                              => 'ab',
    'อัมฮารา'                                                                                           => 'am',
    'อัลไตใต้'                                                                                        => 'alt',
    'อัสตูเรียส'                                                                                  => 'ast',
    'อัสสัม'                                                                                              => 'as',
    'อาคัน'                                                                                                 => 'ak',
    'อารากอน'                                                                                           => 'an',
    'อาราปาโฮ'                                                                                        => 'arp',
    'อาราวัก'                                                                                           => 'arw',
    'อาร์เมเนีย'                                                                                  => 'hy',
    'อาลิวต์'                                                                                           => 'ale',
    'อาวาร์'                                                                                              => 'av',
    'อาหรับ'                                                                                              => 'ar',
    'อาเจะห์'                                                                                           => 'ace',
    'อาเราคาเนียน'                                                                            => 'arn',
    'อาแดงมี'                                                                                           => 'ada',
    'อาโคลิ'                                                                                              => 'ach',
    'อาโรมาเนียน'                                                                               => 'rup',
    'อิกโบ'                                                                                                 => 'ig',
    'อิตาลี'                                                                                              => 'it',
    'อินกุช'                                                                                              => 'inh',
    'อินุกติตุต'                                                                                  => 'iu',
    'อินเตอร์ลิงกัว'                                                                      => 'ia',
    'อินเตอร์ลิงกิว'                                                                      => 'ie',
    'อินโดนีเชีย'                                                                               => 'id',
    'อิบาน'                                                                                                 => 'iba',
    'อิโจ'                                                                                                    => 'ijo',
    'อีกาจุก'                                                                                           => 'eka',
    'อีนูเปียก'                                                                                     => 'ik',
    'อีฟิก'                                                                                                 => 'efi',
    'อียิปต์โบราณ'                                                                            => 'egy',
    'อีลาไมต์'                                                                                        => 'elx',
    'อีวันโด'                                                                                           => 'ewo',
    'อีโด'                                                                                                    => 'io',
    'อีโลโก'                                                                                              => 'ilo',
    'อุซเบก'                                                                                              => 'uz',
    'อุดมูร์ต'                                                                                        => 'udm',
    'อุมบุนดู'                                                                                        => 'umb',
    'อุยกูร์'                                                                                           => 'ug',
    'อูรดู'                                                                                                 => 'ur',
    'อเวสตะ'                                                                                              => 'ae',
    'อ็อกซิตัน'                                                                                     => 'oc',
    'ฮังการี'                                                                                           => 'hu',
    'ฮาวาย'                                                                                                 => 'haw',
    'ฮิตไตต์'                                                                                           => 'hit',
    'ฮินดี'                                                                                                 => 'hi',
    'ฮิบรู'                                                                                                 => 'he',
    'ฮีรีโมตู'                                                                                        => 'ho',
    'ฮีลีกัยนน'                                                                                     => 'hil',
    'ฮูปา'                                                                                                    => 'hup',
    'เกรโบ'                                                                                                 => 'grb',
    'เกาหลี'                                                                                              => 'ko',
    'เขมร'                                                                                                    => 'km',
    'เคิร์ด'                                                                                              => 'ku',
    'เชอร์ชสลาวิก'                                                                            => 'cu',
    'เชอโรกี'                                                                                           => 'chr',
    'เชเชน'                                                                                                 => 'ce',
    'เชเยนเน'                                                                                           => 'chy',
    'เช็ก'                                                                                                    => 'cs',
    'เซนากา'                                                                                              => 'zen',
    'เซบู'                                                                                                    => 'ceb',
    'เซลคุป'                                                                                              => 'sel',
    'เซอร์เบีย'                                                                                     => 'sr',
    'เซอร์โบโครเอเชีย'                                                                => 'sh',
    'เซแรร์'                                                                                              => 'srr',
    'เดนมาร์ก'                                                                                        => 'da',
    'เดลาแวร์'                                                                                        => 'del',
    'เตตุม'                                                                                                 => 'tet',
    'เตลูกู'                                                                                              => 'te',
    'เติร์กเมนิสถาน'                                                                      => 'tk',
    'เทเรโน'                                                                                              => 'ter',
    'เนปาล'                                                                                                 => 'ne',
    'เนวาร์'                                                                                              => 'new',
    'เนวาร์ดั้งเดิม'                                                                      => 'nwc',
    'เนียนจา'                                                                                           => 'ny',
    'เนียนโกเล'                                                                                     => 'nyn',
    'เนียมเวซี'                                                                                     => 'nym',
    'เบงกาลี'                                                                                           => 'bn',
    'เบจา'                                                                                                    => 'bej',
    'เบมบา'                                                                                                 => 'bem',
    'เบรตัน'                                                                                              => 'br',
    'เบลารุส'                                                                                           => 'be',
    'เบอร์เบอร์'                                                                                  => 'ber',
    'เปอร์เซีย'                                                                                     => 'fa',
    'เปอร์เซียโบราณ'                                                                      => 'peo',
    'เฟลมิช'                                                                                              => 'nl_be',
    'เมนเด'                                                                                                 => 'men',
    'เมารี'                                                                                                 => 'mi',
    'เยอรมัน'                                                                                           => 'de',
    'เยอรมันต่ำแซกซอนต่ำ'                                                       => 'nds',
    'เยอรมันสวิส'                                                                               => 'gsw',
    'เยอรมันสูงกลาง'                                                                      => 'gmh',
    'เยอรมันสูงสวิส'                                                                      => 'de_ch',
    'เยอรมันสูงโบราณ'                                                                   => 'goh',
    'เยอรมันออสเตรีย'                                                                   => 'de_at',
    'เย้า'                                                                                                    => 'yao',
    'เรโตโรแมนซ์'                                                                               => 'rm',
    'เลซเกียน'                                                                                        => 'lez',
    'เวนดา'                                                                                                 => 've',
    'เวลส์'                                                                                                 => 'cy',
    'เวียดนาม'                                                                                        => 'vi',
    'เสฉวนยิ'                                                                                           => 'ii',
    'เอสเปอรันโต'                                                                               => 'eo',
    'เอสโตเนีย'                                                                                     => 'et',
    'เอียร์ซยา'                                                                                     => 'myv',
    'เอเว'                                                                                                    => 'ee',
    'เอ็นเดเบเลเหนือ'                                                                   => 'nd',
    'เอ็นเดเบเลใต้'                                                                         => 'nr',
    'เอ็นโก'                                                                                              => 'nqo',
    'เฮติ'                                                                                                    => 'ht',
    'เฮาชา'                                                                                                 => 'ha',
    'เฮเรโร'                                                                                              => 'hz',
    'แกรเลียน'                                                                                        => 'krl',
    'แซงโก'                                                                                                 => 'sg',
    'แฟโร'                                                                                                    => 'fo',
    'แมนจู'                                                                                                 => 'mnc',
    'แลมบา'                                                                                                 => 'lam',
    'แอตแซม'                                                                                              => 'cch',
    'แอฟริกานส์'                                                                                  => 'af',
    'แอฟริฮีลี'                                                                                     => 'afh',
    'แอลเบเนีย'                                                                                     => 'sq',
    'โกธิก'                                                                                                 => 'got',
    'โกมิ'                                                                                                    => 'kv',
    'โคตัน'                                                                                                 => 'kho',
    'โครเอเชีย'                                                                                     => 'hr',
    'โคเมอเรียน'                                                                                  => 'swb',
    'โคโร'                                                                                                    => 'kfo',
    'โชนา'                                                                                                    => 'sn',
    'โซนีนเก'                                                                                           => 'snk',
    'โซมาลี'                                                                                              => 'so',
    'โซโทเหนือ'                                                                                     => 'nso',
    'โซโทใต้'                                                                                           => 'st',
    'โฑครี'                                                                                                 => 'doi',
    'โดกริบ'                                                                                              => 'dgr',
    'โตเกเลา'                                                                                           => 'tkl',
    'โนไก'                                                                                                    => 'nog',
    'โปรตุเกส'                                                                                        => 'pt',
    'โปรตุเกสบราซิล'                                                                      => 'pt_br',
    'โปรตุเกสไอบีเรีย'                                                                => 'pt_pt',
    'โปรวองซาลโบราณ'                                                                      => 'pro',
    'โปแลนด์'                                                                                           => 'pl',
    'โภชปุรี'                                                                                           => 'bho',
    'โมซี'                                                                                                    => 'mos',
    'โมฮอว์ก'                                                                                           => 'moh',
    'โยรูบา'                                                                                              => 'yo',
    'โรมานี'                                                                                              => 'rom',
    'โรมาเนีย'                                                                                        => 'ro',
    'โลชบัน'                                                                                              => 'jbo',
    'โลซิ'                                                                                                    => 'loz',
    'โวทิก'                                                                                                 => 'vot',
    'โวลอฟ'                                                                                                 => 'wo',
    'โวลาพึค'                                                                                           => 'vo',
    'โอจิบวา'                                                                                           => 'oj',
    'โอซากี'                                                                                              => 'osa',
    'โอริยา'                                                                                              => 'or',
    'โอโรโม'                                                                                              => 'om',
    'ไทย'                                                                                                       => 'th',
    'ไทใหญ่'                                                                                              => 'shn',
    'ไนอะซาตองกา'                                                                               => 'tog',
    'ไมถิลี'                                                                                              => 'mai',
    'ไม่มีข้อมูล'                                                                               => 'und',
    'ไม่มีข้อมูลภาษา'                                                                   => 'zxx',
    'ไว'                                                                                                          => 'vai',
    'ไอซ์แลนด์'                                                                                     => 'is',
    'ไอนุ'                                                                                                    => 'ain',
    'ไอย์มารา'                                                                                        => 'ay',
    'ไอริช'                                                                                                 => 'ga',
    'ไอริชกลาง'                                                                                     => 'mga',
    'ไอริชโบราณ'                                                                                  => 'sga',
    'ไฮดา'                                                                                                    => 'hai',
);

1;
