/*
 * Copyright (C) 2012  Christian Mollekopf <mollekopf@kolabsys.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "errorhandler.h"

#include <qdebug.h>

#include <kolab/kolabformat.h>

namespace Kolab {
    
void logMessage(const QString &message, const QString &file, int line, ErrorHandler::Severity s)
{
    ErrorHandler::instance().addError(s, message, file+" "+QString::number(line));
}


void ErrorHandler::addError(ErrorHandler::Severity s, const QString& message, const QString &location)
{
    if (s == Debug) {
        qDebug() << location << ": " << message;
        return;
    } else {
        qWarning() << location << ": " << message;
    }
    if (s > m_worstError) {
        m_worstError = s;
    }
    m_errorQueue.append(Err(s, message, location));
}

ErrorHandler::Severity ErrorHandler::error() const
{
    return m_worstError;
}

const QList< ErrorHandler::Err >& ErrorHandler::getErrors() const
{
    return m_errorQueue;
}

void ErrorHandler::clear()
{
    m_errorQueue.clear();
    m_worstError = Debug;
}

void ErrorHandler::handleLibkolabxmlErrors()
{
    switch (Kolab::error()) {
        case Kolab::Warning:
            instance().addError(ErrorHandler::Warning, QString::fromStdString(Kolab::errorMessage()), "libkolabxml");
            break;
        case Kolab::Error:
            instance().addError(ErrorHandler::Error, QString::fromStdString(Kolab::errorMessage()), "libkolabxml");
            break;
        case Kolab::Critical:
            instance().addError(ErrorHandler::Critical, QString::fromStdString(Kolab::errorMessage()), "libkolabxml");
            break;
        default:
            //Do nothing, there is no message available in this case
            break;
    }
}


}
