/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class WebKit
extends WebBrowser {
    int webView;
    int webViewData;
    int scrolledWindow;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    static int ExternalClass;
    static int PostString;
    static boolean LibraryLoaded;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String ENCODING_FORM = "Content-Type: application/x-www-form-urlencoded";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        MIN_VERSION = nArray;
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {}
        if ((clazz8 = class$0) == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Proc2 = new Callback(clazz8, "Proc", 2)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz7 = class$0) == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Proc3 = new Callback(clazz7, "Proc", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz6 = class$0) == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Proc4 = new Callback(clazz6, "Proc", 4)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz5 = class$0) == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Proc5 = new Callback(clazz5, "Proc", 5)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz4 = class$0) == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Proc6 = new Callback(clazz4, "Proc", 6)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz3 = class$0) == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((JSObjectHasPropertyProc = new Callback(clazz3, "JSObjectHasPropertyProc", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((JSObjectGetPropertyProc = new Callback(clazz2, "JSObjectGetPropertyProc", 4)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((JSObjectCallAsFunctionProc = new Callback(clazz, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0) {
            SWT.error(3);
        }
        NativeClearSessions = new Runnable(){

            public void run() {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    return;
                }
                int cookies = WebKitGTK.soup_cookie_jar_all_cookies(jar);
                int length = OS.g_slist_length(cookies);
                int current = cookies;
                int i = 0;
                while (i < length) {
                    int cookie = OS.g_slist_data(current);
                    int expires = WebKitGTK.SoupCookie_expires(cookie);
                    if (expires == 0) {
                        WebKitGTK.soup_cookie_jar_delete_cookie(jar, cookie);
                    }
                    OS.g_free(cookie);
                    current = OS.g_slist_next(current);
                    ++i;
                }
            }
        };
        NativeGetCookie = new Runnable(){

            public void run() {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    return;
                }
                byte[] bytes = Converter.wcsToMbcs(null, CookieUrl, true);
                int uri = WebKitGTK.soup_uri_new(bytes);
                if (uri == 0) {
                    return;
                }
                int cookies = WebKitGTK.soup_cookie_jar_get_cookies(jar, uri, 0);
                WebKitGTK.soup_uri_free(uri);
                if (cookies == 0) {
                    return;
                }
                int length = OS.strlen(cookies);
                bytes = new byte[length];
                C.memmove(bytes, cookies, length);
                OS.g_free(cookies);
                String allCookies = new String(Converter.mbcsToWcs(null, bytes));
                StringTokenizer tokenizer = new StringTokenizer(allCookies, ";");
                while (tokenizer.hasMoreTokens()) {
                    String name;
                    String cookie = tokenizer.nextToken();
                    int index = cookie.indexOf(61);
                    if (index == -1 || !(name = cookie.substring(0, index).trim()).equals(CookieName)) continue;
                    CookieValue = cookie.substring(index + 1).trim();
                    return;
                }
            }
        };
        NativeSetCookie = new Runnable(){

            public void run() {
                int type;
                if (!LibraryLoaded) {
                    return;
                }
                int session = WebKitGTK.webkit_get_default_session();
                int jar = WebKitGTK.soup_session_get_feature(session, type = WebKitGTK.soup_cookie_jar_get_type());
                if (jar == 0) {
                    WebKitGTK.soup_session_add_feature_by_type(session, type);
                    jar = WebKitGTK.soup_session_get_feature(session, type);
                }
                if (jar == 0) {
                    return;
                }
                byte[] bytes = Converter.wcsToMbcs(null, CookieUrl, true);
                int uri = WebKitGTK.soup_uri_new(bytes);
                if (uri == 0) {
                    return;
                }
                bytes = Converter.wcsToMbcs(null, CookieValue, true);
                int cookie = WebKitGTK.soup_cookie_parse(bytes, uri);
                if (cookie != 0) {
                    WebKitGTK.soup_cookie_jar_add_cookie(jar, cookie);
                    CookieResult = true;
                }
                WebKitGTK.soup_uri_free(uri);
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
            NativePendingCookies = null;
        }
    }

    static Browser findBrowser(int webView) {
        if (webView == 0) {
            return null;
        }
        int parent = OS.gtk_widget_get_parent(webView);
        parent = OS.gtk_widget_get_parent(parent);
        return (Browser)Display.getCurrent().findWidget(parent);
    }

    static int JSObjectCallAsFunctionProc(int ctx, int function, int thisObject, int argumentCount, int arguments, int exception) {
        if (WebKitGTK.JSValueIsObjectOfClass(ctx, thisObject, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(ctx);
        }
        int ptr = WebKitGTK.JSObjectGetPrivate(thisObject);
        int[] handle = new int[1];
        C.memmove(handle, ptr, C.PTR_SIZEOF);
        Browser browser = WebKit.findBrowser(handle[0]);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.callJava(ctx, function, thisObject, argumentCount, arguments, exception);
    }

    static int JSObjectGetPropertyProc(int ctx, int object, int propertyName, int exception) {
        byte[] bytes = null;
        try {
            bytes = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        int name = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        int function = WebKitGTK.JSObjectMakeFunctionWithCallback(ctx, name, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(name);
        return function;
    }

    static int JSObjectHasPropertyProc(int ctx, int object, int propertyName) {
        byte[] bytes = null;
        try {
            bytes = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        return WebKitGTK.JSStringIsEqualToUTF8CString(propertyName, bytes);
    }

    static int Proc(int handle, int user_data) {
        Browser browser = WebKit.findBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, user_data);
    }

    static int Proc(int handle, int arg0, int user_data) {
        if (OS.GTK_IS_SCROLLED_WINDOW(handle)) {
            return user_data;
        }
        int webView = WebKitGTK.WEBKIT_IS_WEB_FRAME(handle) ? WebKitGTK.webkit_web_frame_get_web_view(handle) : handle;
        Browser browser = WebKit.findBrowser(webView);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        if (webView == handle) {
            return webkit.webViewProc(handle, arg0, user_data);
        }
        return webkit.webFrameProc(handle, arg0, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int user_data) {
        Browser browser = WebKit.findBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int arg2, int user_data) {
        int webView = WebKitGTK.SOUP_IS_SESSION(handle) ? user_data : handle;
        Browser browser = WebKit.findBrowser(webView);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        if (webView == handle) {
            return webkit.webViewProc(handle, arg0, arg1, arg2, user_data);
        }
        return webkit.sessionProc(handle, arg0, arg1, arg2, user_data);
    }

    static int Proc(int handle, int arg0, int arg1, int arg2, int arg3, int user_data) {
        Browser browser = WebKit.findBrowser(handle);
        if (browser == null) {
            return 0;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, arg2, arg3, user_data);
    }

    int sessionProc(int session, int msg, int auth, int retrying, int user_data) {
        if (retrying == 0) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0;
        }
        int uri = WebKitGTK.soup_message_get_uri(msg);
        int uriString = WebKitGTK.soup_uri_to_string(uri, 0);
        int length = C.strlen(uriString);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uriString, length);
        OS.g_free(uriString);
        String location = new String(MozillaDelegate.mbcsToWcs(null, bytes));
        int i = 0;
        while (i < this.authenticationListeners.length) {
            AuthenticationEvent event = new AuthenticationEvent(this.browser);
            event.location = location;
            this.authenticationListeners[i].authenticate(event);
            if (!event.doit) {
                OS.g_signal_stop_emission_by_name(session, WebKitGTK.authenticate);
                return 0;
            }
            if (event.user != null && event.password != null) {
                byte[] userBytes = Converter.wcsToMbcs(null, event.user, true);
                byte[] passwordBytes = Converter.wcsToMbcs(null, event.password, true);
                WebKitGTK.soup_auth_authenticate(auth, userBytes, passwordBytes);
                OS.g_signal_stop_emission_by_name(session, WebKitGTK.authenticate);
                return 0;
            }
            ++i;
        }
        return 0;
    }

    int webFrameProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 9: {
                return this.webframe_notify_load_status(handle, arg0);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int user_data) {
        switch (user_data) {
            case 13: {
                return this.webkit_close_web_view(handle);
            }
            case 8: {
                return this.webkit_web_view_ready(handle);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 7: {
                return this.webkit_create_web_view(handle, arg0);
            }
            case 11: {
                return this.webkit_download_requested(handle, arg0);
            }
            case 9: {
                return this.webkit_notify_load_status(handle, arg0);
            }
            case 2: {
                return this.webkit_notify_progress(handle, arg0);
            }
            case 4: {
                return this.webkit_notify_title(handle, arg0);
            }
            case 5: {
                return this.webkit_populate_popup(handle, arg0);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(handle, arg0);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int user_data) {
        switch (user_data) {
            case 1: {
                return this.webkit_hovering_over_link(handle, arg0, arg1);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        switch (user_data) {
            case 15: {
                return this.webkit_console_message(handle, arg0, arg1, arg2);
            }
            case 14: {
                return this.webkit_window_object_cleared(handle, arg0, arg1, arg2);
            }
        }
        return 0;
    }

    int webViewProc(int handle, int arg0, int arg1, int arg2, int arg3, int user_data) {
        switch (user_data) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(handle, arg0, arg1, arg2, arg3);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(handle, arg0, arg1, arg2, arg3);
            }
            case 10: {
                return this.webkit_resource_request_starting(handle, arg0, arg1, arg2, arg3);
            }
        }
        return 0;
    }

    public boolean create(Composite parent, int style) {
        if (!LibraryLoaded) {
            return false;
        }
        if (ExternalClass == 0) {
            boolean success;
            int major = WebKitGTK.webkit_major_version();
            int minor = WebKitGTK.webkit_minor_version();
            int micro = WebKitGTK.webkit_micro_version();
            boolean bl = success = major > MIN_VERSION[0] || major == MIN_VERSION[0] && minor > MIN_VERSION[1] || major == MIN_VERSION[0] && minor == MIN_VERSION[1] && micro >= MIN_VERSION[2];
            if (!success) {
                return false;
            }
            if (Device.DEBUG) {
                System.out.println("WebKit version " + major + "." + minor + "." + micro);
            }
            JSClassDefinition jsClassDefinition = new JSClassDefinition();
            byte[] bytes = Converter.wcsToMbcs(null, CLASSNAME_EXTERNAL, true);
            jsClassDefinition.className = C.malloc(bytes.length);
            OS.memmove(jsClassDefinition.className, bytes, bytes.length);
            jsClassDefinition.hasProperty = JSObjectHasPropertyProc.getAddress();
            jsClassDefinition.getProperty = JSObjectGetPropertyProc.getAddress();
            int classDefinitionPtr = C.malloc(JSClassDefinition.sizeof);
            WebKitGTK.memmove(classDefinitionPtr, jsClassDefinition, JSClassDefinition.sizeof);
            ExternalClass = WebKitGTK.JSClassCreate(classDefinitionPtr);
            bytes = Converter.wcsToMbcs(null, "POST", true);
            PostString = C.malloc(bytes.length);
            C.memmove(PostString, bytes, bytes.length);
        }
        this.scrolledWindow = OS.gtk_scrolled_window_new(0, 0);
        OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        this.webView = WebKitGTK.webkit_web_view_new();
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new int[]{this.webView}, C.PTR_SIZEOF);
        OS.gtk_container_add(this.scrolledWindow, this.webView);
        OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
        OS.gtk_widget_show(this.scrolledWindow);
        OS.gtk_widget_show(this.webView);
        OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13);
        OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15);
        OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7);
        OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11);
        OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1);
        OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12);
        OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4);
        OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5);
        OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10);
        OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6);
        OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8);
        OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14);
        OS.g_signal_connect(this.scrolledWindow, OS.event, Proc3.getAddress(), 0);
        OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, Proc3.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, Proc3.getAddress(), 1);
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(settings, WebKitGTK.javascript_can_open_windows_automatically, 1, 0);
        OS.g_object_set(settings, WebKitGTK.enable_universal_access_from_file_uris, 1, 0);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        OS.gtk_widget_grab_focus(WebKit.this.webView);
                        break;
                    }
                    case 11: {
                        WebKit.this.onResize(event);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        int session = WebKitGTK.webkit_get_default_session();
        int originalAuth = WebKitGTK.soup_session_get_feature(session, WebKitGTK.webkit_soup_auth_dialog_get_type());
        WebKitGTK.soup_session_feature_detach(originalAuth, session);
        OS.g_signal_connect(session, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
        WebKitGTK.soup_session_feature_attach(originalAuth, session);
        String proxyHost = System.getProperty(PROPERTY_PROXYHOST);
        String proxyPortString = System.getProperty(PROPERTY_PROXYPORT);
        int port = -1;
        if (proxyPortString != null) {
            try {
                int value = Integer.valueOf(proxyPortString);
                if (value >= 0 && value <= 65535) {
                    port = value;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proxyHost != null || port != -1) {
            byte[] bytes;
            int uri;
            if (!proxyHost.startsWith(PROTOCOL_HTTP)) {
                proxyHost = PROTOCOL_HTTP + proxyHost;
            }
            if ((uri = WebKitGTK.soup_uri_new(bytes = Converter.wcsToMbcs(null, proxyHost = String.valueOf(proxyHost) + ":" + port, true))) != 0) {
                OS.g_object_set(session, WebKitGTK.SOUP_SESSION_PROXY_URI, uri, 0);
                WebKitGTK.soup_uri_free(uri);
            }
        }
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            public Object function(Object[] arguments) {
                return WebKit.this.handleEvent(arguments) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        return true;
    }

    void addEventHandlers(boolean top) {
        if (top) {
            StringBuffer buffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            buffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            buffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            buffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.execute(buffer.toString());
            buffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            buffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            buffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            this.execute(buffer.toString());
        } else {
            StringBuffer buffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            buffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            buffer.append('}');
            this.execute(buffer.toString());
        }
    }

    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean showPrompters) {
        if (!this.jsEnabled) {
            return true;
        }
        String message1 = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String message2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String functionName = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer buffer = new StringBuffer("function ");
        buffer.append(functionName);
        buffer.append("(win) {\n");
        buffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (showPrompters) {
            buffer.append("if (str != null) { ");
            buffer.append("var result = confirm('");
            buffer.append(message1);
            buffer.append("\\n\\n'+str+'\\n\\n");
            buffer.append(message2);
            buffer.append("');");
            buffer.append("if (!result) return false;}");
        }
        buffer.append("} catch (e) {}}");
        buffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        buffer.append(functionName);
        buffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        buffer.append("\n};");
        this.execute(buffer.toString());
        Boolean result = (Boolean)this.evaluate("return " + functionName + "(window);");
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean execute(String script) {
        int frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int context = WebKitGTK.webkit_web_frame_get_global_context(frame);
        byte[] bytes = null;
        try {
            bytes = (String.valueOf(script) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, script, true);
        }
        int scriptString = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        try {
            bytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, this.getUrl(), true);
        }
        int urlString = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        int result = WebKitGTK.JSEvaluateScript(context, scriptString, 0, urlString, 0, null);
        WebKitGTK.JSStringRelease(urlString);
        WebKitGTK.JSStringRelease(scriptString);
        return result != 0;
    }

    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int source = WebKitGTK.webkit_web_frame_get_data_source(frame);
        if (source == 0) {
            return "";
        }
        int data = WebKitGTK.webkit_web_data_source_get_data(source);
        if (data == 0) {
            return "";
        }
        int encoding = WebKitGTK.webkit_web_data_source_get_encoding(source);
        int length = OS.strlen(encoding);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, encoding, length);
        String encodingString = new String(Converter.mbcsToWcs(null, bytes));
        int string = OS.GString_str(data);
        length = OS.GString_len(string);
        bytes = new byte[length];
        C.memmove(bytes, string, length);
        try {
            return new String(bytes, encodingString);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(null, bytes));
        }
    }

    public String getUrl() {
        int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (uri == 0) {
            return ABOUT_BLANK;
        }
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(null, bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        return url;
    }

    boolean handleEvent(Object[] arguments) {
        int mask;
        String type = (String)arguments[0];
        if (type.equals(DOMEVENT_KEYDOWN)) {
            int keyCode;
            this.lastKeyCode = keyCode = this.translateKey(((Double)arguments[1]).intValue());
            switch (keyCode) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event keyEvent = new Event();
                    keyEvent.widget = this.browser;
                    keyEvent.type = type.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    keyEvent.keyCode = keyCode;
                    switch (keyCode) {
                        case 8: {
                            keyEvent.character = (char)8;
                            break;
                        }
                        case 127: {
                            keyEvent.character = (char)127;
                            break;
                        }
                        case 27: {
                            keyEvent.character = (char)27;
                            break;
                        }
                        case 9: {
                            keyEvent.character = (char)9;
                        }
                    }
                    this.lastCharCode = keyEvent.character;
                    keyEvent.stateMask = ((Boolean)arguments[3] != false ? 65536 : 0) | ((Boolean)arguments[4] != false ? 262144 : 0) | ((Boolean)arguments[5] != false ? 131072 : 0) | ((Boolean)arguments[6] != false ? 0x400000 : 0);
                    keyEvent.stateMask &= ~keyCode;
                    final int stateMask = keyEvent.stateMask;
                    if (!this.sendKeyEvent(keyEvent) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || keyCode != 9 || (stateMask & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (WebKit.this.browser.isDisposed()) {
                                return;
                            }
                            if (WebKit.this.browser.getDisplay().getFocusControl() == null) {
                                int traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                                WebKit.this.browser.traverse(traversal);
                            }
                        }
                    });
                }
            }
            return true;
        }
        if (type.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = ((Double)arguments[2]).intValue();
            if (((Boolean)arguments[4]).booleanValue() && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = ((Boolean)arguments[3] != false ? 65536 : 0) | ((Boolean)arguments[4] != false ? 262144 : 0) | ((Boolean)arguments[5] != false ? 131072 : 0) | ((Boolean)arguments[6] != false ? 0x400000 : 0);
            return this.sendKeyEvent(keyEvent) && !this.browser.isDisposed();
        }
        if (type.equals(DOMEVENT_KEYUP)) {
            int keyCode = this.translateKey(((Double)arguments[1]).intValue());
            if (keyCode == 0) {
                return true;
            }
            if (keyCode != this.lastKeyCode) {
                this.lastKeyCode = keyCode;
                this.lastCharCode = 0;
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 2;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = ((Boolean)arguments[3] != false ? 65536 : 0) | ((Boolean)arguments[4] != false ? 262144 : 0) | ((Boolean)arguments[5] != false ? 131072 : 0) | ((Boolean)arguments[6] != false ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    keyEvent.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(keyEvent.type, keyEvent);
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return keyEvent.doit && !this.browser.isDisposed();
        }
        Point position = new Point(((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue());
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = position.x;
        mouseEvent.y = position.y;
        mouseEvent.stateMask = mask = ((Boolean)arguments[5] != false ? 65536 : 0) | ((Boolean)arguments[6] != false ? 262144 : 0) | ((Boolean)arguments[7] != false ? 131072 : 0) | ((Boolean)arguments[8] != false ? 0x400000 : 0);
        if (type.equals(DOMEVENT_MOUSEDOWN)) {
            mouseEvent.type = 3;
            mouseEvent.count = ((Double)arguments[3]).intValue();
            mouseEvent.button = ((Double)arguments[4]).intValue();
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (((Double)arguments[3]).intValue() == 2) {
                mouseEvent = new Event();
                mouseEvent.type = 8;
                mouseEvent.widget = this.browser;
                mouseEvent.x = position.x;
                mouseEvent.y = position.y;
                mouseEvent.stateMask = mask;
                mouseEvent.count = ((Double)arguments[3]).intValue();
                mouseEvent.button = ((Double)arguments[4]).intValue();
                this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            }
            return true;
        }
        if (type.equals(DOMEVENT_MOUSEUP)) {
            mouseEvent.type = 4;
            mouseEvent.count = ((Double)arguments[3]).intValue();
            mouseEvent.button = ((Double)arguments[4]).intValue();
        } else if (type.equals(DOMEVENT_MOUSEMOVE)) {
            mouseEvent.type = 5;
        } else if (type.equals(DOMEVENT_MOUSEWHEEL)) {
            mouseEvent.type = 37;
            mouseEvent.count = ((Double)arguments[3]).intValue();
        } else if (type.equals(DOMEVENT_DRAGSTART)) {
            mouseEvent.type = 29;
            mouseEvent.button = ((Double)arguments[4]).intValue() + 1;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            return false;
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        return true;
    }

    int handleLoadCommitted(int uri, boolean top) {
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(null, bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        if (top && url.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0;
        }
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        event.top = top;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int handleLoadFinished(int uri, boolean top) {
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(null, bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        if (top && this.htmlBytes != null && url.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            byte[] mimeType = Converter.wcsToMbcs(null, "text/html", true);
            byte[] encoding = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
            byte[] uriBytes = this.untrustedText ? Converter.wcsToMbcs(null, ABOUT_BLANK, true) : Converter.wcsToMbcs(null, URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, mimeType, encoding, uriBytes);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            int frame;
            int title;
            if (top && (title = WebKitGTK.webkit_web_frame_get_title(frame = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0) {
                TitleEvent newEvent = new TitleEvent(this.browser);
                newEvent.display = this.browser.getDisplay();
                newEvent.widget = this.browser;
                newEvent.title = url;
                int i = 0;
                while (i < this.titleListeners.length) {
                    this.titleListeners[i].changed(newEvent);
                    ++i;
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = this.browser.getDisplay();
            progress.widget = this.browser;
            progress.current = 100;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].completed(progress);
                ++i;
            }
        }
        this.loadingText = false;
        return 0;
    }

    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event e) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Enumeration elements = this.functions.elements();
        while (elements.hasMoreElements()) {
            ((BrowserFunction)elements.nextElement()).dispose(false);
        }
        this.functions = null;
        C.free(this.webViewData);
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event e) {
        Rectangle rect = this.browser.getClientArea();
        OS.gtk_widget_set_size_request(this.scrolledWindow, rect.width, rect.height);
    }

    void openDownloadWindow(final int webkitDownload) {
        final Shell shell = new Shell();
        String msg = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        int name = WebKitGTK.webkit_download_get_suggested_filename(webkitDownload);
        int length = OS.strlen(name);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, name, length);
        String nameString = new String(Converter.mbcsToWcs(null, bytes));
        int url = WebKitGTK.webkit_download_get_uri(webkitDownload);
        length = OS.strlen(url);
        bytes = new byte[length];
        OS.memmove(bytes, url, length);
        String urlString = new String(Converter.mbcsToWcs(null, bytes));
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{nameString, urlString});
        Label nameLabel = new Label(shell, 64);
        nameLabel.setText(msg);
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width / 2;
        int width = nameLabel.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        nameLabel.setLayoutData(data);
        final Label statusLabel = new Label(shell, 0);
        statusLabel.setText(Compatibility.getMessage("SWT_Download_Started"));
        data = new GridData(1808);
        statusLabel.setLayoutData(data);
        final Button cancel = new Button(shell, 8);
        cancel.setText(Compatibility.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        cancel.setLayoutData(data);
        final Listener cancelListener = new Listener(){

            public void handleEvent(Event event) {
                WebKitGTK.webkit_download_cancel(webkitDownload);
            }
        };
        cancel.addListener(13, cancelListener);
        OS.g_object_ref(webkitDownload);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            public void run() {
                int status = WebKitGTK.webkit_download_get_status(webkitDownload);
                if (shell.isDisposed() || status == 3 || status == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    return;
                }
                if (status == -1) {
                    statusLabel.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    cancel.removeListener(13, cancelListener);
                    cancel.addListener(13, new Listener(this, shell){
                        final /* synthetic */ 8 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void handleEvent(Event event) {
                            this.val$shell.dispose();
                        }
                    });
                    return;
                }
                long current = WebKitGTK.webkit_download_get_current_size(webkitDownload) / 1024L;
                long total = WebKitGTK.webkit_download_get_total_size(webkitDownload) / 1024L;
                String message = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(current), new Long(total)});
                statusLabel.setText(message);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    public boolean setText(String html, boolean trusted) {
        byte[] bytes = null;
        try {
            bytes = (String.valueOf(html) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, html, true);
        }
        boolean blankLoading = this.htmlBytes != null;
        this.htmlBytes = bytes;
        boolean bl = this.untrustedText = !trusted;
        if (blankLoading) {
            return true;
        }
        byte[] uriBytes = Converter.wcsToMbcs(null, ABOUT_BLANK, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, uriBytes);
        return true;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        this.postData = postData;
        this.headers = headers;
        try {
            new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            String testUrl = null;
            testUrl = url.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + url : PROTOCOL_HTTP + url;
            try {
                new URL(testUrl);
                url = testUrl;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int index;
                String current = headers[i];
                if (current != null && (index = current.indexOf(58)) != -1) {
                    String key = current.substring(0, index).trim();
                    String value = current.substring(index + 1).trim();
                    if (key.length() > 0 && value.length() > 0 && key.equalsIgnoreCase(USER_AGENT)) {
                        byte[] bytes = Converter.wcsToMbcs(null, value, true);
                        OS.g_object_set(settings, WebKitGTK.user_agent, bytes, 0);
                    }
                }
                ++i;
            }
        }
        byte[] uriBytes = Converter.wcsToMbcs(null, url, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, uriBytes);
        OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0);
        return true;
    }

    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    int webframe_notify_load_status(int web_frame, int pspec) {
        int status = WebKitGTK.webkit_web_frame_get_load_status(web_frame);
        switch (status) {
            case 1: {
                int uri = WebKitGTK.webkit_web_frame_get_uri(web_frame);
                return this.handleLoadCommitted(uri, false);
            }
            case 2: {
                int parentFrame = WebKitGTK.webkit_web_frame_get_parent(web_frame);
                if (WebKitGTK.webkit_web_frame_get_load_status(parentFrame) != 2) break;
                int uri = WebKitGTK.webkit_web_frame_get_uri(web_frame);
                return this.handleLoadFinished(uri, false);
            }
        }
        return 0;
    }

    int webkit_close_web_view(int web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        return 0;
    }

    int webkit_console_message(int web_view, int message, int line, int source_id) {
        return 1;
    }

    int webkit_create_web_view(int web_view, int frame) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        if (this.openWindowListeners != null) {
            int i = 0;
            while (i < this.openWindowListeners.length) {
                this.openWindowListeners[i].open(newEvent);
                ++i;
            }
        }
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            return ((WebKit)((Browser)browser).webBrowser).webView;
        }
        return 0;
    }

    int webkit_download_requested(int web_view, int download) {
        int name = WebKitGTK.webkit_download_get_suggested_filename(download);
        int length = OS.strlen(name);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, name, length);
        String nameString = new String(Converter.mbcsToWcs(null, bytes));
        FileDialog dialog = new FileDialog(this.browser.getShell(), 4096);
        dialog.setFileName(nameString);
        String title = Compatibility.getMessage("SWT_FileDownload");
        dialog.setText(title);
        String path = dialog.open();
        if (path != null) {
            path = URI_FILEROOT + path;
            byte[] uriBytes = Converter.wcsToMbcs(null, path, true);
            WebKitGTK.webkit_download_set_destination_uri(download, uriBytes);
            this.openDownloadWindow(download);
        } else {
            WebKitGTK.webkit_download_cancel(download);
        }
        return 1;
    }

    int webkit_hovering_over_link(int web_view, int title, int uri) {
        if (uri != 0) {
            int length = OS.strlen(uri);
            byte[] bytes = new byte[length];
            OS.memmove(bytes, uri, length);
            String text = new String(Converter.mbcsToWcs(null, bytes));
            StatusTextEvent event = new StatusTextEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.text = text;
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(event);
                ++i;
            }
        }
        return 0;
    }

    int webkit_mime_type_policy_decision_requested(int web_view, int frame, int request, int mimetype, int policy_decision) {
        boolean canShow;
        boolean bl = canShow = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, mimetype) != 0;
        if (!canShow) {
            WebKitGTK.webkit_web_policy_decision_download(policy_decision);
            return 1;
        }
        return 0;
    }

    int webkit_navigation_policy_decision_requested(int web_view, int frame, int request, int navigation_action, int policy_decision) {
        if (this.loadingText) {
            return 0;
        }
        int uri = WebKitGTK.webkit_network_request_get_uri(request);
        int length = OS.strlen(uri);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, uri, length);
        String url = new String(Converter.mbcsToWcs(null, bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        if (this.locationListeners != null) {
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(newEvent);
                ++i;
            }
        }
        if (newEvent.doit && !this.browser.isDisposed()) {
            int id;
            int mainFrame;
            if (this.jsEnabledChanged) {
                this.jsEnabledChanged = false;
                int settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
                OS.g_object_set(settings, WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0, 0);
            }
            if (frame != (mainFrame = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (id = OS.g_signal_handler_find(frame, 24, 0, 0, 0, Proc3.getAddress(), 9)) == 0) {
                OS.g_signal_connect(frame, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(policy_decision);
        }
        return 0;
    }

    int webkit_notify_load_status(int web_view, int pspec) {
        int status = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (status) {
            case 1: {
                int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(uri, true);
            }
            case 2: {
                int uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(uri, true);
            }
        }
        return 0;
    }

    int webkit_notify_progress(int web_view, int pspec) {
        ProgressEvent event = new ProgressEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.current = (int)(WebKitGTK.webkit_web_view_get_progress(this.webView) * 100.0);
        event.total = 100;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int webkit_notify_title(int web_view, int pspec) {
        String titleString;
        int title = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (title == 0) {
            titleString = "";
        } else {
            int length = OS.strlen(title);
            byte[] bytes = new byte[length];
            OS.memmove(bytes, title, length);
            titleString = new String(Converter.mbcsToWcs(null, bytes));
        }
        TitleEvent event = new TitleEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.title = titleString;
        int i = 0;
        while (i < this.titleListeners.length) {
            this.titleListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int webkit_populate_popup(int web_view, int webkit_menu) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            int children;
            int current = children = OS.gtk_container_get_children(webkit_menu);
            while (current != 0) {
                int item = OS.g_list_data(current);
                OS.gtk_container_remove(webkit_menu, item);
                current = OS.g_list_next(current);
            }
            OS.g_list_free(children);
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            int children;
            if (pt.x != event.x || pt.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            int current = children = OS.gtk_container_get_children(webkit_menu);
            while (current != 0) {
                int item = OS.g_list_data(current);
                OS.gtk_container_remove(webkit_menu, item);
                current = OS.g_list_next(current);
            }
            OS.g_list_free(children);
        }
        return 0;
    }

    int webkit_resource_request_starting(int web_view, int web_frame, int web_resource, int request, int response) {
        if (this.postData != null || this.headers != null) {
            int message = WebKitGTK.webkit_network_request_get_message(request);
            if (message == 0) {
                this.headers = null;
                this.postData = null;
            } else {
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(message, PostString);
                    int body = WebKitGTK.SoupMessage_request_body(message);
                    byte[] bytes = Converter.wcsToMbcs(null, this.postData, false);
                    int data = C.malloc(bytes.length);
                    C.memmove(data, bytes, bytes.length);
                    WebKitGTK.soup_message_body_append(body, 1, data, bytes.length);
                    WebKitGTK.soup_message_body_flatten(body);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    String[] temp = new String[this.headers.length + 1];
                    System.arraycopy(this.headers, 0, temp, 0, this.headers.length);
                    temp[this.headers.length] = ENCODING_FORM;
                    this.headers = temp;
                    this.postData = null;
                }
                int requestHeaders = WebKitGTK.SoupMessage_request_headers(message);
                int i = 0;
                while (i < this.headers.length) {
                    int index;
                    String current = this.headers[i];
                    if (current != null && (index = current.indexOf(58)) != -1) {
                        String key = current.substring(0, index).trim();
                        String value = current.substring(index + 1).trim();
                        if (key.length() > 0 && value.length() > 0) {
                            byte[] nameBytes = Converter.wcsToMbcs(null, key, true);
                            byte[] valueBytes = Converter.wcsToMbcs(null, value, true);
                            WebKitGTK.soup_message_headers_append(requestHeaders, nameBytes, valueBytes);
                        }
                    }
                    ++i;
                }
                this.headers = null;
            }
        }
        return 0;
    }

    int webkit_status_bar_text_changed(int web_view, int text) {
        int length = OS.strlen(text);
        byte[] bytes = new byte[length];
        OS.memmove(bytes, text, length);
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = new String(Converter.mbcsToWcs(null, bytes));
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
        return 0;
    }

    int webkit_web_view_ready(int web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int settings = WebKitGTK.webkit_web_view_get_window_features(this.webView);
        int[] result = new int[1];
        OS.g_object_get(settings, WebKitGTK.locationbar_visible, result, 0);
        newEvent.addressBar = result[0] != 0;
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.menubar_visible, result, 0);
        newEvent.menuBar = result[0] != 0;
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.statusbar_visible, result, 0);
        newEvent.statusBar = result[0] != 0;
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.toolbar_visible, result, 0);
        newEvent.toolBar = result[0] != 0;
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.x, result, 0);
        int x = result[0];
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.y, result, 0);
        int y = result[0];
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.width, result, 0);
        int width = result[0];
        result[0] = 0;
        OS.g_object_get(settings, WebKitGTK.height, result, 0);
        int height = result[0];
        result[0] = 0;
        if (x != -1 && y != -1) {
            newEvent.location = new Point(x, y);
        }
        if (width != -1 && height != -1) {
            newEvent.size = new Point(width, height);
        }
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        return 0;
    }

    int webkit_window_object_cleared(int web_view, int frame, int context, int window_object) {
        int globalObject = WebKitGTK.JSContextGetGlobalObject(context);
        int externalObject = WebKitGTK.JSObjectMake(context, ExternalClass, this.webViewData);
        byte[] bytes = null;
        try {
            bytes = "external\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = Converter.wcsToMbcs(null, OBJECTNAME_EXTERNAL, true);
        }
        int name = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
        WebKitGTK.JSObjectSetProperty(context, globalObject, name, externalObject, 0, null);
        WebKitGTK.JSStringRelease(name);
        Enumeration elements = this.functions.elements();
        while (elements.hasMoreElements()) {
            BrowserFunction current = (BrowserFunction)elements.nextElement();
            this.execute(current.functionString);
        }
        int mainFrame = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean top = mainFrame == frame;
        this.addEventHandlers(top);
        return 0;
    }

    int callJava(int ctx, int func, int thisObject, int argumentCount, int arguments, int exception) {
        Object returnValue = null;
        if (argumentCount == 2) {
            int[] result = new int[1];
            C.memmove(result, arguments, C.PTR_SIZEOF);
            int type = WebKitGTK.JSValueGetType(ctx, result[0]);
            if (type == 3) {
                Integer key;
                BrowserFunction function;
                int index = ((Double)this.convertToJava(ctx, result[0])).intValue();
                result[0] = 0;
                if (index > 0 && (function = (BrowserFunction)this.functions.get(key = new Integer(index))) != null) {
                    try {
                        C.memmove(result, arguments + C.PTR_SIZEOF, C.PTR_SIZEOF);
                        Object temp = this.convertToJava(ctx, result[0]);
                        if (temp instanceof Object[]) {
                            Object[] args = (Object[])temp;
                            try {
                                returnValue = function.function(args);
                            }
                            catch (Exception e) {
                                returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (function.isEvaluate) {
                            function.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                        }
                        returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    }
                }
            }
        }
        return this.convertToJS(ctx, returnValue);
    }

    int convertToJS(int ctx, Object value) {
        if (value == null) {
            return WebKitGTK.JSValueMakeUndefined(ctx);
        }
        if (value instanceof String) {
            byte[] bytes = null;
            try {
                bytes = (String.valueOf((String)value) + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = Converter.wcsToMbcs(null, (String)value, true);
            }
            int stringRef = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
            int result = WebKitGTK.JSValueMakeString(ctx, stringRef);
            WebKitGTK.JSStringRelease(stringRef);
            return result;
        }
        if (value instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(ctx, (Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(ctx, ((Number)value).doubleValue());
        }
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            int length = arrayValue.length;
            int[] arguments = new int[length];
            int i = 0;
            while (i < length) {
                int jsObject;
                Object javaObject = arrayValue[i];
                arguments[i] = jsObject = this.convertToJS(ctx, javaObject);
                ++i;
            }
            return WebKitGTK.JSObjectMakeArray(ctx, length, arguments, null);
        }
        SWT.error(51);
        return 0;
    }

    Object convertToJava(int ctx, int value) {
        int type = WebKitGTK.JSValueGetType(ctx, value);
        switch (type) {
            case 2: {
                int result = WebKitGTK.JSValueToBoolean(ctx, value);
                return new Boolean(result != 0);
            }
            case 3: {
                double result = WebKitGTK.JSValueToNumber(ctx, value, null);
                return new Double(result);
            }
            case 4: {
                int string = WebKitGTK.JSValueToStringCopy(ctx, value, null);
                if (string == 0) {
                    return "";
                }
                int length = WebKitGTK.JSStringGetMaximumUTF8CStringSize(string);
                byte[] bytes = new byte[length];
                length = WebKitGTK.JSStringGetUTF8CString(string, bytes, length);
                WebKitGTK.JSStringRelease(string);
                try {
                    return new String(bytes, 0, length - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(Converter.mbcsToWcs(null, bytes));
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] bytes = null;
                try {
                    bytes = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytes = Converter.wcsToMbcs(null, PROPERTY_LENGTH, true);
                }
                int propertyName = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
                int valuePtr = WebKitGTK.JSObjectGetProperty(ctx, value, propertyName, null);
                WebKitGTK.JSStringRelease(propertyName);
                type = WebKitGTK.JSValueGetType(ctx, valuePtr);
                if (type != 3) break;
                int length = (int)WebKitGTK.JSValueToNumber(ctx, valuePtr, null);
                Object[] result = new Object[length];
                int i = 0;
                while (i < length) {
                    int current = WebKitGTK.JSObjectGetPropertyAtIndex(ctx, value, i, null);
                    if (current != 0) {
                        result[i] = this.convertToJava(ctx, current);
                    }
                    ++i;
                }
                return result;
            }
        }
        SWT.error(5);
        return null;
    }
}

