#!/bin/sh

echo $CLASSPATH
if [ -f /usr/share/java/crimson.jar ] ; then
	CLASSPATH=${CLASSPATH}:/usr/share/java/crimson.jar
elif [ -f /usr/share/xerces.jar ] ; then
	CLASSPATH=${CLASSPATH}:/usr/share/java/xerces.jar
elif [ -f /usr/share/java/xerces.jar ] ; then
	echo "can't find both xerces and crimson."
	exit 
fi

CLASSPATH=${CLASSPATH}:/usr/share/java/ant.jar

echo
echo "JDOM Build System"
echo "-------------------"
echo

if [ "$JAVA_HOME" = "" ] ; then
  echo "ERROR: JAVA_HOME not found in your environment."
  echo
  echo "Please, set the JAVA_HOME variable in your environment to match the"
  echo "location of the Java Virtual Machine you want to use."
  exit 1
fi

if [ `echo $OSTYPE | grep -n cygwin` ]; then
  PS=";"
else
  PS=":"
fi

LOCALCLASSPATH=$JAVA_HOME/lib/tools.jar${PS}$JAVA_HOME/lib/dev.jar
ANT_HOME=./lib

echo Building with classpath $CLASSPATH${PS}$LOCALCLASSPATH${PS}$ADDITIONALCLASSPATH
echo

echo Starting Ant...
echo

# One person found a seg fault with jdk 1.3.0 on Linux where adding -classic
# to the following line fixed the issue

echo $JAVA_HOME/bin/java -Dant.home=$ANT_HOME -classpath $CLASSPATH${PS}$LOCALCLASSPATH${PS}$ADDITIONALCLASSPATH org.apache.tools.ant.Main $*
$JAVA_HOME/bin/java -Dant.home=$ANT_HOME -classpath $CLASSPATH${PS}$LOCALCLASSPATH${PS}$ADDITIONALCLASSPATH org.apache.tools.ant.Main $*