/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.util.HashNMap;
import org.jfree.xml.generator.SourceCollector;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.BasicTypeSupport;

public final class ModelBuilder {
    private static ModelBuilder instance;
    private Properties handlerMapping = new Properties();
    static /* synthetic */ Class class$java$lang$Object;

    private ModelBuilder() {
    }

    public void addAttributeHandlers(Properties p) {
        ((Hashtable)this.handlerMapping).putAll(p);
    }

    public DescriptionModel buildModel(SourceCollector c, DescriptionModel model) {
        Class[] classes = c.getClasses();
        if (model == null) {
            model = new DescriptionModel();
        }
        while (classes.length != 0) {
            classes = this.fillModel(classes, model);
        }
        this.fillSuperClasses(model);
        Class[] baseClasses = this.findElementTypes(model);
        HashNMap classMap = new HashNMap();
        int i = 0;
        while (i < baseClasses.length) {
            Class base = baseClasses[i];
            int j = 0;
            while (j < baseClasses.length) {
                Class child = baseClasses[j];
                if (!Modifier.isAbstract(child.getModifiers()) && base.isAssignableFrom(child)) {
                    classMap.add((Object)base, (Object)child);
                }
                ++j;
            }
            ++i;
        }
        Iterator keys = classMap.keys();
        while (keys.hasNext()) {
            ArrayList<TypeInfo> typeInfoList;
            Class base = (Class)keys.next();
            Class[] childs = (Class[])classMap.toArray((Object)base, (Object[])new Class[0]);
            if (childs.length < 2) continue;
            boolean isNew = false;
            MultiplexMappingInfo mmi = model.getMappingModel().lookupMultiplexMapping(base);
            if (mmi == null) {
                mmi = new MultiplexMappingInfo(base);
                typeInfoList = new ArrayList();
                isNew = true;
            } else {
                typeInfoList = new ArrayList<TypeInfo>(Arrays.asList(mmi.getChildClasses()));
            }
            int i2 = 0;
            while (i2 < childs.length) {
                TypeInfo typeInfo = new TypeInfo(childs[i2].getName(), childs[i2]);
                if (!typeInfoList.contains(typeInfo)) {
                    typeInfoList.add(typeInfo);
                }
                ++i2;
            }
            mmi.setChildClasses(typeInfoList.toArray(new TypeInfo[0]));
            if (!isNew) continue;
            model.getMappingModel().addMultiplexMapping(mmi);
        }
        return model;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private boolean contains(Class[] cAll, Class c) {
        int i = 0;
        while (i < cAll.length) {
            if (cAll[i].equals(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ClassDescription createClassDescription(BeanInfo beanInfo, ClassDescription parent) {
        ClassDescription cd;
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        int i = 0;
        while (i < props.length) {
            PropertyInfo pi;
            PropertyDescriptor propertyDescriptor = props[i];
            if (parent != null && (pi = parent.getProperty(propertyDescriptor.getName())) != null) {
                properties.add(pi);
            } else if (!(props[i] instanceof IndexedPropertyDescriptor) && (pi = this.createSimplePropertyInfo(props[i])) != null) {
                properties.add(pi);
            }
            ++i;
        }
        PropertyInfo[] propArray = properties.toArray(new PropertyInfo[properties.size()]);
        if (parent != null) {
            cd = parent;
        } else {
            cd = new ClassDescription(beanInfo.getBeanDescriptor().getBeanClass());
            cd.setDescription(beanInfo.getBeanDescriptor().getShortDescription());
        }
        cd.setProperties(propArray);
        return cd;
    }

    public PropertyInfo createSimplePropertyInfo(PropertyDescriptor pd) {
        boolean readMethod = ModelBuilder.isValidMethod(pd.getReadMethod());
        boolean writeMethod = ModelBuilder.isValidMethod(pd.getWriteMethod());
        if (!writeMethod || !readMethod) {
            return null;
        }
        PropertyInfo pi = new PropertyInfo(pd.getName(), pd.getPropertyType());
        pi.setConstrained(pd.isConstrained());
        pi.setDescription(pd.getShortDescription());
        pi.setNullable(true);
        pi.setPreserve(false);
        pi.setReadMethodAvailable(readMethod);
        pi.setWriteMethodAvailable(writeMethod);
        pi.setXmlName(pd.getName());
        if (this.isAttributeProperty(pd.getPropertyType())) {
            pi.setPropertyType(PropertyType.ATTRIBUTE);
            pi.setXmlHandler(this.getHandlerClass(pd.getPropertyType()));
        } else {
            pi.setPropertyType(PropertyType.ELEMENT);
        }
        return pi;
    }

    private Class[] fillModel(Class[] classes, DescriptionModel model) {
        ArrayList<Class> superClasses = new ArrayList<Class>();
        int i = 0;
        while (i < classes.length) {
            Class superClass = classes[i].getSuperclass();
            if (superClass != null) {
                if (!((class$java$lang$Object != null ? class$java$lang$Object : ModelBuilder.class$("java.lang.Object")).equals(superClass) || this.contains(classes, superClass) || superClasses.contains(superClass))) {
                    superClasses.add(superClass);
                }
            } else {
                superClass = class$java$lang$Object != null ? class$java$lang$Object : ModelBuilder.class$("java.lang.Object");
            }
            try {
                BeanInfo bi = Introspector.getBeanInfo(classes[i], superClass);
                ClassDescription parent = model.get(classes[i]);
                ClassDescription cd = this.createClassDescription(bi, parent);
                if (cd != null) {
                    model.addClassDescription(cd);
                }
            }
            catch (IntrospectionException introspectionException) {}
            ++i;
        }
        return superClasses.toArray(new Class[0]);
    }

    private void fillSuperClasses(DescriptionModel model) {
        int i = 0;
        while (i < model.size()) {
            ClassDescription superCD;
            ClassDescription cd = model.get(i);
            Class parent = cd.getObjectClass().getSuperclass();
            if (parent != null && (superCD = model.get(parent)) != null) {
                cd.setSuperClass(superCD.getObjectClass());
            }
            ++i;
        }
    }

    private Class[] findElementTypes(DescriptionModel model) {
        ArrayList<Class> baseClasses = new ArrayList<Class>();
        int i = 0;
        while (i < model.size()) {
            ClassDescription cd = model.get(i);
            if (!baseClasses.contains(cd.getObjectClass())) {
                baseClasses.add(cd.getObjectClass());
            }
            PropertyInfo[] properties = cd.getProperties();
            int p = 0;
            while (p < properties.length) {
                Class type;
                if (properties[p].getPropertyType().equals(PropertyType.ELEMENT) && !baseClasses.contains(type = properties[p].getType()) && !Modifier.isFinal(type.getModifiers())) {
                    baseClasses.add(type);
                }
                ++p;
            }
            ++i;
        }
        return baseClasses.toArray(new Class[baseClasses.size()]);
    }

    private String getHandlerClass(Class c) {
        String handler;
        if (BasicTypeSupport.isBasicDataType(c) && (handler = BasicTypeSupport.getHandlerClass(c)) != null) {
            return handler;
        }
        return this.handlerMapping.getProperty(c.getName());
    }

    public static ModelBuilder getInstance() {
        if (instance == null) {
            instance = new ModelBuilder();
        }
        return instance;
    }

    private boolean isAttributeProperty(Class c) {
        if (BasicTypeSupport.isBasicDataType(c)) {
            return true;
        }
        return ((Hashtable)this.handlerMapping).containsKey(c.getName());
    }

    public static boolean isValidMethod(Method method) {
        if (method == null) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers());
    }
}

