/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task.util;

import java.util.Map;
import java.util.Iterator;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

/**
 * Dumps lots of information
 *
 * @version <pre>$Id: Dump.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class Dump
   extends Task
{
    /** Instance logger. */
    protected final TaskLogger log = new TaskLogger(this);

    protected boolean refs;
    protected boolean properties;
    protected boolean datatypes;
    protected boolean targets;
    protected boolean taskdefs;
    protected boolean filters;

    public void setRefs(boolean flag) {
        refs = flag;
    }

    public void setProperties(boolean flag) {
        properties = flag;
    }

    public void setProps(boolean flag) {
       setProperties(flag);
    }

    public void setDatatypes(boolean flag) {
        datatypes = flag;
    }

    public void setTargets(boolean flag) {
        targets = flag;
    }

    public void setTaskdefs(boolean flag) {
        taskdefs = flag;
    }
    
    public void setFilters(boolean flag) {
        filters = flag;
    }
    
    public void execute() throws BuildException {
        if (refs) dumpMap("References", getProject().getReferences());
        if (properties) dumpMap("Properties", getProject().getProperties());
        if (datatypes) dumpMap("DataTypes", getProject().getDataTypeDefinitions());
        if (targets) dumpMap("Targets", getProject().getTargets());
        if (taskdefs) dumpMap("Taskdefs", getProject().getTaskDefinitions());
        if (filters) dumpMap("Filters", getProject().getGlobalFilterSet().getFilterHash());
    }

    protected void dumpMap(final String name, final Map map) {
        log.info(name + ":");
        dumpMap(map, "  ");
        log.info("");
    }
    
    protected void dumpMap(final Map map, final String prefix) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = map.get(key);
            String classname = value.getClass().getName();
            log.info(prefix + key + "=" + value + " (" + classname + ")");
        }
    }
}
