/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.*;

/**
 * Thrown to indicate that an element is not supported by a task.
 *
 * @version $Id: UnsupportedElementException.java 21373 2008-08-05 19:10:51Z pgier $
 * @author  Jason Dillon <A href="mailto:jason@planet57.com">&lt;jason@planet57.com&gt;</A>
 */
public class UnsupportedElementException
   extends BuildException
{
   public UnsupportedElementException(String name, Task task) {
      super(task.getClass() + " does not support the '" + name + "' element.", 
            task.getLocation());
   }
}
