/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.*;

/**
 * Thrown to indicate that a task is missing a required attribute.
 *
 * @version <pre>$Id: MissingAttributeException.java 21373 2008-08-05 19:10:51Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class MissingAttributeException
   extends BuildException
{
   public MissingAttributeException(String name, Task task) {
      super(task.getClass() + " requires the '" + name + "' attribute.",
            task.getLocation());
   }
}
