/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.*;

/**
 * Thrown to indicate that a task attribute was set to an illegal value.
 *
 * @version $Id: IllegalAttributeException.java 21373 2008-08-05 19:10:51Z pgier $
 * @author  Jason Dillon <A href="mailto:jason@planet57.com">&lt;jason@planet57.com&gt;</A>
 */
public class IllegalAttributeException
   extends BuildException
{
   protected static String format(String name) {
      return "Illegal value for attribute '" + name + "'";
   }

   protected static String format(String name, String msg) {
      return format(name) + ": " + msg;
   }

   public IllegalAttributeException(String name, String msg, Location location) {
      super(format(name, msg), location);
   }

   public IllegalAttributeException(String name, String msg, Task task) {
      super(format(name, msg), task.getLocation());
   }

   public IllegalAttributeException(String name, Task task) {
      super(format(name), task.getLocation());
   }

   public IllegalAttributeException(String name, Location location) {
      super(format(name), location);
   }

   public IllegalAttributeException(String name) {
      super(format(name));
   }
}
