/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/stackobject.h
//! @brief A C++ base class for automatic (or stack) objects.
//!
//! Provides StackObject, a base class that declares 'operator new' and 'operator delete'
//! private, thereby forcing dervied objects to be created on the stack.

#ifndef INTI_STACK_OBJECT_H
#define INTI_STACK_OBJECT_H

#ifndef _CPP_CSTDDEF
#include <cstddef>
#endif

#if (__GNUC__ == 2 && __GNUC_MINOR__ <= 96)
#define INTI_SKIP_PRIVATE_DELETE // For GCC 2.95.x
#endif

namespace Inti {

//! @class StackObject stackobject.h inti/stackobject.h
//! @brief A C++ base class for automatic (or stack) objects.
//!
//! StackObject is a base class for automatic (or stack) objects. The purpose
//! of this class is to declare 'operator new' and 'operator delete' private,
//! thereby forcing derived objects to be created on the stack.

class StackObject
{
	StackObject(const StackObject&);
	StackObject& operator=(const StackObject&);

	static void *operator new(size_t size);
	static void *operator new[](size_t size);

#ifndef INTI_SKIP_PRIVATE_DELETE
	static void operator delete(void *ptr);
	static void operator delete[](void *ptr);
#endif

protected:
//! @name Constructors
//! @{

	StackObject();
	//!< Construct a new stack object.

//! @}

public:
//! @name Constructors
//! @{

	~StackObject();
	//!< Destructor.

//! @}
};

} // namespace Inti

#endif // INTI_STACK_OBJECT_H


