/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  radiobutton.cc - GtkRadioButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiobutton.h"
#include "private/radiobutton_p.h"

using namespace Inti;

/*  Gtk::RadioButton
 */

Gtk::RadioButton::RadioButton(GtkRadioButton *radio_button, bool reference)
: CheckButton((GtkCheckButton*)radio_button, reference)
{
}

Gtk::RadioButton::RadioButton()
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
}

Gtk::RadioButton::RadioButton(Group *group)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_group(group);
}

Gtk::RadioButton::RadioButton(const RadioButton *group)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_group(group ? group->get_group() : 0);
}

Gtk::RadioButton::RadioButton(const String& label, bool use_underline)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::RadioButton::RadioButton(Group *group, const String& label, bool use_underline)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_group(group);
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::RadioButton::RadioButton(const RadioButton *group, const String& label, bool use_underline)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_group(group ? group->get_group() : 0);
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::RadioButton::~RadioButton()
{
}

GtkRadioButtonClass* 
Gtk::RadioButton::gtk_radio_button_class() const 
{
	return get_class<GtkRadioButtonClass>(); 
}
	
Gtk::RadioButton::operator GtkRadioButton* () const 
{ 
	return this ? gtk_radio_button() : 0; 
}
	
Gtk::RadioButton::Group* 
Gtk::RadioButton::get_group() const
{
	return gtk_radio_button_group(gtk_radio_button());
}

void
Gtk::RadioButton::set_group(Group *group)
{
	gtk_radio_button_set_group(gtk_radio_button(), group);
}

/*  Gtk::RadioButtonClass
 */

void
Gtk::RadioButtonClass::init(GtkRadioButtonClass *g_class)
{
	CheckButtonClass::init((GtkCheckButtonClass*)g_class);
}

GType
Gtk::RadioButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RADIO_BUTTON, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::RadioButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::RadioButton::GroupPropertyType Gtk::RadioButton::group_property("group");

